<?php
	/*
		购物车的通用类
		2016-04-01 
		BY GLORY QQ:276369046
	*/
	class CartAPI {
		private $CartArray = array(); // 存放购物车的二维数组
		private $CartCount; // 统计购物车数量
		public $Expires = 2592000; // Cookies过期时间，如果为0则不保存到本地 单位为秒 86400一天 2592000一个月
		public $shopcode = '';
		/**
		 * 构造函数 初始化操作 
		 *
		 */
		public function __construct($shopcode) {
			$this->shopcode = $shopcode;
		}
		/**
		 * 添加商品到购物车
		 *	
		 * @param int $line 购物车商品序号			0
		 * @param int $Id 商品的编号				1
		 * @param int $shelf 上架ID					2
		 * @param int $Count 商品数量				3
		 * @param string $size 尺码					4
		 * @param string $color 颜色				5
		 * @param int $promotion 促销ID				6
		 * @param int $shopid 供货店家				7
		 * @return 如果商品存在，则在原来的数量上加1，并返回false
		 */
		public function addCart($Id,$shelf,$Count,$size,$color,$promotion,$shopid) {
			$this->CartArray = $this->CartView(); // 把数据读取并写入数组
			$line = $this->checkItem($Id,$shelf,$promotion,$size,$color);
			if ($line) { // 检测商品是否存在,统一商品，相同活动，相同价格
				$this->ModifyCart($line,$Id,$Count,0); // 商品数量加$Count
				return false;
			}else{
				//获取最大值
				$line_id = max(array_keys($this->CartArray[0]))+1;
			}
			$this->CartArray[0][$line_id] = $line_id;
			$this->CartArray[1][$line_id] = $Id;
			$this->CartArray[2][$line_id] = $shelf;
			$this->CartArray[3][$line_id] = $Count;
			$this->CartArray[4][$line_id] = $size;
			$this->CartArray[5][$line_id] = $color;
			$this->CartArray[6][$line_id] = $promotion;
			$this->CartArray[7][$line_id] = $shopid;
			$this->save();
		}
		/**
		 * 修改购物车里的商品
		 *
		 * @param int $Id 商品编号
		 * @param int $Count 商品数量
		 * @param int $Flag 修改类型 0：加 1:减 2:修改 3:清空
		 * @return 如果修改失败，则返回false
		 */
		public function ModifyCart($line,$Id, $Count, $Flag = "") {
			$delarr = explode(',',$line);
			if(count($delarr)==1){
				$tmpId = $line;
			}else{
				$tmpId = 0;
			}
			$this->CartArray = $this->CartView(); // 把数据读取并写入数组
			$tmpArray = &$this->CartArray;  // 引用
			if (!is_array($tmpArray[0])) return false;
			if ($line < 1) {
				return false;
			}
			$change = 0;
			foreach ($tmpArray[0] as $item) {
				$exe = false;
				if($tmpId){
					if (intval($item) === intval($tmpId)) {
						$exe = true;
					}
				}else{
					if(in_array(intval($item),$delarr)){
						$exe = true;
						$line = $item;
					}
				}
				if ($exe) {
					switch ($Flag) {
						case 0: // 添加数量 一般$Count为1
							$tmpArray[3][$line] += $Count;
							$change = $Count;
							break;
						case 1: // 减少数量
							$tmpArray[3][$line] -= $Count;
							$change = -$Count;
							break;
						case 2: // 修改数量
							if ($Count == 0) {
								unset($tmpArray[0][$line]);
								unset($tmpArray[1][$line]);
								unset($tmpArray[2][$line]);
								unset($tmpArray[3][$line]);
								unset($tmpArray[4][$line]);
								unset($tmpArray[5][$line]);
								unset($tmpArray[6][$line]);
								unset($tmpArray[7][$line]);
								break;
							} else {
								$change = $Count-$tmpArray[3][$line];
								$tmpArray[3][$line] = $Count;
								break;
							}
						case 3: // 清空商品
							unset($tmpArray[0][$line]);
							unset($tmpArray[1][$line]);
							unset($tmpArray[2][$line]);
							unset($tmpArray[3][$line]);
							unset($tmpArray[4][$line]);
							unset($tmpArray[5][$line]);
							unset($tmpArray[6][$line]);
							unset($tmpArray[7][$line]);
							break;
						default:
							break;
					}
				}
			}
			$this->save();
			return $change;
		}
		/**
		 * 清空购物车
		 *
		 */
		public function RemoveAll() {
			$this->CartArray = array();
			$this->save();
		}
		/**
		 * 查看购物车信息
		 *
		 * @return array 返回一个二维数组
		 */
		public function CartView() {
			$cookie = stripslashes($_COOKIE[md5($this->shopcode.$_SESSION['mem_id'])]);
			if (!$cookie) return false;
			$tmpUnSerialize = unserialize($cookie);
			return $tmpUnSerialize;
		}
		/**
		 * 查看购物车信息
		 *
		 * @return array 返回一个二维数组
		 */
		public function CartEmpty() {
			if(isset($_SESSION['mem_id'])){
				if($_SESSION['mem_id']){
					$cookie = stripslashes($_COOKIE[md5($this->shopcode)]);
					if (!$cookie) return false;
					$tmpUnSerialize = unserialize($cookie);
				}else{
					$tmpUnSerialize = '';
				}
			}else{
				$tmpUnSerialize = '';
			}
			return $tmpUnSerialize;
		}
		/**
		 * 合并没有登录的购物车
		 *
		 * @return bool 如果有商品，返回true，否则false
		 */
		public function CartJoin() {
			if(isset($_SESSION['mem_id'])){
				if($_SESSION['mem_id']){
					$emptCookie = stripslashes($_COOKIE[md5($this->shopcode)]);
					if($emptCookie){
						$emptyArray = unserialize($emptCookie);
						$tmpArray = $this->CartView();
						if($tmpArray){
							//循环没有登录的数组，判断有没有ID在登录的数组中,有修改登录数组的数量（累加），没有增加一条道登录数组
							foreach ($emptyArray[0] as $item) {
								$id	= $emptyArray[1][$item];//商品的编号
								$shelf = $emptyArray[2][$item];//上架ID
								$promotion = $emptyArray[6][$item];//促销ID
								$size = $emptyArray[4][$item];//颜色
								$color = $emptyArray[5][$item];//尺码  ,$size,$color
								if ($this->joinItem($item,$id,$shelf,$promotion,$size,$color,$tmpArray)) { // 检测商品是否存在
									//数量累加
									$tmpArray[3][$item]= $tmpArray[3][$item]+$emptyArray[3][$item];
								}else{
									$line_id = count($tmpArray[0])+1;
									//添加数组
									$tmpArray[0][$line_id]= $emptyArray[0][$item];
									$tmpArray[1][$line_id]= $emptyArray[1][$item];
									$tmpArray[2][$line_id]= $emptyArray[2][$item];
									$tmpArray[3][$line_id]= $emptyArray[3][$item];
									$tmpArray[4][$line_id]= $emptyArray[4][$item];
									$tmpArray[5][$line_id]= $emptyArray[5][$item];
									$tmpArray[6][$line_id]= $emptyArray[6][$item];
									$tmpArray[7][$line_id]= $emptyArray[7][$item];
								}
							}
							$this->CartArray = $tmpArray;
							$this->save();
						}else{
							$this->CartArray = $emptyArray;
							$this->save();
							unset($emptCookie,$emptyArray);
						}
						//清空未登录的购物车
						$this->CartArray = array();
						$tmpArray = $this->CartArray;
						$tmpSerialize = serialize($tmpArray);
						setcookie(md5($this->shopcode),$tmpSerialize,time()+$this->Expires);
					}
					unset($emptCookie,$tmpUnSerialize);
				}
			}
		}
		/**
		 * 检查未登录COOKIE在登录COOKIE中是否存在
		 *
		 * @param int $Id
		 * @param int $logArray 登录的数组
		 * @return bool 如果存在 true 否则false
		 */
		private function joinItem($line,$id,$shelf,$promotion,$size,$color,$logArray) {
			if (!is_array($logArray[0])) return;
			foreach ($logArray[0] as $item) {
				$gid	= $logArray[1][$item];//商品的编号
				$gshelf = $logArray[2][$item];//上架ID
				$gpromotion = $logArray[6][$item];//活动ID
				$gsize = $logArray[4][$item];//颜色
				$gcolor = $logArray[5][$item];//尺码
				//if ($item === $line) return true;
				if ($gid === $id && $gshelf === $shelf && $gpromotion === $promotion && $gsize === $size && $gcolor === $color) return true;
			}
			return false;
		}

		/**
		 * 检查购物车是否有商品
		 *
		 * @return bool 如果有商品，返回true，否则false
		 */
		public function checkCart() {
			$tmpArray = $this->CartView();
			if (count($tmpArray[0]) < 1) {			
				return false;
			}
			return true;
		}
		/**
		 * 商品统计
		 *
		 * @return array 返回一个一维数组 $arr[0]:产品1的总价格 $arr[1:产品2得总价格 $arr[2]:产品3的总价格 $arr[3]:产品的总数量
		 */
		public function CountPrice() {
			$tmpArray = $this->CartArray = $this->CartView();
			$outArray = array(); //一维数组
			// 0 是产品市场价的总价格
			// 1 是产品现价的总价格
			// 2 是产品加收比例的总价格
			// 3 是产品的总数量
			$i = 0;
			if (is_array($tmpArray[0])) {
				foreach ($tmpArray[0] as $key=>$val) {
					//$outArray[0] += $tmpArray[3][$key] * $tmpArray[6][$key];
					//$outArray[1] += $tmpArray[4][$key] * $tmpArray[6][$key];
					//$outArray[2] += $tmpArray[5][$key] * $tmpArray[6][$key];
					//$outArray[3] += $tmpArray[6][$key];
					$i++;
				}
			}
			return $outArray;
		}
		/**
		 * 统计条数数量
		 *
		 * @return int
		 */
		public function CartCount() {
			$tmpArray = $this->CartView();
			$tmpCount = count($tmpArray[0]);
			$this->CartCount = $tmpCount;
			return $tmpCount;
		}
		/**
		 * 统计商品数量
		 *
		 * @return int
		 */
		public function CartNumber() {
			$tmpArray = $this->CartArray = $this->CartView();
			$i = 0;
			$tmpCount = 0;
			if (is_array($tmpArray[0])) {
				foreach ($tmpArray[0] as $key=>$val) {
					$tmpCount += $tmpArray[3][$key];
					$i++;
				}
			}
			return $tmpCount;
		}
		/**
		 * 保存商品 如果不使用构造方法，此方法必须使用
		 *
		 */
		public function save() {
			$tmpArray = $this->CartArray;
			$tmpSerialize = serialize($tmpArray);
			$aa = setcookie(md5($this->shopcode.$_SESSION['mem_id']),$tmpSerialize,time()+$this->Expires);
		}
		/**
		 * 检查购物车商品是否存在
		 *
		 * @param int $Id
		 * @return bool 如果存在 true 否则false
		 */
		private function checkItem($Id,$shelf,$promotion,$size,$color) {
			$tmpArray = $this->CartArray;
			if (!is_array($tmpArray[0])) return;
			foreach ($tmpArray[0] as $item) {
				$gid	= $tmpArray[1][$item];//商品的编号
				$gshelf = $tmpArray[2][$item];//上架ID
				$gpro	= $tmpArray[6][$item];//促销ID
				$gsize	= $tmpArray[4][$item];//颜色
				$gcolor	= $tmpArray[5][$item];//尺码
				if ($gid === $Id && $gshelf === $shelf && $gpro === $promotion && $gsize === $size && $gcolor === $color) return $item;
			}
			return false;
		}
		/**
		 * 检查购物车商品是否合法
		 *
		 * @param int $Id
		 * @return bool 如果存在 true 否则false
		 */
		private function checkCartTime($tmpArray) {
			global $db,$ass;
			if (!is_array($tmpArray[0])) return;
			foreach ($tmpArray[0] as $item) {
				$gid	= $tmpArray[1][$item]; //商品的编号
				$gshelf = $tmpArray[2][$item]; //上架ID
				$gpro	= $tmpArray[6][$item];//促销ID
				$gshelf	= $tmpArray[13][$item];//上架ID
				if ($gid === $Id && $gshelf === $shelf && $gpro === $promotion) return $item;
			}
			return false;
		}
		public function saveOrder($idstr,$divide,$earnest,$group='N'){
			global $db,$ass,$shop,$sell,$common;
			$one = $ass->one('company','','comp_id="'.$shop['comp_id'].'"');
			$comp_taxrate = $one['comp_taxrate'];
			$idArr = explode(",",$idstr);
			$tmpArray = $this->CartView();
			$shelfstr = "";
			$goodsArr = array();
			$shoparr = array();
			foreach ($tmpArray[0] as $item) {
				if(in_array(intval($item),$idArr)){
					//$one = $ass->one('goods_sizecolor','sizec_price','goods_id="'.$tmpArray[1][$item].'" and sizec_shop='.$sell['shop_id']);
					$one = $ass->one('goods_sizecolor','sizec_price','goods_id="'.$tmpArray[1][$item].'" and sizec_size="'.$tmpArray[4][$item].'" and sizec_color="'.$tmpArray[5][$item].'" and sizec_shop='.$sell['shop_id']);
					$goodsArr[$tmpArray[0][$item]] = array(
						'gid' => $tmpArray[1][$item],
						'shelf' => $tmpArray[2][$item],
						'size' => $tmpArray[4][$item],
						'color' => $tmpArray[5][$item],
						'number' => $tmpArray[3][$item],
						'price' => $one['sizec_price'],
					);
					if($_SESSION['PT']){
						if($shoparr[$tmpArray[7][$item]]){
							$shoparr[$tmpArray[7][$item]] .= ','.$tmpArray[2][$item];
						}else{
							$shoparr[$tmpArray[7][$item]] = $tmpArray[2][$item];
						}
					}else{
						if($shoparr[$tmpArray[7][$item]]){
							$shoparr[$shop['shop_id']] .= ','.$tmpArray[2][$item];
						}else{
							$shoparr[$shop['shop_id']] = $tmpArray[2][$item];
						}
					}
					if($shelfstr){
						$shelfstr.= ','.$tmpArray[2][$item];
					}else{
						$shelfstr = $tmpArray[2][$item];
					}
				}
			}
			$batch = "";
			$spreaderGoods = 0;
			$spreader_mem = 0;
			$isspreader = false;
			if($_SESSION['spreader']){
				//或是用户是否分销
				$spreader = $ass->one('member','mem_id,mem_identity','mem_invitecode="'.$_SESSION['spreader'].'"');
				//$collect = $ass->one('member_collect','','shop_id='.$shop['shop_id'].' and mem_id='.$spreader['mem_id']);
				$spreader_mem = $spreader['mem_id'];
				$spreaderGoods = $_SESSION['spreaderGoods'];
				if($spreader['mem_identity']=='B'){
					$isspreader = true;
				}
			}
			foreach($shoparr as $key => $line){
				$sql = 'select A.*,B.goods_image,B.goods_mart,B.goods_code,B.goods_name,B.goods_addprice';
				$sql.= ',B.goods_variety,B.goods_addprice,B.goods_commission,B.goods_entrycode';
				$sql.= ',C.class_name,D.shop_name,E.product_cess,E.product_remark,E.product_duty ';
				$sql.= 'from '.$ass->table('goods_shop').' as A ';
				$sql.= 'inner join '.$ass->table('goods').' as B ON A.goods_id=B.goods_id ';
				$sql.= 'inner join '.$ass->table('goods_class').' as C ON B.goods_class=C.class_id ';
				$sql.= 'inner join '.$ass->table('shop').' as D ON A.goods_shop=D.shop_id ';
				$sql.= 'left join '.$ass->table('product').' as E ON B.goods_product=E.product_id ';
				$sql.= 'where A.shelf_id in ('.$line.')';

				//$sql.= 'where A.shelf_id in ('.$shelfstr.')';
				$rst = $db->query($sql);
				$orderArryIn = array();
				$orderArryOut = array();
				$frontArryIn = array();
				$frontArryOut = array();
				$FSORTIN = array();
				$FSORTOUT = array();
				$OSORTIN = array();
				$OSORTOUT = array();
				while($row=$db->fetch_array($rst)){
					if($isspreader){
						$goods_spreader = $spreader_mem;
					}else{
						if($spreaderGoods==$row['goods_id']){
							$goods_spreader = $spreader_mem;
						}
					}
					foreach($goodsArr as $gkey => $gline){
						if($row['goods_id']==$gline['gid']){
							$data = array(
								'goods_id'=>$row['goods_id'],
								'goods_name'=>$row['goods_name'],
								'goods_code'=>$row['goods_code'],
								'goods_number'=>$gline['number'],
								'goods_price'=>$gline['price'],//价格
								'goods_classe'=>$row['class_name'],//类别
								'goods_add'=>$row['goods_addprice']*$gline['price']/100*$gline['number'],//商品附加费
								'goods_commission'=>$row['goods_commission']*$gline['price']/100*$gline['number'],//佣金
								'goods_entrycode'=>$row['goods_entrycode'],//报关码
								'goods_size'=>$gline['size'],//尺码
								'goods_color'=>$gline['color'],//颜色
								'goods_mart'=>$row['goods_mart'],//市场价
								'goods_image'=>$row['goods_image'],
								'goods_shelf'=>$row['shelf_id'],//上架ID
								'goods_cess'=>$row['product_cess']*$gline['price']*$gline['number'],//关税
								'goods_traffic'=>$row['goods_traffic']*$gline['number'],//运费
								'goods_shop'=>$row['goods_shop'],
								'goods_overseas'=>$row['define_overseas'],//采购地如果是国内没有税
								'goods_mail'=>$row['define_mail'],//包邮
								'goods_custom'=>$row['define_custom'],//包关
								'goods_quality'=>$row['define_quality'],//全新，二手
								'goods_spot'=>$row['define_spot'],//现货
								'goods_invoice'=>$row['define_invoice'],//提供发票
								'goods_repair'=>$row['define_repair'],//保修服务
								'goods_change'=>$row['define_change'],//退换货承诺
								'goods_service'=>$row['define_service'],//服务承诺
								'goods_subtract'=>$row['define_subtract'],//库存计数 Y买家拍下减库存，N买家付款减库存
								'goods_discount'=>$row['define_discount'],//会员打折
								'product_remark'=>$row['product_remark'],//会员打折
								'goods_money'=>$gline['price']*$gline['number'],//会员打折
								'goods_spreader'=>$goods_spreader,//推广分享人
							);
							if($data['goods_overseas']=='N'){//国内 国内都是现货
								$orderArryIn[]= $data;
								$OSORTIN[] = $gline['price']*$gline['number'];
							}else{//海外以及港澳台
								if($earnest>0 and $data['goods_spot']=='N'){
									$frontArryOut[]= $data;
									$FSORTOUT[] = $gline['price']*$gline['number'];
								}else{
									$orderArryOut[]= $data;
									$OSORTOUT[] = $gline['price']*$gline['number'];
								}
							}
							//break;
						}
					}
				}
				array_multisort($FSORTIN,SORT_DESC,$frontArryIn);//国内预订单
				array_multisort($FSORTOUT,SORT_DESC,$frontArryOut);//国外预订单
				array_multisort($OSORTIN,SORT_DESC,$orderArryIn);//国外订单
				array_multisort($OSORTOUT,SORT_DESC,$orderArryOut);//国外预订单
				$maxMoney = $divide>0?$divide:0;
				if($frontArryIn){
					$pickup = $this->divideBill(0,$frontArryIn,$earnest,$batch,$key);
					if(!$batch)$batch = $pickup;
				}
				if($frontArryOut){
					$pickup = $this->divideBill($maxMoney,$frontArryOut,$earnest,$batch,$key);
					if(!$batch)$batch = $pickup;
				}
				if($orderArryIn){
					$pickup = $this->divideBill(0,$orderArryIn,0,$batch,$key);
					if(!$batch)$batch = $pickup;
				}
				if($orderArryOut){
					$pickup = $this->divideBill($maxMoney,$orderArryOut,0,$batch,$key);
					if(!$batch)$batch = $pickup;
				}
			}
			$this->delCartOrder($idArr);
			return $batch;
		}
		
		/**
		 * 分单函数
		 *
		 * @param string $divide 每单最大金额 
		 * @param double $orderArry 分单数组
		  * @return bool 如果成功 true 否则false
		 */
		public function divideBill($divide,$orderArry,$earnest,$batch,$supply){
			global $db,$ass,$shop,$common;
			$address = $ass->one('member_address','','address_default="Y" and mem_id='.$_SESSION['mem_id']);
			$one = $ass->one('company','','comp_id="'.$shop['comp_id'].'"');
			$taxrate = $one['comp_taxrate'];//消费税
			//订金为 商品价格*订金比例+运费+商品附加费+关税+消费税
			//分单
			$pickup = "";
			$sumxftax = 0;//消费税
			$sumsptax = 0;//商品税
			$sumjstax = 0;//商品加收
			$sumfreight = 0;//运费
			$sumearnest = 0;//总订金
			$sumgprice = 0;//商品总额
			while($orderArry){
				$ids = $this->getNearArr($divide,$orderArry);
				$idarr = explode(',',$ids);
				$goodsList = array();
				$orderGprice	= 0;//商品金额
				$orderNum		= 0;//订单数量
				$orderMoney		= 0;//订单金额
				$orderEarnest	= 0;//订金金额
				$orderCommission= 0;//佣金金额
				$xftax = 0;//消费税
				$sptax = 0;//商品税
				$jstax = 0;//商品加收
				$freight = 0;//运费
				$gcount=0;
				for($i=0;$i<count($idarr);$i++){
					$k = $idarr[$i];
					$gcount+=$orderArry[$k]['goods_number'];
					$goodsList[] = array(
						'goods_id'			=>	$orderArry[$k]['goods_id'],
						'goods_name'		=>	$orderArry[$k]['goods_name'],
						'goods_code'		=>	$orderArry[$k]['goods_code'],
						'goods_number'		=>	$orderArry[$k]['goods_number'],
						'goods_price'		=>	$orderArry[$k]['goods_price'],
						'goods_classe'		=>	$orderArry[$k]['goods_classe'],
						'goods_add'			=>	$orderArry[$k]['goods_add'],
						'goods_commission'	=>	$orderArry[$k]['goods_commission'],//佣金
						'goods_entrycode'	=>	$orderArry[$k]['goods_entrycode'],//报关码
						'goods_size'		=>	$orderArry[$k]['goods_size'],//尺码
						'goods_color'		=>	$orderArry[$k]['goods_color'],//颜色
						'goods_mart'		=>	$orderArry[$k]['goods_mart'],//市场价
						'goods_image'		=>	$orderArry[$k]['goods_image'],//颜色
						'goods_shelf'		=>	$orderArry[$k]['goods_shelf'],//上架ID
						'goods_overseas'	=>	$orderArry[$k]['goods_overseas'],//采购地
						'goods_mail'		=>	$orderArry[$k]['goods_mail'],//包邮
						'goods_custom'		=>	$orderArry[$k]['goods_custom'],//包关
						'goods_quality'		=>	$orderArry[$k]['goods_quality'],//全新
						'goods_spot'		=>	$orderArry[$k]['goods_spot'],//现货
						'goods_invoice'		=>	$orderArry[$k]['goods_invoice'],//提供发票
						'goods_repair'		=>	$orderArry[$k]['goods_repair'],//保修服务
						'goods_change'		=>	$orderArry[$k]['goods_change'],//退换货承诺
						'goods_service'		=>	$orderArry[$k]['goods_service'],//服务承诺
						'goods_subtract'	=>	$orderArry[$k]['goods_subtract'],//库存计数 Y买家拍下减库存，N买家付款减库存
						'goods_discount'	=>	$orderArry[$k]['goods_discount'],//会员打折
						'goods_supply'		=>	$orderArry[$k]['goods_shop'],//会员打折
						'goods_spreader'	=>	$orderArry[$k]['goods_spreader'],//会员打折
					);
					$jstax += $orderArry[$k]['goods_add'];//商品加收
					$sumjstax	+= $orderArry[$k]['goods_add'];//商品加收
					if($orderArry[$k]['goods_mail']=='Y'){
						$freight = 0;
					}else{
						$freight += $orderArry[$k]['goods_traffic'];//运费
						$sumfreight += $orderArry[$k]['goods_traffic'];//运费
					}
					if($orderArry[$k]['goods_custom']=='N' and $orderArry[$k]['goods_overseas']=='Y'){
						$sptax += $orderArry[$k]['goods_cess'];//商品税（关税）
						$sumsptax += $orderArry[$k]['goods_cess'];//商品税
						$xftax += $taxrate*$orderArry[$k]['goods_money']/100;//消费税 
						$sumxftax += $taxrate*$orderArry[$k]['goods_money']/100;//消费税
					}
					$orderCommission+=$orderArry[$k]['goods_commission'];
					$orderGprice+= $orderArry[$k]['goods_money'];//商品金额
					$orderNum	+= $orderArry[$k]['goods_number'];//订单数量
					unset($orderArry[$idarr[$i]]);
				}
				//订单金额  商品价格*订金比例+商品加收+运费+商品税（关税）+消费税
				$orderMoney	  = $orderGprice+$jstax+$freight+$sptax+$xftax;
				//订金金额
				if($earnest>0){
					$orderEarnest = $orderGprice*$earnest/100+$jstax+$freight+$sptax+$xftax;
					$sumearnest+= $orderEarnest;
					$part = 'Y';
				}else{
					$orderEarnest = 0;
					$part = 'N';
				}
				if($divide>0){
					if($orderMoney<=$divide){
						$sptax = 0;
					}
				}else{
				}
				$glide = $this->getGlide('front','bill_glide');
				//if(!$pickup)$pickup = $glide;
				if(!$pickup)$pickup = $this->getPickCode();
				if(!$batch)$batch = $pickup;
				//$status = $earnest>0?'1':'3';
				$status = 1;
				$supply = $supply?$supply:$shop['shop_id'];
				$daofu = false;
				//如果发货店铺是到付，订单就是到付
				//$bill_paytype = 'zhijie';
				//if($supply){
					//$supshop=$ass->one('shop','','shop_id='.$supply);
					//if($supshop['shop_daofu']=='Y'){
					//	$daofu = true;
					//	$bill_paytype = 'daofu';
					//}
				//}
				$data = array(
					'bill_type'		=>	'YSG',
					'come_time'		=>	date("Y-m-d H:i:s"),
					'mobile_number'	=>	$_SESSION['mem_hand'],
					'from_nick'		=>	$_SESSION['mem_name'],
					'member_id'		=>	$_SESSION['mem_id'],
					'front_from'	=>	'YSG',
					'bill_status'	=>	$status,
					'bill_ordertime'=>	date("Y-m-d H:i:s"),
					'bill_pickup'	=>	$pickup,
					'bill_glide'	=>	$glide,
					'bill_part'		=>	$part,
					'shop_id'		=>	$shop['shop_id'],
					'bill_comp'		=>	$shop['comp_id'],
					'shop_name'		=>	$shop['shop_name'],
					'from_shop'		=>	$shop['shop_code'],//店铺编号
					'bill_supply'	=>	$supply,
					'bill_copies'	=>	$gcount,
					'bill_commission'=>	$orderCommission,//佣金
					'goods_money'	=>	$orderMoney,//订单金额
					'bill_gprice'	=>	$orderGprice,//商品金额
					'goods_number'	=>	$orderNum,//商品数量
					'bill_useearnest'=>	$orderEarnest,//使用订金
					'bill_xftax'	=>	$xftax,//消费税
					'bill_hgtax'	=>	$sptax,//商品关税
					'bill_append'	=>	$jstax,//商品加收
					'bill_freight'	=>	$freight,//运费
					'bill_batch'	=>	$batch,//订单批次
					//'bill_paytype'	=>	$bill_paytype,
					'receiver_name'	=>	$address['address_mem'],//订单批次
					'receiver_addr'	=>	$address['province_name'].$address['city_name'].$address['region_name'].$address['address_info'],//订单批次
					'receiver_hand'	=>	$address['address_hand'],//订单批次
					'receiver_idcard'=>	$address['address_idcard'],//订单批次
					'bill_spreader'=>	$_SESSION['spreader']?$_SESSION['spreader']:0,//分享
				);
				if($ass->insert('front',$data)){
					$order_id = $db->insert_id();
					foreach($goodsList as $key => $line){
						$line['bill_id'] = $order_id;
						$line['goods_line'] = $db->table_max('msm_front_child','goods_line','bill_id='.$order_id);
						if($line['goods_id']>0){
							$goods = $ass->one('goods','','goods_id='.$goods_id);
							$line['goods_mart'] = $goods['goods_mart'];
						}
						$line['goods_sell'] = $line['goods_price'];
						$line['goods_truesell'] = $line['goods_price'];
						if($ass->insert('front_child',$line)){
							$exe = false;
						}
					}
					$act = $earnest>0?'book_bill':'front_bill';
					$info = $earnest>0?'下预订单':'下订单';
					if($daofu){
						$info = '到付订单';
					}
					$billid		= $order_id;
					$glide		= $glide;
					$money		= $orderMoney;
					$memid		= $_SESSION['mem_id'];
					$memname	= $_SESSION['mem_name'];
					$userid		= 0;
					$username	= '系统';
					$codeid		= $billid;
					$code		= $glide;
					$memo		= "等待商家接单！";
					$common->orderLog($billid,$glide,$act,$info,$money,$memid,$memname,$userid,$username,$codeid,$code,$memo,'Y');
				}
			}
			//修改订金
			if($earnest>0){
				$dataFront = array(
					'bill_earnest'=>$sumearnest,//订金
				);
				if($ass->update('front',$dataFront,'bill_pickup="'.$pickup.'" and bill_glide="'.$pickup.'"')){
				}
			}
			if(!$exe){
				return $pickup;
			}else{
				return false;
			}
		}
		
		/**
		 * 获取最接近 $max 且小于$max的数组
		 *
		 * @param string $max 最大和 
		 * @param double $temp 数组
		 * @return $keys 返回的数组key 
		 */
		public function getNearArr($max,$temp){
			$sum = 0;
			$tempsum = 0;
			$keys = '';
			foreach($temp as $key => $line){
				if($max>0){
					if($line['goods_money']>$max){
						$keys.= $key.',';
						break;
					}else{
						$tempsum = $sum + $line['goods_money'];
						if($tempsum<=$max){
							$sum += $line['goods_money'];
							$keys.= $key.',';
						}
					}
				}else{
					$keys.= $key.',';
				}
			}
			return substr($keys, 0, -1);
		}
		/**
		 * 分单
		 *
		 * @param string $idstr 购物车ID 
		 * @param double $divide 分单金额 
		 * @param double $earnest 订金比例 
		 * @return bool 如果存在 true 否则false
		 */
		public function divideOrder($idstr,$divide,$earnest,$group='N'){
			global $db,$ass,$shop,$common;
			$one = $ass->one('company','','comp_id="'.$shop['comp_id'].'"');
			$comp_taxrate = $one['comp_taxrate'];
			
			$idArr = explode(",",$idstr);
			$tmpArray = $this->CartView();
			foreach ($tmpArray[0] as $item) {
				$shopDD[] = $tmpArray[8][$item];
			}
			array_multisort($shopDD,SORT_DESC,$tmpArray[0]);
			$shoparr = array();
			$orderMax = 0;
			$orderMoney = 0;
			$orderNum = 0;
			$sumGprice = 0;
			
			$sumxftax = 0;//消费税
			$sumsptax = 0;//商品税
			$sumjstax = 0;//商品加收
			$sumfreight = 0;//运费
			
			if($earnest>0){
				$bill_part ="Y";
			}else{
				$bill_part ="N";
			}
			$exe = true;
			//comp_taxrate 消费税率
			//bill_xftax 消费税
			//bill_hgtax 关税
			//bill_append 商品的附加费
			//bill_freight 运费
			//订金为 商品价格*订金比例+运费+商品附加费+关税+消费税
			$pickup = "";
			foreach ($tmpArray[0] as $item) {
				if(in_array(intval($item),$idArr)){
					if(!isset($shoparr[$tmpArray[8][$item]])){
						$shoparr[$tmpArray[8][$item]] = array();
						$orderMax = 0;
						$orderMoney = 0;
						$orderNum = 0;
						$orderEarnest = 0;
						$xftax = 0;//消费税
						$sptax = 0;//商品税
						$jstax = 0;//商品加收
						$freight = 0;//运费
						$glide = $this->getGlide('front','bill_glide');
						//if(!$pickup)$pickup = $glide;
						if(!$pickup)$pickup = $this->getPickCode();
						//一个店家,主单
						$data = array(
							'bill_type'		=>	'YSG',
							'come_time'		=>	date("Y-m-d H:i:s"),
							'mobile_number'	=>	$_SESSION['mem_hand'],
							'from_nick'		=>	$_SESSION['mem_name'],
							'member_id'		=>	$_SESSION['mem_id'],
							'front_from'	=>	'YSG',
							'bill_status'	=>	'3',
							'bill_ordertime'=>	date("Y-m-d H:i:s"),
							'bill_pickup'	=>	$pickup,
							'bill_glide'	=>	$glide,
							'bill_part'		=>	$bill_part,
							'shop_id'		=>	$shop['shop_id'],
							'bill_comp'		=>	$shop['comp_id'],
							'shop_name'		=>	$tmpArray[8][$item],
							'from_shop'		=>	$shop['shop_code'],//店铺编号
							'bill_supply'	=>	$tmpArray[9][$item]
						);
						if($ass->insert('front',$data)){
							$order_id = $db->insert_id();
						}else{
							$exe = false;
						}
					}
					$orderMax += $tmpArray[6][$item]*$tmpArray[4][$item];
					if($divide>0){
						if($orderMax>$divide){
							$orderMax = $tmpArray[6][$item]*$tmpArray[4][$item];
							$orderMoney = 0;
							$orderNum = 0;
							$xftax = 0;//消费税
							$sptax = 0;//商品税
							$jstax = 0;//商品加收
							$freight = 0;//运费
							$glide = $this->getGlide('front','bill_glide');
							$data = array(
								'bill_type'		=>	'YSG',
								'come_time'		=>	date("Y-m-d H:i:s"),
								'mobile_number'	=>	$_SESSION['mem_hand'],
								'from_nick'		=>	$_SESSION['mem_name'],
								'member_id'		=>	$_SESSION['mem_id'],
								'front_from'	=>	'YSG',
								'bill_status'	=>	'3',
								'bill_ordertime'=>	date("Y-m-d H:i:s"),
								'bill_pickup'	=>	$pickup,
								'bill_glide'	=>	$glide,
								'bill_part'		=>	$bill_part,
								'shop_id'		=>	$shop['shop_id'],
								'bill_comp'		=>	$shop['comp_id'],
								'shop_name'		=>	$tmpArray[8][$item],
								'from_shop'		=>	$shop['shop_code'],//店铺编号
								'bill_supply'	=>	$tmpArray[9][$item]
							);
							if($ass->insert('front',$data)){
								$order_id = $db->insert_id();
							}else{
								$exe = false;
							}
						}
					}
					$orderMoney += $tmpArray[6][$item]*$tmpArray[4][$item];
					$orderNum += $tmpArray[6][$item];
					$number = $tmpArray[6][$item];
					//本次购买的所有商品金额
					$sumGprice += $tmpArray[6][$item]*$tmpArray[4][$item];
					//13是上架ID
					//商品信息
					$goodsInfo = $this->getGoodsCess($divide,$tmpArray[1][$item],$tmpArray[4][$item],$tmpArray[13][$item]);
					
					$xftax = $orderMoney*$comp_taxrate/100;//消费税
					$sptax += $goodsInfo['moneyCess']*$number;//商品税
					$jstax += $goodsInfo['moneyAdd']*$number;//商品加收
					$freight += $goodsInfo['moneyTraffic']*$number;//运费
					
					$sumxftax	+= $xftax;//消费税
					$sumsptax	+= $goodsInfo['moneyCess']*$number;//商品税
					$sumjstax	+= $goodsInfo['moneyAdd']*$number;//商品加收
					$sumfreight += $goodsInfo['moneyTraffic']*$number;//运费
					
					//插入明细单
					//$goods = $ass->one('goods','','goods_id="'.$tmpArray[1][$item].'"');
					$line = $db->table_max('msm_front_child','goods_line','bill_id='.$order_id);
					$goods_mart = $tmpArray[4][$item];
					if($tmpArray[1][$item]>0){
						$goods = $ass->one('goods','','goods_id='.$tmpArray[1][$item]);
						$goods_mart = $goods['goods_mart'];
					}
					$dataChild = array(
						'bill_id'		=>	$order_id,
						'goods_line'	=>	$line,
						'goods_id'		=>	$tmpArray[1][$item],
						'goods_name'	=>	$tmpArray[2][$item],
						'goods_code'	=>	$goodsInfo['goodsCode'],
						'goods_number'	=>	$tmpArray[6][$item],
						'goods_price'	=>	$tmpArray[4][$item],
						'goods_sell'	=>	$tmpArray[4][$item],
						'goods_mart'	=>	$goods_mart,
						'goods_classe'	=>	$goodsInfo['className'],
						'goods_add'		=>	$goodsInfo['moneyAdd'],//附加费
						'goods_commission'	=>	$goodsInfo['moneyYjin'],//佣金
						'goods_entrycode'	=>	$goodsInfo['entrycode'],//报关码
						'goods_shelf'	=>	$tmpArray[13][$item],//上架ID
						'goods_size'	=>	$tmpArray[14][$item],//尺码
						'goods_color'	=>	$tmpArray[15][$item]//颜色
					);
					if(!$ass->insert('front_child',$dataChild)){
						$exe = false;
					}
					$orderEarnest = $orderMoney*$earnest/100+$xftax+$sptax+$jstax+$freight;
					$sumOrderMoney = $orderMoney+$xftax+$sptax+$jstax+$freight;
					$dataFront = array(
						'goods_money'=>$sumOrderMoney,//订单金额
						'bill_gprice'=>$orderMoney,//商品金额
						'goods_number'=>$orderNum,//商品数量
						//'bill_earnest'=>$bill_earnest,//订金
						'bill_useearnest'=>$orderEarnest,//使用订金
						'bill_xftax'=>$xftax,//消费税
						'bill_hgtax'=>$sptax,//商品关税
						'bill_append'=>$jstax,//商品加收
						'bill_freight'=>$freight//运费
					);
					if(!$ass->update('front',$dataFront,'bill_id='.$order_id)){
						$exe = false;
					}
				}
			}
			$act = "front_bill";
			$info = "下订单";
			if($earnest>0){
				$bill_earnest = $earnest * $sumGprice/100+$sumxftax+$sumsptax+$sumjstax+$sumfreight;
				$dataFront = array(
					'bill_earnest'=>$bill_earnest,//订金
				);
				if($ass->update('front',$dataFront,'bill_pickup="'.$pickup.'" and bill_glide="'.$pickup.'"')){
				}
				if($ass->update('front',array('bill_status'=>'1'),'bill_pickup="'.$pickup.'"')){
				}
				$act = "book_bill";
				$info = "下预订单";
			}
			$sql = 'select * from '.$ass->table('front').' where bill_pickup="'.$pickup.'"';
			$rst = $db->query($sql);
			$_FCHILD = array();			
			while($row=$db->fetch_array($rst)){
				//$act = "book_bill  , front_bill ";
				//$info = "下预订单";
				$billid		= $row['bill_id'];
				$glide		= $row['bill_glide'];
				$money		= $row['goods_money'];
				$memid		= $_SESSION['mem_id'];
				$memname	= $_SESSION['mem_name'];
				$userid		= 0;
				$username	= '系统';
				$codeid		= $billid;
				$code		= $glide;
				$memo		= "订单金额:".$money.",商品金额:".$row['bill_gprice'].",运费:".$row['bill_freight'].",商品附加费:".$row['bill_append'].",折扣金额:".$row['bill_rebate'].",预付订金:".$row['bill_earnest'].",消费费税:".$row['bill_xftax'].",海关税:".$row['bill_hgtax'];
				$common->orderLog($billid,$glide,$act,$info,$money,$memid,$memname,$userid,$username,$codeid,$code,$memo,'Y');
			}
			/*
				单据流水日志
				orderLog($billid,$glide,$act,$info,$money,$memid,$memname,$userid,$username,$codeid,$code,$memo,$state)
				billid 单据ID
				glide 单据流水号
				act 操作事件 front_bill 下订单 book_bill 下预订单
				info 操作内容
				money 操作金额
				memid 客户ID
				userid 用户ID
				username 用户名称
				codeid 操作单号ID
				code 操作单号
				memo 备注信息
				state 是否操作成功
			*/
			
			//删除购物车已经提交商品
			$this->delCartOrder($idArr);
			return $pickup;
		}
	    /**
		 * 删除购物车提交商品
		 *
		 * @param string $order 提交数组 
		 * @param double
		 * @return string 
		 */
		public function delCartOrder($order){
			$tmpArray = $this->CartView();
			foreach ($tmpArray[0] as $item) {
				if(in_array(intval($item),$order)){
					unset($tmpArray[0][$item]);
					unset($tmpArray[1][$item]);
					unset($tmpArray[2][$item]);
					unset($tmpArray[3][$item]);
					unset($tmpArray[4][$item]);
					unset($tmpArray[5][$item]);
					unset($tmpArray[6][$item]);
				}
			}
			$this->CartArray = $tmpArray;
			$this->save();
			return true;
		}
		/**
		 * 流水单号
		 *
		 * @param string $table 表名 
		 * @param double $filed 字段 
		 * @return string 流水单号
		 */
		public function getGlide($table,$filed,$pre='DG'){
			global $ass;
			$pickupCode	= 1;
			$glide = "";
			while($pickupCode > 0){
				$glide = $pre.date("YmdHis").rand(1000,9999);
				if($ass->number($table,$filed.'="'.$glide.'"')==0){
					$pickupCode = 0;
				}
			}
			return $glide;
		}
		/**
		 * 取餐码
		 *
		 */
		function getPickCode()
		{
			global $db;		
			while($code=rand(000000000,999999999)){
				if($db->number('msm_front','bill_pickup="'.rand(000000000,999999999).'"')==0){
					break;
				}
			}
			return $code;
		}
		 
		/**
		 * 获取商品关税
		 *
		 * @param int $gid 商品ID 
		 * @param double $price 商品售价 
		 * @return double 税金
		 */
		public function getGoodsCess($divide,$gid,$price,$shelf){
			global $ass,$db;
			$sql = 'select A.*,B.product_cess,C.class_name from '.$ass->table('goods').' as A ';
			$sql.= 'inner join '.$ass->table('product').' as B ON A.goods_product=B.product_id ';
			$sql.= 'inner join '.$ass->table('goods_class').' as C ON A.goods_class=C.class_id ';
			$sql.= 'inner join '.$ass->table('goods_shop').' as D ON A.goods_id=D.goods_id and D.shelf_id='.$shelf;
			$sql.= ' where A.goods_id='.$gid;
			$rst = $db->query($sql);
			if($row=$db->fetch_array($rst)){
				$data = array(
					'moneyCess'		=> 	$divide?0:$row['product_cess']*$price,//关税
					'moneyTraffic'	=> $row['goods_traffic'],//运费
					'moneyAdd'		=> $row['goods_addprice']*$price/100,//商品附加费
					'moneyYjin'		=> $row['goods_commission']*$price/100,//佣金比例
					'entrycode'		=> $row['goods_entrycode'],//报关码
					'className'		=> $row['class_name'],//类别
					'goodsCode'		=> $row['goods_code'],//编号
					'goodsName'		=> $row['goods_name'],//名称
					'goodsUnit'		=> $row['goods_unit']//单位
				);
			}else{
				$data = array(
					'moneyCess'		=> 0,//关税
					'moneyCess'		=> 0,//关税
					'moneyTraffic'	=> 0,//运费
					'moneyAdd'		=> 0,//运费
					'moneyYjin'		=> 0,//佣金
					'entrycode'		=> '',//报关码
					'className'		=> '',//类别
					'goodsCode'		=> '',//编号
					'goodsName'		=> '',//名称
					'goodsUnit'		=> ''//单位
				);
			}
			return $data;
		}

		/**
		  *简单购物
		**/
		public function restaurant(){
			global $ass,$db;
		}
	}
?>