<?php
class GoodsRule{
	function GoodsRule(){
		$this->sumMoney = 0;
		$this->leave = 0;
		$this->number = 1;
		$this->sum = 0;
		$this->mem = 0;
		$this->shop_id = 0;
		$this->supply_id = 0;
		$this->comp_id = 0;
	}
	/**
	 *获取当前级别下的规则金额合计
	 *maxgrade自己的级别
	 *mingrade前面介绍人的级别
	 *大于等于自己级别，小于前面介绍人的级别
	 */
	function getGradeMoney($rule_id,$maxgrade,$mingrade=0){
		global $db,$ass;
		$sum = 0;
		if($rule_id){
			$sql  = 'select sum(rule_value) as sum from '.$ass->table('grule_child');
			$sql.= ' where rule_id='.$rule_id;
			if($maxgrade){
				$sql.= ' and rule_grade<='.$maxgrade;
			}
			if($mingrade){
				$sql.= ' and rule_grade>'.$mingrade;
			}
			$rst = $db->query($sql);
			if($row=$db->fetch_array($rst)){
				$sum = $row['sum'];
			}
		}
		return $sum;
	}
	/**
	 *商品代理提成
	 *介绍人必须是代理，同时介绍人的代理级别必须大于自己的级别才能有提成
	 */
	function getSPParent($bill_id,$allot_id,$mem_id,$rule,$goods_id,$maxGrade){
		global $db,$ass;
		if($this->leave>0){
			$mem = $ass->one('member','','mem_id='.$mem_id);
			if($mem['mem_referrer']>0){
				$parent = $ass->one('member','','mem_id='.$mem['mem_referrer']);
				//如果介绍人的级别大于自己的级别
				if($parent['mem_grade']>$mem['mem_grade']){
					//级别要小于等于设置的最大级别
					if($parent['mem_grade']<=$maxGrade){
						//获取介绍人的提成
						$share = $this->getGradeMoney($rule['rule_id'],$parent['mem_grade'],$mem['mem_grade']);
						if($rule['rule_mode']=='ratio'){
							$share = ($this->sumMoney * $share)/100;
						}else{
							$share = $share*$this->number;
						}
						//插入提成
						$this->insertShareChild($parent,$share,$allot_id,'D',$rule['rule_id'],$goods_id);
						//累加已发放提成
						$this->sum = $this->sum+$share;
						$this->leave = $this->sumMoney - $this->sum;
						//继续递归
						$this->getSPParent($bill_id,$allot_id,$parent['mem_id'],$rule,$goods_id,$maxGrade);
					}
				}
			}			
		}
	}
	/**
	 *
	 */
	function getDLParent($allot_id,$mem_id,$rule,$goods_id){
		global $db,$ass;
		$sql  = 'select * from '.$ass->table('grule_child');
		$sql.= ' where rule_id='.$rule_id;
		$sql.= ' order by rule_line asc';
		$rst = $db->query($sql);
		$parent_mem = $mem_id;
		while($row=$db->fetch_array($rst)){
			$mem = $ass->one('member','','mem_id='.$parent_mem);
			if($mem['mem_referrer']>0){
				$parent_mem = $mem['mem_referrer'];
			}else{
				break;
			}
			$rule_value  = $row['rule_value'];
			if($rule['rule_mode']=='ratio'){
				$share = ($this->sumMoney * $rule_value)/100;
			}else{
				$share = $rule_value*$this->number;
			}
			$this->sum = $this->sum+$share;
			$this->leave = $this->sumMoney - $this->sum;
			//插入提成
			$this->insertShareChild($mem,$share,$allot_id,'J',$rule['rule_id'],$goods_id);
		}
	}
	/**
	 *插入代理提成主表
	 *一个订单生成一个提成主表,
	 *提成明细增加商品名称,规则ID和规则名称
	 */
	function insertShare($bill_id){
		global $db,$ass;
		$date = date('Y-m-d');
		$time = date('Y-m-d H:i:s');
		$one = $ass->one('front','','bill_id='.$bill_id);
		if($one['bill_payment']=='Y'){
			$this->shop_id = $one['shop_id'];
			$this->supply_id = $one['bill_supply'];
			$this->comp_id = $one['bill_comp'];
			$this->mem = $one['member_id'];
			$ret = true;
			if($ass->number('allot','allot_glide="'.$one['bill_glide'].'"')==0){
				$shop = $ass->one('shop','','shop_id='.$one['shop_id']);
				$comp = $ass->one('company','','comp_id='.$one['bill_comp']);
				$allot_draw = date("Y-m-d",strtotime ("+".$comp['comp_draw']." day"));//提现日期

				if($one['bill_attr']=='grade'){//代理介绍
					$mode = 'grade';
					$type = 'J';
				}elseif($one['bill_attr']=='shop'){//商城购物店家佣金
					$mode = 'shop';
					$type = 'Y';
				}else{//商城购物代理分成
					$mode = 'YSG';
					$type = 'D';
				}
				$bill_code = $db->soft_code("msm_allot","allot_code","10","FP","");
				$data = array(
					'allot_code'	=> $bill_code,
					'allot_glide'	=> $one['bill_glide'],
					'allot_billcode'=> $bill_code,
					'allot_mode'	=> $mode,
					'allot_money'	=> $one['goods_money'],//订单金额
					'allot_budget'	=> 0,//预算应该提成
					'allot_extraction'=> 0,//实发提成金额
					'allot_cash'	=> 0,//实发提成现金
					'allot_comp'	=> $one['bill_comp'],
					'allot_shop'	=> $one['shop_id'],
					'allot_fkshop'	=> $one['bill_supply'],
					'allot_from'	=> 'WM',
					'allot_xfshop'	=> $one['shop_id'],
					'allot_mem'		=> $one['member_id'],
					'allot_draw'	=> $allot_draw,
					'allot_date'	=> date("Y-m-d"),
					'allot_time'	=> date("Y-m-d H:i:s"),
					'allot_audit'	=> 'L',
					'allot_ispt'	=> $shop['shop_iscomp'],
					'allot_memo'	=> '转入零钱',
					'allot_type'	=> $type
				);
				if($ass->insert('allot',$data)){
					$allot_id = $db->insert_id();
				}
			}else{
				$ret = false;
			}
		}else{
			$ret = false;
		}
		return array('ret'=>$ret,'mem_id'=>$one['member_id'],'city_id'=>$one['bill_city'],'share_shop'=>$one['share_shop'],'allot_id'=>$allot_id);
	}
	/**
	 *插入代理提成明细
	 *一个订单生成一个提成主记录,
	 */
	function insertShareChild($mem,$money,$allot_id,$type,$rule_id,$goods_id){
		global $db,$ass;
		$comp = $ass->one('company','','comp_id='.$this->comp_id);
		$allot_draw = date("Y-m-d",strtotime ("+".$comp['comp_draw']." day"));//提现日期

		$goods = $ass->one('goods','','goods_id='.$goods_id);
		$allot_line = $ass->getMax('allot_child','allot_line','allot_id='.$allot_id);
		$data = array(
			'allot_id'		=> $allot_id,
			'allot_line'	=> $allot_line,
			'allot_introduce' => $mem['mem_id'],
			'allot_cmoney'	=> $money,
			'allot_ccash'	=> $money,
			'allot_draw'	=> $allot_draw,
			'allot_comp'	=> $this->comp_id,
			'allot_shop'	=> $this->shop_id,
			'allot_fkshop'	=> $this->supply_id,
			'allot_xfshop'	=> $this->shop_id,
			'allot_from'	=> $this->mem,
			'allot_audit'	=> 'Y',
			'allot_state'	=> 'L',
			'allot_type'	=> $type,
			'allot_goods'	=> $goods_id,
			'allot_number'	=> $this->number,
			'allot_gname'	=> $goods['goods_name'],
			'allot_rule'	=> $rule_id
		);
		if($ass->insert('allot_child',$data)){
			//J介绍分成,F推广分享提成,H店家货款,D代理提成,Y店铺佣金
			$typeArr = array(
				'J' => '介绍分成',
				'F' => '推广分享提成',
				'H' => '店家货款',
				'D' => '代理提成',
				'Y' => '店铺佣金'
			);
			$memo = $typeArr[$type].'【'.$goods['goods_name'].'】';
			$allot = $ass->one('allot','','allot_id='.$allot_id);
			$fee_sole = $allot_id.'.'.$allot_line;
			$this->alterFeeChild($mem['mem_id'],$this->shop_id,$money,$allot['allot_code'],$allot['allot_glide'],$fee_sole,$memo,$allot_draw,'TC');
		}
	}
	function goodsRules($bill_id){
		global $db,$ass;
		//如果商品设置佣金在生成佣金表
		$insert=false;
		$one = $ass->one('front','','bill_id='.$bill_id);
		if($one['bill_payment']=='Y'){
			//储值卡付款不提成
			if($ass->number('front_pay','pay_glide="'.$one['bill_glide'].'" and pay_type=4')==0){
				if($one['bill_attr']=='shop'){
					if($ass->number('shop_rule','rule_comp='.$this->comp_id)>0){
						//goods_commission 商品佣金大于0
						$sql = 'select * from '.$ass->table('front_child').' as A ';
						$sql.= 'inner join '.$ass->table('goods').' as B on A.goods_id=B.goods_id and B.goods_commission>0';
						$sql.= ' where bill_id='.$bill_id;
						$rst = $db->query($sql);
						if($row=$db->fetch_array($rst)){
							$insert=true;
						}
					}
				}else{
					$sql = 'select * from '.$ass->table('front_child').' as A ';
					$sql.= 'inner join '.$ass->table('goods').' as B on A.goods_id=B.goods_id and B.goods_rule>0';
					$sql.= ' where bill_id='.$bill_id;
					$rst = $db->query($sql);
					if($row=$db->fetch_array($rst)){
						$insert=true;
					}
				}
			}
		}
		if($insert){
			$ret = $this->insertShare($bill_id);
			//如果供货商和门店不相同，则不计算代理提成，只计算店家佣金提成
			if($ret['ret']){
				$allot_id = $ret['allot_id'];
				$mem_id   = $ret['mem_id'];
				$city_id  = $ret['city_id'];
				$share_shop  = $ret['share_shop'];
				$sumShare = 0;
				//循环商品明细
				$sql = 'select * from '.$ass->table('front_child').' as A ';
				$sql.= 'inner join '.$ass->table('goods').' as B on A.goods_id=B.goods_id';
				$sql.= ' where bill_id='.$bill_id;
				$rst = $db->query($sql);
				while($row=$db->fetch_array($rst)){
					$goods_id = $row['goods_id'];
					$goods_number = $row['goods_number'];
					$this->number = $goods_number;
					if($share_shop>0){
						$goods_commission = $row['goods_commission'];
						$goods_price = $row['goods_price'];
						if($goods_commission){
							$money = ($goods_commission*$goods_price)/100;
							$this->doShopShare($bill_id,$goods_id,$share_shop,$allot_id,$money);
						}
					}else{
						$this->doRule($bill_id,$goods_id,$mem_id,$allot_id,$city_id);
					}
					//理论提成金额
					$sumMoney = $sumMoney+$this->sumMoney;
					//实际提成金额
					$sumShare = $sumShare+$this->sum;
				}
				//修改提成主单
				$data = array(
					'allot_budget'		=> $sumMoney,
					'allot_extraction'	=> $sumShare,
					'allot_cash'		=> $sumShare
				);
				if($ass->update('allot',$data,'allot_id='.$allot_id)){
				}
			}
		}else{
			$allot_id = 0;
		}
		return $allot_id;
	}
	//处理提成
	function doRule($bill_id,$goods_id,$mem_id,$allot_id,$city_id){
		global $db,$ass;
		$this->sumMoney = 0;
		$this->leave = 0;
		$this->sum = 0;
		$rule = $ass->one('grule','','rule_goods='.$goods_id.' and rule_shop='.$this->shop_id);
		if($rule){
			$this->sumMoney = $rule['rule_money']*$this->number;
			$this->leave = $this->sumMoney;
			//商品代理提成
			if($rule['rule_type']=='SP'){
				//获取当前规则的最大级别值
				$one = $ass->one('grule_child','rule_grade','rule_id='.$rule['rule_id'],'rule_grade','desc');
				$maxGrade = $one['rule_grade'];
				$mem = $ass->one('member','','mem_id='.$mem_id);
				//判断自己级别
				if($mem['mem_grade']){
					//级别要小于等于设置的最大级别
					if($mem['mem_grade']<=$maxGrade){
						//查找当前规则明细下的所有小于等于自己级别的金额
						$share = $this->getGradeMoney($rule['rule_id'],$mem['mem_grade']);
						if($rule['rule_mode']=='ratio'){
							$share = ($this->sumMoney * $share)/100;
						}else{
							$share = $share*$this->number;
						}
						$this->sum = $this->sum+$share;
						$this->leave = $this->sumMoney - $this->sum;
						//插入提成
						$this->insertShareChild($mem,$share,$allot_id,'D',$rule['rule_id'],$goods_id);
					}
				}
				//获取介绍人 获取大于自己级别的介绍人
				if($mem['mem_referrer']>0){
					$this->getSPParent($bill_id,$allot_id,$mem_id,$rule,$goods_id,$maxGrade);
				}
				//生成市级代理提成
				if($this->leave){
					//根据订单，找到市级代理
					$agency = $ass->one('city_agency','','agency_city='.$city_id);
					if($agency['agency_mem']){
						$citys = $ass->one('member','','mem_id='.$agency['agency_mem']);
						//市级代理获取提成
						$this->insertShareChild($citys,$this->leave,$allot_id,'D',$rule['rule_id'],$goods_id);
						$this->sum = $this->sum+$this->leave;
						$this->leave = 0;
					}
				}
			//代理申请商品提成
			}else{
				//如果有代理人则处理，没代理人不处理
				if($mem['mem_referrer']>0){
					$this->getDLParent($allot_id,$mem_id,$rule,$goods_id);
				}
			}
		}
	}
	//店铺佣金
	function doShopShare($bill_id,$goods_id,$share_shop,$allot_id,$money){
		global $db,$ass;
		$this->sumMoney = 0;
		$this->leave = 0;
		$this->sum = 0;
		if($ass->number('shop_rule','rule_comp='.$this->comp_id)>0){
			$this->sumMoney = $money*$this->number;
			$this->leave = $this->sumMoney;
			//获取店铺所有者用户ID
			$sshop = $ass->one('shop','','shop_id='.$share_shop);
			if($sshop['shop_tel']){
				$one = $ass->one('member','mem_id','mem_hand="'.$sshop['shop_tel'].'"');
				if($one){
					$mem_hand = $mem_hand;
					//循环规则表
					$sql = 'select * from '.$ass->table('shop_rule');
					$sql.= ' where rule_comp='.$this->comp_id;
					$rst = $db->query($sql);
					$i=0;
					while($row=$db->fetch_array($rst)){
						$i++;
						if($i>2){
							break;
						}
						$mem = $ass->one('member','','mem_hand="'.$mem_hand.'"');
						$share = number_format($row['rule_value'] * $money/100,'2','.','');
						$this->sum = $this->sum+$share;
						$this->leave = $this->sumMoney - $this->sum;
						//插入提成
						$this->insertShareChild($mem,$share,$allot_id,'Y',$row['rule_id'],$goods_id);
						if($sshop['shop_parent']){
							$mem_hand = $sshop['shop_parent'];
						}else{
							break;
						}
					}
				}
			}
		}
	}
	//判断是否有礼券，有礼券则订单标记成已完成状态
	function checkCoupon($bill_id){
		global $db,$ass,$common;
		$date = date('Y-m-d');
		$time = date('Y-m-d H:i:s');
		$front = $ass->one('front','','bill_id='.$bill_id);
		$ret = false;
		if($front['bill_payment']=='Y'){
			$sqlc = 'select * from '.$ass->table('front_child').' as A ';
			$sqlc.= 'inner join '.$ass->table('goods').' as B on A.goods_id=B.goods_id and B.goods_cseries>0 ';
			$sqlc.= 'where bill_id='.$bill_id;
			$rstc = $db->query($sqlc);
			if($rowc=$db->fetch_array($rstc)){
				$ret = true;
			}
			if($ret){
				// if($ass->update('front',array('bill_status'=>'6'),'bill_id='.$bill_id)){	
				if($ass->update('front',array('bill_status'=>'4'),'bill_id='.$bill_id)){
				}
			}
		}
		return $ret;
	}
	/**
	 *礼券
	 *bill_id 订单ID
	 */
	function goodsCoupon($bill_id){
		global $db,$ass,$common;
		$date = date('Y-m-d');
		$time = date('Y-m-d H:i:s');
		$front = $ass->one('front','','bill_id='.$bill_id);
		if($front['bill_payment']=='Y'){
			$sshop = $ass->one('shop','','shop_id='.$front['shop_id']);
			$mem = $ass->one('member','','mem_id='.$front['member_id']);	
			$sqlc = 'select * from '.$ass->table('front_child').' as A ';
			$sqlc.= 'inner join '.$ass->table('goods').' as B on A.goods_id=B.goods_id and B.goods_cseries>0 ';
			$sqlc.= 'where bill_id='.$bill_id;
			$rstc = $db->query($sqlc);
			while($rowc=$db->fetch_array($rstc)){
				$goods_id		= $rowc['goods_id'];
				$goods_price	= $rowc['goods_price'];
				$goods_name		= $rowc['goods_name'];
				$goods_number	= $rowc['goods_number'];
				$goods_cseries  = $rowc['goods_cseries'];
				if($ass->number('card_sell','sell_code="'.$front['bill_glide'].'"')==0){
					$series = $ass->one('cseries','','series_id='.$goods_cseries);
					//生成sell单据
					//生成卡券档案，卡券销售，销售明细
					$card_number = $ass->sum('cseries_child','series_number','series_id='.$series['series_id']);
					$cdata=array(
						'card_code'	=> $front['bill_glide'],
						'card_key'	=> $front['bill_glide'],
						'card_type'	=> $series['series_id'],
						'card_typename'	=> $series['series_name'],
						'card_state'	=> 'C',
						'card_time'	=> $time,
						'card_shop'	=> $front['shop_id'],
						'card_comp'	=> $front['bill_comp'],
						'card_price'=> $series['series_money'],
						'card_sell'	=> $series['series_money'],
						'card_smem'	=> $mem['mem_id'],
						'card_mem'	=> $mem['mem_id'],
						'card_name'	=> $mem['mem_name'],
						'card_hand'	=> $mem['mem_hand'],
						'card_time1'	=> $time,
						'card_time2'	=> $time,
						'card_glide'	=> $front['bill_glide'],
						'card_pay'	=> 'Y',
						'card_agencyname'	=> $mem['mem_name'],
						'receiver_name'	=> $front['receiver_name'],
						'receiver_addr'	=> $front['receiver_addr'],
						'receiver_hand'	=> $front['receiver_hand'],
						'card_time3'	=> $time,
						'card_agencyhand'	=> $mem['mem_hand'],
						'card_memo'	=> '商城购买卡券套餐',
						'card_class'	=> 'coupon',
						'card_number'	=> $card_number,
					);
					if($ass->insert('card_register',$cdata)){
						$card_id = $db->insert_id();
						$common->LogCard('商城购买注册卡券'.$front['bill_glide'],$card_id,'',$mem['mem_id']);
						//卡券销售单
						$data=array(
							'sell_code' => $front['bill_glide'],
							'sell_type' => 'S',
							'sell_mem' => $mem['mem_id'],
							'sell_name' => $mem['mem_name'],
							'sell_hand' => $mem['mem_hand'],
							'sell_summoney' => $front['goods_money'],
							'sell_money' => $front['goods_money'],
							'sell_number' => $goods_number,
							'sell_date' => $date,
							'sell_time' => $time,
							'sell_memo' => '商城销售【'.$goods_name.'】',
							'sell_shop' => $front['shop_id'],
							'sell_comp' => $front['bill_comp'],
						);
						if($ass->insert('card_sell',$data)){
							$sell_id = $db->insert_id();
							$cdata['sell_id'] = $sell_id;
							$cdata['card_id'] = $card_id;
							unset($cdata['card_smem']);
							unset($cdata['card_agencyhand']);
							unset($cdata['card_agencyname']);
							unset($cdata['receiver_name']);
							unset($cdata['receiver_addr']);
							unset($cdata['receiver_hand']);
							unset($cdata['card_time3']);
							unset($cdata['card_memo']);
							unset($cdata['card_number']);
							if($ass->insert('card_schild',$cdata)){
								$common->LogCard('商城购买卡券自动激活',$card_id,'',$mem['mem_id']);
								$sql = 'select A.series_number,B.* from '.$ass->table('cseries_child').' as A inner join '.$ass->table('coupon_class').' as B on A.series_class=B.cclass_id where A.series_id='.$goods_cseries.' and A.series_shop='.$front['shop_id'];
								$rst = $db->query($sql);
								while($row=$db->fetch_array($rst))
								{
									$counts = $row['series_number']*$goods_number;
									$cclass_id = $row['cclass_id'];
									if($row['cclass_unit']=='D'){
										$cclass_times = $row['cclass_times'];
										$unit = 'day';
									}else if($row['cclass_unit']=='M'){
										$cclass_times = $row['cclass_times'];
										$unit = 'month';
									}else{
										$cclass_times = $row['cclass_times'];
										$unit = 'year';
									}
									$isyear = false;
									if($unit=='year' && $cclass_times==1){
										$isyear = true;
									}
									$begin = date("Y-m-d");
									$endtime = date("Y-m-d",strtotime("+".$cclass_times." ".$unit));
									for($i=0;$i<$counts;$i++){
										if($isyear){
											//每月一张
											$m = $i%12;
											$begin = date("Y-m-d",strtotime("+".$m." month"));
											$ei = $m+12;
											$endtime = date("Y-m-d",strtotime("+".$ei." month"));
										}
										//获取礼券唯一码
										$coupon_unique = $common->getCouponUnique();
										//插入每个明细单
										$dchild = array(
											'coupon_make'	=> $sell_id,
											'coupon_card'	=> $card_id,
											'coupon_class'	=> $cclass_id,
											'coupon_unique' => $coupon_unique,
											'coupon_price'	=> $goods_price,
											'coupon_name'	=> $goods_name,
											'coupon_type'	=> $row['cclass_type'],
											'coupon_goods'	=> $row['cclass_goods'],
											'coupon_present'=> $row['cclass_present'],//是否允许赠送
											'coupon_sheet'	=> $row['cclass_sheet'],//每人限用张数
											'coupon_join'	=> $row['cclass_join'],//是否联锁
											'coupon_interval'=> $row['cclass_interval'],//间隔时间
											'coupon_number'	=> $row['cclass_number'],//每次最多使用张数
											'coupon_min'	=> $row['cclass_min'],//每次最少使用张数
											'coupon_consume'=> $row['cclass_consume'],//消费满多少可用
											'coupon_gclass'	=> $row['cclass_gclass'],//消费满多少可用
											'coupon_begin'	=> $begin,//开始时间
											'coupon_end'	=> $endtime,//截止时间
											'coupon_man'	=> $mem['mem_name'],
											'coupon_tel'	=> $mem['mem_hand'],
											'coupon_mem'	=> $mem['mem_id'],
											'coupon_buy'	=> $mem['mem_id'],
											'coupon_shop'	=> $front['shop_id'],
											'coupon_comp'	=> $front['bill_comp'],
											'coupon_state'	=> 'B',
											'coupon_audit'	=> 'Y',
											'coupon_memo'	=> '商城购买'.$front['bill_glide'],
											'coupon_glide'	=> $front['bill_glide'],
											'coupon_time'	=> $time,
											'coupon_time1'	=> $time,
											'coupon_time2'	=> $time,
											'coupon_btime'	=> $row['cclass_btime'], 
											'coupon_etime'	=> $row['cclass_etime'],
											'coupon_bdate'	=> $isyear?$begin:$row['cclass_bdate'],
											'coupon_edate'	=> $isyear?$endtime:$row['cclass_edate'],
											'coupon_sellcity'=> $sshop['shop_city'],
											'coupon_city'	=> $front['bill_city']
										);
										if($ass->insert('coupon',$dchild)){
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}

	/**
	 *代理级别商品
	 */
	function goodsGrade($bill_id){
		global $db,$ass;
		$date = date('Y-m-d');
		$time = date('Y-m-d H:i:s');
		$front = $ass->one('front','','bill_id='.$bill_id);
		if($front['bill_payment']=='Y'){
			//如果是从店家扫描进入平台购买的，介绍人是店主
			if($front['share_shop']){
				$sshop = $ass->one('shop','','shop_id='.$front['share_shop']);
				if($sshop['shop_tel']){
					$one = $ass->one('member','mem_id','mem_hand="'.$sshop['shop_tel'].'"');
					if($one){
						$mem_referrer = $one['mem_id'];
					}
				}
			}
			$sshop = $ass->one('shop','','shop_id='.$front['shop_id']);
			$mem = $ass->one('member','','mem_id='.$front['member_id']);
			$sqlc = 'select * from '.$ass->table('front_child').' as A ';
			$sqlc.= 'inner join '.$ass->table('goods').' as B on A.goods_id=B.goods_id and B.goods_grade>0 ';
			$sqlc.= 'where bill_id='.$bill_id;
			$rstc = $db->query($sqlc);
			while($rowc=$db->fetch_array($rstc)){
				$goods_id		= $rowc['goods_id'];
				$goods_name		= $rowc['goods_name'];
				$goods_number	= $rowc['goods_number'];
				$goods_grade	= $rowc['goods_grade'];
				//代理级别必须存在
				if($ass->number('step','step_id='.$goods_grade)>0){
					//如果没有介绍人，同时更改用户介绍人
					$data=array(
						'mem_grade'	=>$goods_grade
					);
					if(!$mem['mem_referrer']){
						if($mem_referrer){
							$data['mem_referrer'] = $mem_referrer;
						}else{
							$data['mem_referrer'] = $front['bill_spreader'];
						}
					}
					$data['mem_identity'] = "B";
					if($goods_grade>1 && $mem['mem_boss'] != 0){
						$this->becomingBoss($front['member_id']);
					}
					if($ass->update('member',$data,'mem_id='.$mem['mem_id'])){
						//判断代理介绍人可是分销人员，如果是分销人员，当前用户也是分销人员，分销介绍人就是当前代理介绍人
						if(!$mem['mem_level']){//自己不是分销
							if($data['mem_referrer']){
								$parent = $ass->one('member','','mem_id='.$data['mem_referrer']);
								if($parent['mem_level']){
									include_once("./includes/teams_cls.php");
									$Teams = new Teams();
									$Teams->joinTeam($mem['mem_id'],$parent['mem_id']);
								}
							}
						}
					}
				}
			}
		}
	}
	function becomingBoss($mem_mem){
		global $ass;
		//查找当前信息
		$own = $ass->one('member','',' mem_id='.$mem_mem);
		if($own['mem_invite_id'] == 0 || $own['mem_grade'] == 2){
			return ;
		}
		//查找他下面有没有成员，也就是排在他后面的
		$one = $ass->one('member','',' mem_callbind >= '.$own['mem_invite_id'] . ' and mem_boss = '. $own['mem_boss'] .' and mem_grade != 2 order by mem_invite_id asc');
		if(!$one){
			//如果没有就直接成为老板
			$ass->update('member',array('mem_boss'=>$mem_mem,'mem_grade'=>2,'mem_identity' => 'B','mem_referrer'=>$own['mem_boss'],'mem_callbind'=>0),'mem_id='.$mem_mem);
			return ;
		}
		//如果有成员就拿走一只成员
		$ids = $this->sonIds($one['mem_invite_id'],$one['mem_boss']);
		$ids[] = $one['mem_id'];
		$ids_str = implode(',',$ids);

		//修改这些值的顶级id为own的id
		$ass->update('member',array('mem_boss'=>$own['mem_id']),'mem_id in ('.$ids_str.')');
		//修改当前成为老板值
		$ass->update('member',array('mem_boss'=>$mem_mem,'mem_grade'=>2,'mem_identity' => 'B','mem_referrer'=>$own['mem_boss'],'mem_callbind'=>0),'mem_id='.$mem_mem);
	}

	
	function sonIds($invite_id,$boss_id){
		$ass = new Ass();
		$count = $ass->count('member','mem_id','  mem_callbind = '. $invite_id.' and mem_boss =' . $boss_id .' and mem_grade != 2' );
		// var_dump($count);die;
		if($count == 0){
			// var_dump(1212);
			$childrenIds = array();
			return $childrenIds;
		}
		$sons = $ass->data('select * from msm_member where mem_callbind = '. $invite_id.' and mem_boss =' . $boss_id .' and mem_grade != 2');
		//因为递归是往下找的，所以不能用递归后就排序会打乱先后顺序，先递归出所有的子mem_id,然后按照id正序，一个个去修改排序
		$childrenIds = array();
		foreach($sons as $key => $val){
			$childrenIds[] = $val['mem_id'];
			$arr = sonIds($val['mem_invite_id'],$val['mem_boss']);
			$childrenIds = array_merge($childrenIds,$arr);
		}
		return $childrenIds;
	}

	/**
	 *获取当前用户的零钱
	 */
	function getFee($mem_id,$shop_id){
		global $db,$ass;
		$one = $ass->one('member_fee','','mem_id='.$mem_id.' and shop_id='.$shop_id);
		if($one){
			$fee = $one['fee_leave'];
		}else{
			$fee = 0.00;
		}
		return $fee;
	}
	/**
	 *零钱明细变动
	 */
	function alterFeeChild($mem_id,$shop_id,$money,$fee_code,$fee_bill,$fee_sole,$memo,$fee_draw,$mode){
		global $db,$ass;
		$time = date("Y-m-d H:i:s");
		$fee_draw = date('Y-m-d');
		if($shop_id>0){
			if($money>0){
				$shop = $ass->one('shop','','shop_id='.$shop_id);
				$comp = $ass->one('company','','comp_id='.$shop['comp_id']);
				$fee_draw = date("Y-m-d",strtotime("+".$comp['comp_draw']." day"));
			}
		}
		if($ass->number('member_fee','mem_id='.$mem_id.' and shop_id='.$shop_id)==0){
			//添加零钱账户
			$data = array(
				'mem_id'	=> $mem_id,
				'shop_id'	=> $shop_id,
				'fee_last'	=> $time
			);
			if($ass->insert('member_fee',$data)){
				$fee_leave = $money;
				$fee_money = $money;
			}
		}else{
			$one = $ass->one('member_fee','','mem_id='.$mem_id.' and shop_id='.$shop_id);
			$fee_leave = $one['fee_leave'] + $money;
			if($money>0){
				$fee_money = $one['fee_money'] + $money;
			}else{
				$fee_money = $one['fee_money'];
			}
		}
		$ret=true;
		if($fee_leave>=0){
			if($money>0){
				if($ass->number('member_feechild','fee_mem='.$mem_id.' and fee_sole="'.$fee_sole.'" and fee_code="'.$fee_code.'"')>0){
					$ret=true;
				}
			}
			if($ret){
				$list=array();
				$fee_finish = 'N';
				//如果是减钱，获取正金额的所有fee_finish为N的找金额，按照可提现日期,如果是提现正序查找，如果是使用倒序查找
				if($money<0){
					$rets = $this->useFee($money,$mode,$mem_id,$shop_id);//mode XF零钱消费 TX零钱提现
					if(!$rets['ret']){
						$ret = false;
					}else{
						$list=$rets['list'];
					}
					$fee_finish = 'Y';
				}
				if($ret){
					$data = array(
						'fee_code'	=> $fee_code,
						'fee_bill'	=> $fee_bill,
						'fee_sole'	=> $fee_sole,
						'fee_mode'	=> $mode,
						'fee_time'	=> $time,
						'fee_money'	=> $money,
						'fee_leave'	=> $fee_leave,
						'fee_mem'	=> $mem_id,
						'fee_shop'	=> $shop_id,
						'fee_draw'	=> $fee_draw,
						'fee_finish'=> $fee_finish,
						'fee_memo'	=> $memo
					);
					if($ass->insert('member_feechild',$data)){
						$pid = $db->insert_id();
						$fdata=array(
							'fee_money'	=> $fee_money,
							'fee_leave'	=> $fee_leave,
							'fee_last'	=> $time,
						);
						if($ass->update('member_fee',$fdata,'mem_id='.$mem_id.' and shop_id='.$shop_id)){
							if($list){
								foreach($list as $key =>$line){
									$ldata=array(
										'log_fee'	=> $line['fee_id'],
										'log_money'	=> $line['used'],
										'log_usefee'=> $pid,
										'log_code'	=> $fee_code,
										'log_mode'	=> $mode,
										'log_time'	=> $time,
										'log_bill'	=> $line['fee_bill'],
										'log_shop'	=> $shop_id,
										'log_memo'	=> $line['fee_memo'],
									);
									if($ass->insert('member_feelog',$ldata)){
										$cone = $ass->one('member_feechild','','fee_id='.$line['fee_id']);
										$used = abs($line['used'])+abs($cone['fee_used']);
										$cdata = array('fee_used'=>$used);
										if($used==$cone['fee_money']){
											$cdata['fee_finish'] = 'Y';
										}
										if($ass->update('member_feechild',$cdata,'fee_id='.$line['fee_id'])){
										}
									}
								}
							}	
						}
					}
				}
			}
		}else{
			$ret=false;
		}
		return $ret;
	}
	/*
	 *根据金额获取零钱明细
	 */
	function useFee($usemoney,$mode,$mem_id,$shop_id){
		global $db,$ass;
		$date = date("Y-m-d");
		$sql = 'select * from '.$ass->table('member_feechild').' where fee_finish="N"';
		$sql.= ' and fee_money>0 and fee_shop='.$shop_id.' and fee_mem='.$mem_id;//fee_mode="TC" and 
		if($mode=='TX'){
			$sql.= ' and fee_draw<="'.$date.'" order by fee_draw asc';
		}else if($mode=='XF'){//零钱消费
			$sql.= ' order by fee_draw desc';
		}
		$rst = $db->query($sql);
		$i=0.00;
		$leave=abs($usemoney);
		$arr=array();
		while($row=$db->fetch_array($rst)){
			$money = $row['fee_money'] - $row['fee_used'];
			if($leave<=$money){
				$used = -$leave;
				$leave = 0;
			}else{
				$used = -$money*1;
				$leave = number_format(number_format($leave,'2','.','')-number_format($money,'2','.',''),'2','.','');
			}
			$arr[]=array(
				'fee_id'	=> $row['fee_id'],
				'fee_bill'	=> $row['fee_bill'],
				'used'		=> $used,
				'fee_memo'	=> $row['fee_memo']
			);
			if($leave==0){
				break;
			}
		}		
		if($leave>0){
			$ret = false;
		}else{
			$ret = true;
		}
		return array('ret'=>$ret,'list'=>$arr);
	}

	/*
	 *可提现金额
	 */
	function getPickFee($mem_id,$shop_id){
		global $db,$ass;
		$sql = 'select sum(fee_money-fee_used) as money from '.$ass->table('member_feechild');
		$sql.= ' where fee_finish="N"  and fee_shop='.$shop_id;//and fee_money>0 and fee_mode in ("TC","FX")
		$sql.= ' and fee_draw<="'.date("Y-m-d").'" and fee_mem='.$mem_id;
		$rst = $db->query($sql);
		$sum=0;
		if($row=$db->fetch_array($rst)){
			$sum = $row['money'];
		}
		return $sum;
	}
	//退单扣减提成判断零钱是否足够
	function checkRefundFee($bill_code,$shop_id){
		global $db,$ass;
		$ret=true;
		$sql = 'select fee_mem,sum(fee_money) as money from '.$ass->table('member_feechild');
		$sql.= ' where fee_money>0 and fee_mode in ("TC","FX") and fee_shop='.$shop_id;
		$sql.= ' and fee_bill="'.$bill_code.'" group by fee_mem';
		$rst = $db->query($sql);
		while($row=$db->fetch_array($rst)){
			$fee_mem = $row['fee_mem'];
			$sum = $row['money'];
			$leaves = $this->getPickFee($fee_mem,$shop_id);
			if($leaves<$sum){
				$ret=false;
			}
		}
		return $ret;
	}
	//退单扣减零钱
	function goodsRefundFee($bill_id){
		global $db,$ass;
		$date = date('Y-m-d');
		$time = date('Y-m-d H:i:s');
		$front = $ass->one('front','','bill_id='.$bill_id);
		$sql = 'select fee_mem,sum(fee_money) as money from '.$ass->table('member_feechild');
		$sql.= ' where fee_money>0 and fee_mode in ("TC","FX") and fee_shop='.$front['shop_id'];
		$sql.= ' and fee_bill="'.$front['bill_glide'].'" group by fee_mem';
		$rst = $db->query($sql);
		while($row=$db->fetch_array($rst)){
			$fee_mem = $row['fee_mem'];
			$sum = $row['money'];
			$this->alterFeeChild($fee_mem,$front['shop_id'],-$sum,$front['bill_glide'],$front['bill_glide'],$front['bill_id'],'退单扣减',date("Y-m-d"),'TD');
		}
	}

	//酒业务员提成
	function wineShare($mem_id,$first_mem,$money,$shop_id){
		global $db,$ass;
		$ret = array('money'=>0,'mem'=>0,'frist'=>0);
		//判断自己是不是销售员
		$mem = $ass->one('member','','mem_id='.$mem_id);
		if($mem['mem_hand']){
			$rebate = $ass->one('nfc_rebate','','rebate_shop='.$shop_id);
			if($seller){
				if($ass->number('nfc_seller','seller_hand="'.$mem['mem_hand'].'"')>0){
					$shares = $money * $rebate['rebate_seller']/100;
					$ret['money'] = $shares;
					$ret['mem'] = $shares;
				}else{
					$shares = $money * $rebate['rebate_common']/100;
					$ret['money'] = $shares;
					$ret['mem'] = $shares;
					$first = $ass->one('member','','mem_id='.$first_mem);
					if($ass->number('nfc_seller','seller_hand="'.$first['mem_hand'].'"')>0){
						$fmoney = $money * $rebate['rebate_seller']/100 - $money * $rebate['rebate_common']/100;
						$ret['money'] = $fmoney;
						$ret['frist'] = $money * $rebate['rebate_seller']/100;
					}
				}
			}
		}
		return $retmoney;
	}
}
?>