<?php
class maps{

	//var $my_key = 'U5BBZ-AYAWW-UGFRR-O7OX6-CJ3QH-PLFAS';//应用接口key
	//var $my_app = 'yubin';//应用名称
	function maps()
	{
		$this->mapkey = 'U5BBZ-AYAWW-UGFRR-O7OX6-CJ3QH-PLFAS';//应用接口key
		$this->mapapp = 'yubin';//应用名称
	}

	/** 
	* @desc 根据地址获取坐标 
	* @param float $lat 纬度值 
	* @param float $lng 经度值 
	*/
    function get_geocoder($address)
    {
        //请求
        $url = 'http://apis.map.qq.com/ws/geocoder/v1/?key='.$this->mapkey.'='. $address;
		$response = postData($url);
        return $response;
    }
	/** 
	* @desc 获取距离 
	* @param float $lat 纬度值 
	* @param float $lng 经度值 
	*/
    function get_distance($from, $to)
    {
        $from = json_decode(get_geocoder($from), true);
        if($from['status']){
            return false;
        }
        $from = $from['result']['location']['lat'] .','. $from['result']['location']['lng'];
        $to = json_decode(get_geocoder($to), true);
        if($to['status']){
            return false;
        }
        $to = $to['result']['location']['lat'] .','. $to['result']['location']['lng'];
        //请求
        $url = 'http://apis.map.qq.com/ws/direction/v1/driving/?key='.$this->mapkey.'&from='. $from .'&to='. $to;
        $response = postData($url);
        return $response;
    }
	
	/** 
	* @desc 根据坐标获取距离，一对多或是多对一，最大距离10KM，超出报错。单队单可以 
	* @param float $from 纬度值 
	* @param float $to 经度值 
	*/
    function more_distance($from, $to)
    {
		////$url = 'http://apis.map.qq.com/ws/distance/v1/?mode=driving&from=31.876040,117.314750&to=31.875310,117.307980;31.880200,117.304750;31.800530,117.290040&key=U5BBZ-AYAWW-UGFRR-O7OX6-CJ3QH-PLFAS';
		$url = 'http://apis.map.qq.com/ws/distance/v1/?mode=walking&from='.$from.'&to='.$to.'&key='.$this->mapkey;
		$response = postData($url);
        return $response;
	}
	/** 
	* @desc IP定位 
	* @param location 纬度值 
	* @param 通过终端设备IP地址获取其当前所在地理位置，精确到市级，常用于显示当地城市天气预报、初始化用户城市等非精确定位场景。
	*/
	function get_ipgeocoder($location)
    {
        //请求
		$url = 'http://apis.map.qq.com/ws/geocoder/v1/?get_poi=1&key='.$this->mapkey.'&location='. $location;
		$response = postData($url);
		//echo $_GET['callback'].'('. $response .')';
        return $response;
    }
	
	/** 
	* @desc 坐标转换 
	* @param location 纬度值 
	* @param 通过终端设备IP地址获取其当前所在地理位置，精确到市级，常用于显示当地城市天气预报、初始化用户城市等非精确定位场景。
	*/
	function translate($locations)
    {
        //请求 http://apis.map.qq.com/ws/coord/v1/translate
		//http://apis.map.qq.com/ws/coord/v1/translate?locations=39.12,116.83;30.21,115.43&type=3&key=OB4BZ-D4W3U-B7VVO-4PJWW-6TKDJ-WPB77
		$url = 'http://apis.map.qq.com/ws/coord/v1/translate?locations='.$locations.'&type=3&key=&key='.$this->mapkey;
		//$url = 'http://apis.map.qq.com/ws/coord/v1/?get_poi=1&key='.$this->mapkey.'&location='. $location;
		$response = postData($url);
		//echo $_GET['callback'].'('. $response .')';
        return $response;
    }

	/** 

	* @desc 根据两点间的经纬度计算距离 
	* @param float $lat 纬度值 
	* @param float $lng 经度值 
	* @return 米 
	*/
	function getDistance($lat1, $lng1, $lat2, $lng2) 
	{ 
		$earthRadius = 6367000; //approximate radius of earth in meters 
		/* 
		Convert these degrees to radians 
		to work with the formula 
		*/
		$lat1 = ($lat1 * pi() ) / 180; 
		$lng1 = ($lng1 * pi() ) / 180; 
		$lat2 = ($lat2 * pi() ) / 180; 
		$lng2 = ($lng2 * pi() ) / 180; 
		/* 
		Using the 
		Haversine formula 
		calculate the distance 
		*/
		$calcLongitude = $lng2 - $lng1; 
		$calcLatitude = $lat2 - $lat1; 
		$stepOne = pow(sin($calcLatitude / 2), 2) + cos($lat1) * cos($lat2) * pow(sin($calcLongitude / 2), 2); 
		$stepTwo = 2 * asin(min(1, sqrt($stepOne))); 
		$calculatedDistance = $earthRadius * $stepTwo;
		return round($calculatedDistance); 
	} 
	/** 
	* @desc POST提交数据 
	* @param url 路径
	* @return 米 
	*/
	function postData($url)
	{
		$ci = curl_init();
        curl_setopt($ci, CURLOPT_URL, $url);
        curl_setopt($ci, CURLOPT_CONNECTTIMEOUT, 3);
        curl_setopt($ci, CURLOPT_TIMEOUT, 30);
        curl_setopt($ci, CURLOPT_RETURNTRANSFER, true);
        $response = curl_exec($ci);
        curl_close($ci);
        return $response;
	}
}
?>