<?php

 class payClass{
	
	/*
		微信支付
		describe 商品描述
		out_trade_no 商户订单号
		openid 设备号 用户标识 用户微信ID
		total_money 总金额 订单总金额，单位为分，不能带小数点
		glide附加数据，原样返回
	*/
	public function payWX($describe,$out_trade_no,$openid,$total_money,$glide,$shop_id){ 
		
		global $WDT_JS_API_CALL_URL,$WDT_NOTIFY_URL,$WDT_APPID,$ass;
		include_once("WxPayPubHelper/WxPayPubHelper.php");
		$total_fee = number_format($total_money*100,0,'.','');
		//使用jsapi接口
		$jsApi = new JsApi_pub();
		//=========步骤1：网页授权获取用户openid============
		//通过code获得openid
		if (!isset($_GET['code']))
		{
			//触发微信返回code码
			$url = $jsApi->createOauthUrlForCode($WDT_JS_API_CALL_URL);
			Header("Location: $url"); 
		}else
		{
			//获取code码，以获取openid
			$code = $_GET['code'];
			$jsApi->setCode($code);
			$openid = $jsApi->getOpenId();
			if($ass->number('member_collect','shop_id="'.$shop_id.'" and mem_wxid="'.$openid.'"')==0){
				if($ass->insert('member_collect',array(
					'mem_id'		=> $_SESSION['mem_id'],	//会员id
					'shop_id'		=> $shop_id,			//关注的店铺
					'collect_time'	=> date("Y-m-d H:i:s"),	//关注时间
					'mem_last'		=> date("Y-m-d H:i:s"),	//关注时间
					'collect_status'=> 'N',					//关注状态
					'mem_wxid'		=> $openid				//用户微信ID
				))){
				}
			}
		}
		//=========步骤2：使用统一支付接口，获取prepay_id============
		//使用统一支付接口
		$unifiedOrder = new UnifiedOrder_pub();
		//设置统一支付接口参数
		//设置必填参数
		//appid已填,商户无需重复填写
		//mch_id已填,商户无需重复填写
		//noncestr已填,商户无需重复填写
		//spbill_create_ip已填,商户无需重复填写
		//sign已填,商户无需重复填写
		$unifiedOrder->setParameter("openid","$openid");//商品描述
		$unifiedOrder->setParameter("body",$describe);//商品描述
		//自定义订单号，此处仅作举例
		//$timeStamp = time();
		//$out_trade_no = $WDT_APPID."$timeStamp";
		$unifiedOrder->setParameter("out_trade_no","$out_trade_no");//商户订单号 
		$unifiedOrder->setParameter("total_fee",$total_fee);//总金额 订单总金额，单位为分，不能带小数点
		$unifiedOrder->setParameter("notify_url",$WDT_NOTIFY_URL);//通知地址 
		$unifiedOrder->setParameter("trade_type","JSAPI");//交易类型 JSAPI、 NATIVE、 APP
		//非必填参数，商户可根据实际情况选填
		//$unifiedOrder->setParameter("sub_mch_id","XXXX");//子商户号  
		$unifiedOrder->setParameter("device_info",$openid);//设备号 
		$unifiedOrder->setParameter("attach",$glide);//附加数据，原样返回
		//$unifiedOrder->setParameter("time_start","XXXX");//交易起始时间
		//$unifiedOrder->setParameter("time_expire","XXXX");//交易结束时间 
		//$unifiedOrder->setParameter("goods_tag","XXXX");//商品标记 商品标记，该字段不能随便填，不使用请填空，使用说明详见第 5 节
		$unifiedOrder->setParameter("openid",$openid);//用户标识
		//$unifiedOrder->setParameter("product_id","XXXX");//商品ID 只在 trade_type 为 NATIVE时需要填写。此 id 为二维码中包含的商品 ID，商户自行维护。
		$prepay_id = $unifiedOrder->getPrepayId();
		//=========步骤3：使用jsapi调起支付============
		$jsApi->setPrepayId($prepay_id);
		$jsApiParameters = $jsApi->getParameters();
		return $jsApiParameters;
	}
	/*
		微信订单查询
		out_trade_no 商户订单号
	*/
	public function orderQueryWx($out_trade_no){
		global $WDT_JS_API_CALL_URL,$WDT_NOTIFY_URL,$WDT_APPID;
		include_once("./WxPayPubHelper/WxPayPubHelper.php");
		$out_trade_no = trim($out_trade_no);
		if($out_trade_no){
			//使用订单查询接口
			$orderQuery = new OrderQuery_pub();
			$orderQuery->setParameter("out_trade_no","$out_trade_no");//商户订单号 
			//非必填参数，商户可根据实际情况选填
			//$orderQuery->setParameter("sub_mch_id","XXXX");//子商户号  
			//$orderQuery->setParameter("transaction_id","XXXX");//微信订单号
			//获取订单查询结果
			$orderQueryResult = $orderQuery->getResult();
			//商户根据实际情况设置相应的处理流程,此处仅作举例
			if ($orderQueryResult["return_code"] == "FAIL") {
				//echo "通信出错：".$orderQueryResult['return_msg']."<br>";
				return array('ret'=>false,'msg'=>"通信出错：".$orderQueryResult['return_msg']);
			}
			elseif($orderQueryResult["result_code"] == "FAIL"){
				//echo "错误代码：".$orderQueryResult['err_code']."<br>";
				//echo "错误代码描述：".$orderQueryResult['err_code_des']."<br>";
				return array('ret'=>false,'msg'=>"错误代码：".$orderQueryResult['err_code']);
			}
			else{
				//echo "交易状态：".$orderQueryResult['trade_state']."<br>";
				//echo "设备号：".$orderQueryResult['device_info']."<br>";
				//echo "用户标识：".$orderQueryResult['openid']."<br>";
				//echo "是否关注公众账号：".$orderQueryResult['is_subscribe']."<br>";
				//echo "交易类型：".$orderQueryResult['trade_type']."<br>";
				//echo "付款银行：".$orderQueryResult['bank_type']."<br>";
				//echo "总金额：".$orderQueryResult['total_fee']."<br>";
				//echo "现金券金额：".$orderQueryResult['coupon_fee']."<br>";
				//echo "货币种类：".$orderQueryResult['fee_type']."<br>";
				//echo "微信支付订单号：".$orderQueryResult['transaction_id']."<br>";
				//echo "商户订单号：".$orderQueryResult['out_trade_no']."<br>";
				//echo "商家数据包：".$orderQueryResult['attach']."<br>";
				//echo "支付完成时间：".$orderQueryResult['time_end']."<br>";
				return array(
					'ret'=>true,
					'msg'=>'交易成功',
					'trade_state'=>$orderQueryResult['trade_state'],
					'device_info'=>$orderQueryResult['device_info'],
					'openid'=>$orderQueryResult['openid'],
					'trade_type'=>$orderQueryResult['trade_type'],
					'bank_type'=>$orderQueryResult['bank_type'],
					'total_fee'=>$orderQueryResult['total_fee'],
					'fee_type'=>$orderQueryResult['fee_type'],
					'transaction_id'=>$orderQueryResult['transaction_id'],
					'out_trade_no'=>$orderQueryResult['out_trade_no'],
					'attach'=>$orderQueryResult['attach'],
					'time_end'=>$orderQueryResult['time_end'],
				);
			}	
		}
	}

	/*
		微信退单
		$out_trade_no 商户订单号
		$out_refund_no 商户退款单号 可以在原来的商户订单号上增加顺序号
		$total_money  总金额
		$refund_money 退单金额
		$openid 退款微信ID
		$transaction_id 微信订单号
	*/
	public function refundWx($out_trade_no,$out_refund_no,$total_money,$refund_money,$openid,$transaction_id){
		global $WDT_JS_API_CALL_URL,$WDT_NOTIFY_URL,$WDT_APPID,$WDT_MCHID,$WDT_SSLCERT_PATH,$WDT_SSLKEY_PATH;
		include_once("./WxPayPubHelper/WxPayPubHelper.php");
		$total_fee = number_format($total_money*100,0,'.','');
		$refund_fee = number_format($refund_money*100,0,'.','');
		//输入需退款的订单号
		if ($out_trade_no)
		{
			//商户退款单号，商户自定义，此处仅作举例
			//$out_refund_no = "$out_trade_no"."$time_stamp";
			//$out_refund_no = "$out_trade_no"."123";
			
			//使用退款接口
			$refund = new Refund_pub();
			//设置必填参数
			//appid已填,商户无需重复填写
			//mch_id已填,商户无需重复填写
			//noncestr已填,商户无需重复填写
			//sign已填,商户无需重复填写
			$refund->setParameter("out_trade_no","$out_trade_no");//商户订单号
			$refund->setParameter("out_refund_no","$out_refund_no");//商户退款单号
			$refund->setParameter("total_fee","$total_fee");//总金额
			$refund->setParameter("refund_fee","$refund_fee");//退款金额
			$refund->setParameter("op_user_id",$WDT_MCHID);//操作员
			//非必填参数，商户可根据实际情况选填
			//$refund->setParameter("sub_mch_id","XXXX");//子商户号 
			$refund->setParameter("device_info",$openid);//设备号 
			$refund->setParameter("transaction_id",$transaction_id);//微信订单号
			
			//调用结果
			$refundResult = $refund->getResult();
			
			//商户根据实际情况设置相应的处理流程,此处仅作举例
			if ($refundResult["return_code"] == "FAIL") {
				//echo "通信出错：".$refundResult['return_msg']."<br>";
				return array('ret'=>false,'msg'=>"通信出错：".$refundResult['return_msg']);
			}
			else{
				//echo "业务结果：".$refundResult['result_code']."<br>";
				//echo "错误代码：".$refundResult['err_code']."<br>";
				//echo "错误代码描述：".$refundResult['err_code_des']."<br>";
				//echo "公众账号ID：".$refundResult['appid']."<br>";
				//echo "商户号：".$refundResult['mch_id']."<br>";
				//echo "子商户号：".$refundResult['sub_mch_id']."<br>";
				//echo "设备号：".$refundResult['device_info']."<br>";
				//echo "签名：".$refundResult['sign']."<br>";
				//echo "微信订单号：".$refundResult['transaction_id']."<br>";
				//echo "商户订单号：".$refundResult['out_trade_no']."<br>";
				//echo "商户退款单号：".$refundResult['out_refund_no']."<br>";
				//echo "微信退款单号：".$refundResult['refund_idrefund_id']."<br>";
				//echo "退款渠道：".$refundResult['refund_channel']."<br>";
				//echo "退款金额：".$refundResult['refund_fee']."<br>";
				//echo "现金券退款金额：".$refundResult['coupon_refund_fee']."<br>";
				return array(
					'ret'=>true,
					'msg'=>'退款成功！',
					'result_code'=>$refundResult['result_code'],
					'err_code'=>$refundResult['err_code'],
					'err_code_des'=>$refundResult['err_code_des'],
					'appid'=>$refundResult['appid'],
					'mch_id'=>$refundResult['mch_id'],
					'sub_mch_id'=>$refundResult['sub_mch_id'],
					'device_info'=>$refundResult['device_info'],
					'sign'=>$refundResult['sign'],
					'transaction_id'=>$refundResult['transaction_id'],
					'out_trade_no'=>$refundResult['out_trade_no'],
					'out_refund_no'=>$refundResult['out_refund_no'],
					'refund_idrefund_id'=>$refundResult['refund_idrefund_id'],
					'refund_channel'=>$refundResult['refund_channel'],
					'refund_fee'=>$refundResult['refund_fee'],
					'coupon_refund_fee'=>$refundResult['coupon_refund_fee'],
				);
			}
		}
	}

	/*
		微信动态二维码支付  Native（原生）支付-模式二

		describe 商品描述
		out_trade_no 商户订单号
		openid 设备号 用户标识 用户微信ID
		total_money 总金额 订单总金额，单位为分，不能带小数点
		glide    附加数据，原样返回
	*/
	public function nativeDynamicWx($describe,$out_trade_no,$openid,$total_money,$glide){
		global $WDT_JS_API_CALL_URL,$WDT_NOTIFY_URL,$WDT_APPID,$WDT_MCHID;
		include_once("./WxPayPubHelper/WxPayPubHelper.php");
		$total_fee = number_format($total_money*100,0,'.','');
		//使用统一支付接口
		$unifiedOrder = new UnifiedOrder_pub();
		//设置统一支付接口参数
		//设置必填参数
		$unifiedOrder->setParameter("body",$describe);//商品描述
		//自定义订单号，此处仅作举例
		//$timeStamp = time();
		//$out_trade_no = $WDT_APPID."$timeStamp";
		$unifiedOrder->setParameter("out_trade_no","$out_trade_no");//商户订单号 
		$unifiedOrder->setParameter("total_fee",$total_fee);//总金额
		$unifiedOrder->setParameter("notify_url",$WDT_NOTIFY_URL);//通知地址 
		$unifiedOrder->setParameter("trade_type","NATIVE");//交易类型
		//非必填参数，商户可根据实际情况选填
		//$unifiedOrder->setParameter("sub_mch_id","XXXX");//子商户号  
		$unifiedOrder->setParameter("device_info",$openid);//设备号 
		$unifiedOrder->setParameter("attach",$glide);//附加数据 
		//$unifiedOrder->setParameter("time_start","XXXX");//交易起始时间
		//$unifiedOrder->setParameter("time_expire","XXXX");//交易结束时间 
		//$unifiedOrder->setParameter("goods_tag","XXXX");//商品标记 
		//$unifiedOrder->setParameter("openid",$openid);//用户标识
		//$unifiedOrder->setParameter("product_id","XXXX");//商品ID
		//获取统一支付接口结果
		$unifiedOrderResult = $unifiedOrder->getResult();
		
		//商户根据实际情况设置相应的处理流程
		if ($unifiedOrderResult["return_code"] == "FAIL") 
		{
			//商户自行增加处理流程
			//echo "通信出错：".$unifiedOrderResult['return_msg']."<br>";
			return array('ret'=>false,'msg'=>"通信出错：".$unifiedOrderResult['return_msg']);
		}
		elseif($unifiedOrderResult["result_code"] == "FAIL")
		{
			//商户自行增加处理流程
			//echo "错误代码：".$unifiedOrderResult['err_code']."<br>";
			//echo "错误代码描述：".$unifiedOrderResult['err_code_des']."<br>";
			return array('ret'=>false,'msg'=>"错误代码：".$unifiedOrderResult['err_code']);
		}
		elseif($unifiedOrderResult["code_url"] != NULL)
		{
			//从统一支付接口获取到code_url
			$code_url = $unifiedOrderResult["code_url"];
			//商户自行增加处理流程
			//......
			return array('ret'=>true,'msg'=>"生成成功",'code_url'=>$code_url);
		}
	}


	/**
     * 企业付款测试2017/2/10
     */
    public function rebate($out_trade_no,$openid,$total_money,$glide,$cur_ip,$desc,$username)
    {
        global $WDT_JS_API_CALL_URL,$WDT_NOTIFY_URL,$WDT_APPID;
		include_once("./WxPayPubHelper/WxPayPubHelper.php");

		$fp=fopen('rebate111.txt','a');
		fwrite($fp,'out_trade_no='.$out_trade_no.' openid='.$openid.' total_money='.$total_money.' glide='.$glide.' cur_ip='.$cur_ip.' desc='.$desc.' username='.$username."\r\n");
		fclose($fp);

        $mchPay = new WxMchPay();

		//var_dump($mchPay);
        // 用户openid
        //$mchPay->setParameter('openid', 'o_D46w3Hfs2jFkUw0VChiUzUt8B0');
        $mchPay->setParameter('openid', $openid);
        // 商户订单号
        //$mchPay->setParameter('partner_trade_no', 'test-'.time());
        $mchPay->setParameter('partner_trade_no',$out_trade_no);
        // 校验用户姓名选项
        $mchPay->setParameter('check_name', 'NO_CHECK');


		// 校验用户姓名选项 NO_CHECK：不校验真实姓名 FORCE_CHECK：强校验真实姓名
        //$mchPay->setParameter('check_name', 'FORCE_CHECK');
		//收款人姓名 收款用户真实姓名。 如果check_name设置为FORCE_CHECK，则必填用户真实姓名
        //$mchPay->setParameter('re_user_name', $realname);


        // 企业付款金额  单位为分 最小100 即1元
        //$mchPay->setParameter('amount', 100);
        $mchPay->setParameter('amount', $total_money);
        // 企业付款描述信息
        //$mchPay->setParameter('desc', '开发测试');
        $mchPay->setParameter('desc', $desc);
        // 调用接口的机器IP地址  自定义
        $mchPay->setParameter('spbill_create_ip', $cur_ip); # getClientIp()
        // 收款用户姓名
        $mchPay->setParameter('re_user_name', $username);//Max wen
        // 设备信息
        $mchPay->setParameter('device_info', $glide);
        $response = $mchPay->postXmlSSL();
		//echo "response=".urldecode($response)."<BR>";
        if( !empty($response) ) {
            $data = simplexml_load_string($response, null, LIBXML_NOCDATA);
			$getval = json_decode(json_encode($data),true);
$fp=fopen('33333getval.txt','a');
fwrite($fp,var_export($getval,true)."\r\n");
fclose($fp);
			if($getval['return_code']=='SUCCESS'){
				if($getval['result_code']=='SUCCESS'){
					return array('ret'=>true,'result'=>true,'msg'=>'打款成功');
				}else{
					return array('ret'=>true,'result'=>false,'msg'=>$getval['return_msg'],'code'=>$getval['return_code']);
				}
			}else{
				return array('ret'=>false,'result'=>false,'msg'=>$getval['return_msg'],'code'=>$getval['return_code']);
			}
			//$aa = json_encode($data);
            //echo urldecode(json_encode($data));
			//urldecode
        }else{
			return array('ret'=>false,'result'=>false,'msg'=>'接口出错');
            //echo json_encode( array('return_code' => 'FAIL', 'return_msg' => 'transfers_接口出错', 'return_ext' => array()) );
        }
    }
 }
?>