<?php
	//YoSmart 智能设备接口
	class YoSmart{
		var $KTT_CSID = "";
		var $url = "";
		var $YSArr = array();
		public function __construct($CSID,$url){
			$this->KTT_CSID = $CSID;
			$this->url		= $url;
			$this->YSArr	= array(
				'ApartmentLock_getState' => '获取锁的状态',
				'ApartmentLock_lock'	 => '上锁',
				'ApartmentLock_unlock'   => '开锁'
			);
		}
		/*
			网关
			增加网关   Add Hub
			hubId 网关的编号ID  必选string
			hubPwd 网关的密码	必选string
			返回：
				deviceId 网关编号
				deviceUDID 网关的唯一识别码
				token 网关的通信令牌
				name 网关的名称
				type 网关的类型
		*/
		public function Manage_addHub($hubId,$hubPwd){
			$data = array(
				"method"		=> "Manage.addHub",
				"time"			=> $this->microtime_c(),
				"params"		=> array(
					'hubId'		=> $hubId,
					'hubPwd'	=> md5($hubPwd)
				)
			);
			return $this->ys_post($data);
		}
		/*
			网关
			搜索子设备  Search Device
			hubId 网关编号 
			token 网关的通信令牌
			返回：List 列表
				deviceId 搜索到的子设备编号
				deviceUDID 子设备的唯一编号
				token 子设备的通信令牌
				name 子设备的名称
				type 子设备的类型名
		*/
		public function Manage_searchDevice($hubId,$token){
			$data = array(
				"method"		=> "Manage.searchDevice",
				"time"			=> $this->microtime_c(),
				"targetDevice"	=> $hubId,
				"token"			=> $token
			);
			return $this->ys_post($data);
		}
		/*
			网关
			获取主控下的API授权设备    Get API Added Devices
			hubId 主控设备Id
			返回：List 列表
				deviceId 搜索到的子设备编号
				deviceUDID 设备的唯一编号
				token 设备的通信令牌
				name 设备的名称
				type 设备的类型名
		*/
		public function Manage_getAddedDevices($hubId){
			$data = array(
				"method"		=> "Manage.getAddedDevices",
				"time"			=> $this->microtime_c(),
				"params"		=> array(
					"hubId"		=> $hubId
				)
			);
			return $this->ys_post($data);
		}
		/*
			网关
			取得网关的通用属性    Get General Info
			hubId 网关编号 
			token 网关的通信令牌
			返回：
				name 网关名
				zip  邮编，定义为店铺编号
				firmVersion 网关的固件版本
				binVersion Version of WebService
				rfmVersion 网关的无线版本    Version of RF Module 
		*/
		public function Hub_getGeneralInfo($hubId,$token){
			$data = array(
				"method"		=> "Hub.getGeneralInfo",
				"time"			=> $this->microtime_c(),
				"targetDevice"	=> $hubId,
				"token"			=> $token
			);
			return $this->ys_post($data);
		}
		/*
			网关
			设置网关的通用属性    Set General Info
			hubId 网关编号 
			token 网关的通信令牌
			name  设置网关名称
			shopcode 店铺编号
			返回：
				网关名称
		*/
		public function Hub_setGeneralInfo($hubId,$token,$name,$shopcode){
			$data = array(
				"method"		=> "Hub.setGeneralInfo",
				"time"			=> $this->microtime_c(),
				"targetDevice"	=> $hubId,
				"token"			=> $token,
				"params"		=> array(
					'name'		=> $name,
					'zip'		=> $shopcode
				)
			);
			return $this->ys_post($data);
		}
		/*
			网关
			取得网关的网络属性   Get Network Info
			hubId 网关编号 
			token 网关的通信令牌
			返回：
				ip 网关的IP地址
				webPort 网关的端口
				gateway 当前的网络网关
				subnetMask 网关的子网掩码
				dhcp 是否DHCP自动IP
				mac 网关的物理地址
		*/
		public function Hub_getNetworkInfo($hubId,$token){
			$data = array(
				"method"		=> "Hub.getNetworkInfo",
				"time"			=> $this->microtime_c(),
				"targetDevice"	=> $hubId,
				"token"			=> $token
			);
			return $this->ys_post($data);
		}
		/*
			公寓版门锁接口
			获取锁的状态    Get Lock State
			deviceId 锁的设备编号 
			token 锁的通信令牌
			返回：
				state 锁当前的状态
				battery 锁当前的电池状态
		*/
		public function ApartmentLock_getState($deviceId,$token){
			$data = array(
				"method"		=> "ApartmentLock.getState",
				"time"			=> $this->microtime_c(),
				"targetDevice"	=> $deviceId,
				"token"			=> $token
			);
			return $this->ys_post($data);
		}
		/*
			公寓版门锁接口
			上锁    Lock
			deviceId 锁的设备编号 
			token 锁的通信令牌
			返回：
				state 锁当前的状态
				battery 锁当前的电池状态
		*/
		public function ApartmentLock_lock($deviceId,$token){
			$data = array(
				"method"		=> "ApartmentLock.lock",
				"time"			=> $this->microtime_c(),
				"targetDevice"	=> $deviceId,
				"token"			=> $token
			);
			return $this->ys_post($data);
		}
		/*
			公寓版门锁接口
			开锁   Unlock
			deviceId 锁的设备编号 
			token 锁的通信令牌
			返回：
				state 锁当前的状态
				battery 锁当前的电池状态
		*/
		public function ApartmentLock_unlock($deviceId,$token){
			$data = array(
				"method"		=> "ApartmentLock.unlock",
				"time"			=> $this->microtime_c(),
				"targetDevice"	=> $deviceId,
				"token"			=> $token
			);
			return $this->ys_post($data);
		}
		/*
			公寓版门锁接口
			添加客户密码    Add Password
			deviceId 锁的设备编号 
			token 锁的通信令牌
			password 密码，6-8位数字
			expires 密码有效期，单位是小时。传空意味着不设置。默认为永远有效。时间要大于1
			enable 密码有效性，默认有效。
			返回：
				state 执行结果，SetSuccess/SetFailed
		*/
		public function ApartmentLock_addPwd($deviceId,$token,$password,$expires='',$enable=true){
			$data = array(
				"method"		=> "ApartmentLock.addPwd",
				"time"			=> $this->microtime_c(),
				"targetDevice"	=> $deviceId,
				"token"			=> $token,
				'params'		=> array(
					'password'	=> $password,
					'expires'	=> $expires ,
					'enable'	=> $enable
				)
			);
			return $this->ys_post($data);
		}
		/*
			公寓版门锁接口
			修改客户密码     Update Password
			deviceId 锁的设备编号 
			token 锁的通信令牌
			oldPwd 需要修改的旧密码，6-8位数字
			newPwd 需要修改为的新密码，6-8为数字；为空时 不修改密码。
			expires 不为空时，设置新的有效期，单位为小时。-1表示修改为永远有效。
			enable 不为空时，设置密码的有效性，true表示密码有效，false表示密码失效。
			返回：
				state 执行结果 SetSuccess/SetFailed
		*/
		public function ApartmentLock_updatePwd($deviceId,$token,$oldPwd,$newPwd,$expires='',$enable=true){
			$data = array(
				"method"		=> "ApartmentLock.updatePwd",
				"time"			=> $this->microtime_c(),
				"targetDevice"	=> $deviceId,
				"token"			=> $token,
				'params'		=> array(
					'oldPwd'	=> $oldPwd,
					'newPwd'	=> $newPwd,
					'expires'	=> $expires ,
					'enable'	=> $enable
				)
			);
			return $this->ys_post($data);
		}
		/*
			公寓版门锁接口
			获取临时密码     Get Temporary Password  密码不能开锁
			deviceId 锁的设备编号 
			token 锁的通信令牌
			expires 临时密码有效期，单位为小时，大于0 小于168(一周内)
			返回：
				password 临时密码
				expires 有效截止时间 ，时间戳
		*/
		public function ApartmentLock_getTemporaryPassword($deviceId,$token,$expires){
			$data = array(
				"method"		=> "ApartmentLock.getTemporaryPassword",
				"time"			=> $this->microtime_c(),
				"targetDevice"	=> $deviceId,
				"token"			=> $token,
				'params'		=> array(
					'expires'	=> $expires
				)
			);
			return $this->ys_post($data);
		}
		/*
			公寓版门锁接口
			修改管理员密码     Update Super Password 修改客户密码都要旧密码为啥修改管理员密码不要旧密码
			deviceId 锁的设备编号 
			token 锁的通信令牌
			password 新的管理员密码,8位数字
			返回：
				state 执行结果 SetSuccess/SetFailed
		*/
		public function ApartmentLock_updateSuperPwd($deviceId,$token,$password){
			$data = array(
				"method"		=> "ApartmentLock.updateSuperPwd",
				"time"			=> $this->microtime_c(),
				"targetDevice"	=> $deviceId,
				"token"			=> $token,
				'params'		=> array(
					'password'	=> $password
				)
			);
			return $this->ys_post($data);
		}
		/*
			公寓版门锁接口
			删除密码     Delete Password
			deviceId 锁的设备编号 
			token 锁的通信令牌
			password 需要删除的密码
			返回：
				state 执行结果 SetSuccess/SetFailed
		*/
		public function ApartmentLock_delPwd($deviceId,$token,$password){
			$data = array(
				"method"		=> "ApartmentLock.delPwd",
				"time"			=> $this->microtime_c(),
				"targetDevice"	=> $deviceId,
				"token"			=> $token,
				'params'		=> array(
					'password'	=> $password
				)
			);
			return $this->ys_post($data);
		}
		/*
			公寓版门锁接口
			清空密码     Clear Password
			deviceId 锁的设备编号 
			token 锁的通信令牌
			password 需要删除的密码
			返回：
				state 执行结果 SetSuccess/SetFailed
		*/
		public function ApartmentLock_clearPwd($deviceId,$token,$password){
			$data = array(
				"method"		=> "ApartmentLock.clearPwd",
				"time"			=> $this->microtime_c(),
				"targetDevice"	=> $deviceId,
				"token"			=> $token
			);
			return $this->ys_post($data);
		}
		/*
			智能密码锁
			获取锁的状态    Get Lock State
			deviceId 锁的设备编号 
			token 锁的通信令牌
			password 需要删除的密码
			返回：
				state 当前锁的状态：开、关 Locked/UnLocked
				battery 锁的电池状态
		*/
		public function Lock_getState($deviceId,$token,$password){
			$data = array(
				"method"		=> "Lock.getState",
				"time"			=> $this->microtime_c(),
				"targetDevice"	=> $deviceId,
				"token"			=> $token
			);
			return $this->ys_post($data);
		}
		/*
			智能密码锁
			上锁    Lock
			deviceId 锁的设备编号 
			token 锁的通信令牌
			返回：
				state 当前锁定状态 Locked/UnLocked
				battery 锁的电池状态
		*/
		public function Lock_lock($deviceId,$token){
			$data = array(
				"method"		=> "Lock.lock",
				"time"			=> $this->microtime_c(),
				"targetDevice"	=> $deviceId,
				"token"			=> $token
			);
			return $this->ys_post($data);
		}
		/*
			智能密码锁
			开锁   Unlock
			deviceId 锁的设备编号 
			token 锁的通信令牌
			返回：
				state 当前锁定状态 Locked/UnLocked
				battery 锁的电池状态
		*/
		public function Lock_unlock($deviceId,$token){
			$data = array(
				"method"		=> "Lock.unlock",
				"time"			=> $this->microtime_c(),
				"targetDevice"	=> $deviceId,
				"token"			=> $token
			);
			return $this->ys_post($data);
		}
		/*
			智能密码锁
			添加开锁密码    Add Password
			deviceId 锁的设备编号 
			token 锁的通信令牌
			password 密码为6至8位数字，正则表达式     Format:/^\d{2,8}$/;
			返回：
				state 当前锁定状态 Locked/UnLocked
				battery 锁的电池状态
		*/
		public function Lock_addPwd($deviceId,$token,$password){
			$data = array(
				"method"		=> "Lock.addPwd",
				"time"			=> $this->microtime_c(),
				"targetDevice"	=> $deviceId,
				"token"			=> $token,
				'params'		=> array(
					'password'	=> $password
				)
			);
			return $this->ys_post($data);
		}
		/*
			智能密码锁
			删除密码     Delete Password
			deviceId 锁的设备编号 
			token 锁的通信令牌
			password 密码为6至8位数字，正则表达式     Format:/^\d{2,8}$/;
			返回：
				state 当前锁定状态 Locked/UnLocked
				battery 锁的电池状态
		*/
		public function Lock_delPwd($deviceId,$token,$password){
			$data = array(
				"method"		=> "Lock.delPwd",
				"time"			=> $this->microtime_c(),
				"targetDevice"	=> $deviceId,
				"token"			=> $token,
				'params'		=> array(
					'password'	=> $password
				)
			);
			return $this->ys_post($data);
		}
		/*
			智能密码锁
			清空密码     Clear Password
			deviceId 锁的设备编号 
			token 锁的通信令牌
			password 需要删除的密码
			返回：
				state 当前锁定状态 Locked/UnLocked
				battery 锁的电池状态
		*/
		public function Lock_clearPwd($deviceId,$token,$password){
			$data = array(
				"method"		=> "Lock.clearPwd",
				"time"			=> $this->microtime_c(),
				"targetDevice"	=> $deviceId,
				"token"			=> $token
			);
			return $this->ys_post($data);
		}
		/*
			智能窗帘电机 Curtain Method
			获取状态     Get Curtain State
			deviceId 窗帘设备编号 
			token 窗帘的通信令牌
			返回：
				没有返回状态
		*/
		public function Curtain_getState($deviceId,$token,$password){
			$data = array(
				"method"		=> "Curtain.getState",
				"time"			=> $this->microtime_c(),
				"targetDevice"	=> $deviceId,
				"token"			=> $token
			);
			return $this->ys_post($data);
		}
		/*
			智能窗帘电机 Curtain Method
			打开     Open Curtain
			deviceId 窗帘设备编号 
			token 窗帘的通信令牌
			params If not set,open to MAXSIZE;
			percent Percent to open;0-100;0 is close;100 is MAXSIZE
			返回：
				brightness 0-100;0 is off;
		*/
		public function Curtain_open($deviceId,$token,$percent){
			$data = array(
				"method"		=> "Curtain.open",
				"time"			=> $this->microtime_c(),
				"targetDevice"	=> $deviceId,
				"token"			=> $token,
				"params"		=> array(
					'percent'	=> 100
				)
			);
			return $this->ys_post($data);
		}
		/*
			智能窗帘电机 Curtain Method
			关闭     Close Curtain
			deviceId 窗帘设备编号 
			token 窗帘的通信令牌
			返回：
				空
		*/
		public function Curtain_close($deviceId,$token,$percent){
			$data = array(
				"method"		=> "Curtain.close",
				"time"			=> $this->microtime_c(),
				"targetDevice"	=> $deviceId,
				"token"			=> $token
			);
			return $this->ys_post($data);
		}
		/*
			智能窗帘电机 Curtain Method
			停止  Stop Curtain
			deviceId 窗帘设备编号 
			token 窗帘的通信令牌
			返回：
				空
		*/
		public function Curtain_stop($deviceId,$token,$percent){
			$data = array(
				"method"		=> "Curtain.stop",
				"time"			=> $this->microtime_c(),
				"targetDevice"	=> $deviceId,
				"token"			=> $token
			);
			return $this->ys_post($data);
		}
		/*
			无线门磁,智能水浸传感器 GasSensor Method
			Get Last Reported Data
			deviceId 门磁设备编号 
			token 门磁的通信令牌
			返回：
				battery 电池电量，Low/Normal
				state 设备状态 Normal/Broken/Alert
		*/
		public function GasSensor_getLastReport($deviceId,$token,$percent){
			$data = array(
				"method"		=> "GasSensor.getLastReport",
				"time"			=> $this->microtime_c(),
				"targetDevice"	=> $deviceId,
				"token"			=> $token
			);
			return $this->ys_post($data);
		}
		/*
			无线门磁 GasSensor Method
			Get Last Reported Data
			deviceId 门磁设备编号 
			token 门磁的通信令牌
			返回：
				battery 电池电量，Low/Normal
				state 设备状态 Values:open/close
				reportTime  时间
				reportType  Values:Report/Alert
		*/
		public function DoorSensor_getLastReport($deviceId,$token,$percent){
			$data = array(
				"method"		=> "DoorSensor.getLastReport",
				"time"			=> $this->microtime_c(),
				"targetDevice"	=> $deviceId,
				"token"			=> $token
			);
			return $this->ys_post($data);
		}
		/*
			智能插座,五孔智能插座,三位智能开关,机械手控制器,智能回路开关 Switch Method
			Get Switch State
			deviceId DeviceId of the lock you use 
			token token of the lock you use;
			返回：
				最大返回3条记录
				state 开关 true/false
				delay 对象
					zone 0-2
					on The remain time of Delay ON;Unit of mintuter;0 is OFF
					off The remain time of Delay OFF;Unit of mintuter;0 is OFF
				time 时间戳
		*/
		public function Switch_getState($deviceId,$token,$percent){
			$data = array(
				"method"		=> "Switch.getState",
				"time"			=> $this->microtime_c(),
				"targetDevice"	=> $deviceId,
				"token"			=> $token
			);
			return $this->ys_post($data);
		}
		/*
			智能插座,五孔智能插座,三位智能开关,机械手控制器,智能回路开关 Switch Method
			设置开/关 Set Switch State (ON/OFF)
			deviceId DeviceId of the lock you use 
			token token of the lock you use;
			state true means ON and false is OFF;
			zone The zone you want to set state(ON/OFF);0-2 means the buttons's index;default is 0;255 means ALL zones;
			返回：
				最大返回3条记录
				state 开关 true/false
				delay 对象
					zone 0-2
					on The remain time of Delay ON;Unit of mintuter;0 is OFF
					off The remain time of Delay OFF;Unit of mintuter;0 is OFF
				time 时间戳
		*/
		public function Switch_setState($deviceId,$token,$percent,$state,$zone=0){
			$data = array(
				"method"		=> "Switch.setState",
				"time"			=> $this->microtime_c(),
				"targetDevice"	=> $deviceId,
				"token"			=> $token,
				'params'		=> array(
					'zone'		=> $zone,//三位智能开关号0-2
					'state'		=> $state
				)
			);
			return $this->ys_post($data);
		}
		/*
			智能插座,五孔智能插座,三位智能开关,机械手控制器,智能回路开关 Switch Method
			延迟开 Set Delay ON
			deviceId DeviceId of the lock you use 
			token token of the lock you use;
			time The time you want to Delay ON;Unit of mintuter;0 is cancel delay
			zone The zone you want to set;0-2 means the buttons's index;default is 0;
		*/
		public function Switch_setDelayOn($deviceId,$token,$percent,$time,$zone=0){
			$data = array(
				"method"		=> "Switch.setDelayOn",
				"time"			=> $this->microtime_c(),
				"targetDevice"	=> $deviceId,
				"token"			=> $token,
				'params'		=> array(
					'zone'		=> $zone,
					'time'		=> $time
				)
			);
			return $this->ys_post($data);
		}
		/*
			智能插座,五孔智能插座,三位智能开关,机械手控制器,智能回路开关 Switch Method
			延迟关 Set Delay OFF
			deviceId DeviceId of the lock you use 
			token token of the lock you use;
			time The time you want to Delay ON;Unit of mintuter;0 is cancel delay
			zone The zone you want to set;0-2 means the buttons's index;default is 0;
		*/
		public function Switch_setDelayOff($deviceId,$token,$percent,$time,$zone=0){
			$data = array(
				"method"		=> "Switch.setDelayOff",
				"time"			=> $this->microtime_c(),
				"targetDevice"	=> $deviceId,
				"token"			=> $token,
				'params'		=> array(
					'zone'		=> $zone,
					'time'		=> $time
				)
			);
			return $this->ys_post($data);
		}
		/*
			智能插座,五孔智能插座,三位智能开关,机械手控制器,智能回路开关 Switch Method
			获取定时列表 Get Schedule List
			deviceId DeviceId of the lock you use 
			token token of the lock you use;
			返回 Schedules list
				index
				onTime
				offTime
				zoneMask
				weekMase
		*/
		public function Switch_getSchedules($deviceId,$token,$percent,$time,$zone=0){
			$data = array(
				"method"		=> "Switch.getSchedules",
				"time"			=> $this->microtime_c(),
				"targetDevice"	=> $deviceId,
				"token"			=> $token
			);
			return $this->ys_post($data);
		}
		/*
			智能插座,五孔智能插座,三位智能开关,机械手控制器,智能回路开关 Switch Method
			设置定时 Set Schedule
			deviceId DeviceId of the lock you use 
			token token of the lock you use;
			index Index of this record ;If this recored existed ,update it ;Otherwise insert it; 
			onTime time to turn on; HH:mm
			offTime time to turn off; HH:mm
			zoneMask mask of effected zones
			weekMask mask of effected days(Sunday to Saturday);
		*/
		public function Switch_setSchedule($deviceId,$token,$percent,$time,$zone=0){
			$data = array(
				"method"		=> "Switch.setSchedule",
				"time"			=> $this->microtime_c(),
				"targetDevice"	=> $deviceId,
				"token"			=> $token,
				'params'		=> array(
					'index'		=> $zone,
					'onTime'	=> $onTime,
					'offTime'	=> $offTime,
					'zoneMask'	=> $zoneMask,
					'weekMask'	=> $weekMask
				)
			);
			return $this->ys_post($data);
		}
		/*
			智能插座,五孔智能插座,三位智能开关,机械手控制器,智能回路开关 Outlet Method
			Get Switch State
			deviceId DeviceId of the lock you use 
			token token of the lock you use;
			返回：
				state 状态 true/false
				delay 对象
					on
					off
				time
		*/
		public function Outlet_getState($deviceId,$token,$percent){
			$data = array(
				"method"		=> "Outlet.getState",
				"time"			=> $this->microtime_c(),
				"targetDevice"	=> $deviceId,
				"token"			=> $token
			);
			return $this->ys_post($data);
		}
		/*
			智能插座,五孔智能插座,三位智能开关,机械手控制器,智能回路开关 Outlet Method
			设置开/关 Set Switch State (ON/OFF)
			deviceId DeviceId of the lock you use 
			token token of the lock you use;
			state true means ON and false is OFF;
			zone The zone you want to set state(ON/OFF);0-2 means the buttons's index;default is 0;255 means ALL zones;
			返回：
				state 状态 true/false
				delay 对象
					on
					off
				time
		*/
		public function Outlet_setState($deviceId,$token,$percent,$state,$zone=0){
			$data = array(
				"method"		=> "Outlet.setState",
				"time"			=> $this->microtime_c(),
				"targetDevice"	=> $deviceId,
				"token"			=> $token,
				'params'		=> array(
					'zone'		=> $zone,//三位智能开关号0-2
					'state'		=> $state
				)
			);
			return $this->ys_post($data);
		}
		/*
			智能插座,五孔智能插座,三位智能开关,机械手控制器,智能回路开关 Outlet Method
			延迟开 Set Delay ON
			deviceId DeviceId of the lock you use 
			token token of the lock you use;
			time The time you want to Delay ON;Unit of mintuter;0 is cancel delay
			zone The zone you want to set;0-2 means the buttons's index;default is 0;
		*/
		public function Outlet_setDelayOn($deviceId,$token,$percent,$time,$zone=0){
			$data = array(
				"method"		=> "Outlet.setDelayOn",
				"time"			=> $this->microtime_c(),
				"targetDevice"	=> $deviceId,
				"token"			=> $token,
				'params'		=> array(
					'zone'		=> $zone,
					'time'		=> $time
				)
			);
			return $this->ys_post($data);
		}
		/*
			智能插座,五孔智能插座,三位智能开关,机械手控制器,智能回路开关 Outlet Method
			延迟关 Set Delay OFF
			deviceId DeviceId of the lock you use 
			token token of the lock you use;
			time The time you want to Delay ON;Unit of mintuter;0 is cancel delay
			zone The zone you want to set;0-2 means the buttons's index;default is 0;
		*/
		public function Outlet_setDelayOff($deviceId,$token,$percent,$time,$zone=0){
			$data = array(
				"method"		=> "Outlet.setDelayOff",
				"time"			=> $this->microtime_c(),
				"targetDevice"	=> $deviceId,
				"token"			=> $token,
				'params'		=> array(
					'zone'		=> $zone,
					'time'		=> $time
				)
			);
			return $this->ys_post($data);
		}
		/*
			智能插座,五孔智能插座,三位智能开关,机械手控制器,智能回路开关 Outlet Method
			获取定时列表 Get Schedule List
			deviceId DeviceId of the lock you use 
			token token of the lock you use;
			返回 Schedules list
				index
				onTime
				offTime
				zoneMask
				weekMase
		*/
		public function Outlet_getSchedules($deviceId,$token,$percent,$time,$zone=0){
			$data = array(
				"method"		=> "Outlet.getSchedules",
				"time"			=> $this->microtime_c(),
				"targetDevice"	=> $deviceId,
				"token"			=> $token
			);
			return $this->ys_post($data);
		}
		/*
			智能插座,五孔智能插座,三位智能开关,机械手控制器,智能回路开关 Outlet Method
			设置定时 Set Schedule
			deviceId DeviceId of the lock you use 
			token token of the lock you use;
			index Index of this record ;If this recored existed ,update it ;Otherwise insert it; 
			onTime time to turn on; HH:mm
			offTime time to turn off; HH:mm
			zoneMask mask of effected zones
			weekMask mask of effected days(Sunday to Saturday);
		*/
		public function Outlet_setSchedule($deviceId,$token,$percent,$time,$zone=0){
			$data = array(
				"method"		=> "Outlet.setSchedule",
				"time"			=> $this->microtime_c(),
				"targetDevice"	=> $deviceId,
				"token"			=> $token,
				'params'		=> array(
					'index'		=> $zone,
					'onTime'	=> $onTime,
					'offTime'	=> $offTime,
					'zoneMask'	=> $zoneMask,
					'weekMask'	=> $weekMask
				)
			);
			return $this->ys_post($data);
		}
		/*
			智能插座,五孔智能插座,三位智能开关,机械手控制器,智能回路开关 Outlet Method
			获取版本号 Get Outlet VersionInfo
			deviceId DeviceId of the lock you use 
			token token of the lock you use;
			返回 Schedules list
				index
				onTime
				offTime
				zoneMask
				weekMase
		*/
		public function Outlet_getVersion($deviceId,$token,$percent,$time,$zone=0){
			$data = array(
				"method"		=> "Outlet.getVersion",
				"time"			=> $this->microtime_c(),
				"targetDevice"	=> $deviceId,
				"token"			=> $token
			);
			return $this->ys_post($data);
		}
		/*
			彩色灯 RGB Bulb Method
			获取彩色灯的状态 Get Bulb State
			deviceId DeviceId of the lock you use 
			token token of the lock you use;
			返回 
				state  open/close;
		*/
		public function RGBBulb_getState($deviceId,$token){
			$data = array(
				"method"		=> "RGBBulb.getState",
				"time"			=> $this->microtime_c(),
				"targetDevice"	=> $deviceId,
				"token"			=> $token
			);
			return $this->ys_post($data);
		}
		/*
			彩色灯 RGB Bulb Method
			设置彩色灯 Set Bulb State
			deviceId DeviceId of the lock you use 
			token token of the lock you use;
			返回 
				state  open/close;
		*/
		public function RGBBulb_setState($deviceId,$token,$mode,$color,$speed){
			$data = array(
				"method"		=> "RGBBulb.setState",
				"time"			=> $this->microtime_c(),
				"targetDevice"	=> $deviceId,
				"token"			=> $token,
				'params'		=> array(
					'mode'		=> $mode,
					'color'		=> $color,
					'speed'		=> $speed
				)
			);
			return $this->ys_post($data);
		}
		/*
			彩色灯 RGB Bulb Method
			关闭彩色灯 Close Bulb
			deviceId DeviceId of the lock you use 
			token token of the lock you use;
			返回 
				state  open/close;
		*/
		public function RGBBulb_close($deviceId,$token){
			$data = array(
				"method"		=> "RGBBulb.close",
				"time"			=> $this->microtime_c(),
				"targetDevice"	=> $deviceId,
				"token"			=> $token,
				'params'		=> array()
			);
			return $this->ys_post($data);
		}
		/*
			彩色灯 RGB Bulb Method
			获取彩灯版本  Get VersionInfo
			deviceId DeviceId of the lock you use 
			token token of the lock you use;
			返回 
				version  当前版本 Current Version
				newVersion
					versionId  新版本的ID
					versionCode 新版本号
					fileSize   文件大小
		*/
		public function RGBBulb_getVersion($deviceId,$token){
			$data = array(
				"method"		=> "RGBBulb.getVersion",
				"time"			=> $this->microtime_c(),
				"targetDevice"	=> $deviceId,
				"token"			=> $token
			);
			return $this->ys_post($data);
		}
		/*
			机械臂 MCB Controller Method
			获取机械臂控制器的状态  Get Manipulator Controller State
			deviceId DeviceId of the lock you use 
			token token of the lock you use;
			返回 
				open/close/error
		*/
		public function MCBController_getState($deviceId,$token){
			$data = array(
				"method"		=> "MCBController.getState",
				"time"			=> $this->microtime_c(),
				"targetDevice"	=> $deviceId,
				"token"			=> $token
			);
			return $this->ys_post($data);
		}
		/*
			机械臂 MCB Controller Method
			打开机械臂控制器  Open Manipulator Controller
			deviceId DeviceId of the lock you use 
			token token of the lock you use;
			params  If not set,open to MAXSIZE
			返回 
				open/close/error
		*/
		public function MCBController_open($deviceId,$token){
			$data = array(
				"method"		=> "MCBController.open",
				"time"			=> $this->microtime_c(),
				"targetDevice"	=> $deviceId,
				"token"			=> $token,
				'params'		=> array()
			);
			return $this->ys_post($data);
		}
		/*
			机械臂 MCB Controller Method
			关闭机械臂控制器  Close Manipulator Controller
			deviceId DeviceId of the lock you use 
			token token of the lock you use;
			返回 
				open/close/error
		*/
		public function MCBController_close($deviceId,$token){
			$data = array(
				"method"		=> "MCBController.close",
				"time"			=> $this->microtime_c(),
				"targetDevice"	=> $deviceId,
				"token"			=> $token
			);
			return $this->ys_post($data);
		}
		/*
			机械臂 MCB Controller Method
			停止机械臂控制器  Stop Manipulator Controller
			deviceId DeviceId of the lock you use 
			token token of the lock you use;
			返回 
				open/close/error
		*/
		public function MCBController_stop($deviceId,$token){
			$data = array(
				"method"		=> "MCBController.stop",
				"time"			=> $this->microtime_c(),
				"targetDevice"	=> $deviceId,
				"token"			=> $token
			);
			return $this->ys_post($data);
		}
		/*
			机械臂 MCB Controller Method
			获取版本  Get VersionInfo
			deviceId DeviceId of the lock you use 
			token token of the lock you use;
			返回 
				version  当前版本 Current Version
				newVersion
					versionId  新版本的ID
					versionCode 新版本号
					fileSize   文件大小
		*/
		public function MCBController_getVersion($deviceId,$token){
			$data = array(
				"method"		=> "MCBController.getVersion",
				"time"			=> $this->microtime_c(),
				"targetDevice"	=> $deviceId,
				"token"			=> $token
			);
			return $this->ys_post($data);
		}
		/*
			全自动门锁
			获取锁的状态    Get Lock State
			deviceId 锁的设备编号 
			token 锁的通信令牌
			返回：
				state 锁当前的状态
				battery 锁当前的电池状态
		*/
		public function AutoLock_getState($deviceId,$token){
			$data = array(
				"method"		=> "AutoLock.getState",
				"time"			=> $this->microtime_c(),
				"targetDevice"	=> $deviceId,
				"token"			=> $token
			);
			return $this->ys_post($data);
		}
		/*
			全自动门锁
			上锁    Lock
			deviceId 锁的设备编号;    DeviceId of the lock you use;
			token    锁的通信令牌;token of the lock you use;
			返回 
				state   锁当前的状态 Locked/UnLocked;   Current lock state;Locked/UnLocked
				battery 锁当前的电池状态。The battery of the lock;Voltage now;will change to per later
		*/
		public function AutoLock_lock($deviceId,$token){
			$data = array(
				"method"		=> "AutoLock.lock",
				"time"			=> $this->microtime_c(),
				"targetDevice"	=> $deviceId,
				"token"			=> $token
			);
			return $this->ys_post($data);
		}
		/*
			全自动门锁
			开锁   Unlock
			deviceId 锁的设备编号;    DeviceId of the lock you use;
			token    锁的通信令牌;token of the lock you use;
			返回 
				state   锁当前的状态 Locked/UnLocked;   Current lock state;Locked/UnLocked
				battery 锁当前的电池状态。The battery of the lock;Voltage now;will change to per later
		*/
		public function AutoLock_unlock($deviceId,$token){
			$data = array(
				"method"		=> "AutoLock.unlock",
				"time"			=> $this->microtime_c(),
				"targetDevice"	=> $deviceId,
				"token"			=> $token
			);
			return $this->ys_post($data);
		}
		//解析返回信息
		public function decodeRet($ret){
			$StatusCode=array(
				'000000'=>'成功',
				'999999'=>'未知错误',
				'000101'=>'无法连接到网关',
				'000102'=>'网关不支持该命令',
				'000103'=>'通信令牌非法',
				'000201'=>'无法连接到设备',
				'000202'=>'设备部支持该命令',
				'000203'=>'无法连接到设备',
				'010000'=>'服务器当前不可用，请稍后重试',
				'010001'=>'当前连接不可用，请稍后重试',
				'010101'=>'包头错误，客户编号错误',
				'010201'=>'包体错误，时间不能为空',
				'010202'=>'包体错误，方法不能为空',
				'010203'=>'包体错误，暂不支持该方法',
				'010200'=>'包体错误，参数非法',
				'020101'=>'该设备不存在',
				'020102'=>'设备密码错误',
				'020201'=>'未发现任何设备',
				'030101'=>'没有任何数据',
			);
			if($ret['code']=='000000'){
				return  array(
					'ret' => true,
					'data' => $ret['data']
				);
			}else{
				return  array(
					'ret' => false,
					'msg' => $StatusCode[$ret['code']]
				);
			}
		}
		//post提交
		function ys_post($postData) {
			$url = $this->url;
			$data = json_encode($postData);
			$ch = curl_init();
			curl_setopt($ch, CURLOPT_POST, TRUE);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
			curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
			curl_setopt($ch, CURLOPT_URL, $url);
			curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
			curl_setopt($ch, CURLOPT_HTTPHEADER, array(
				"Content-Type: application/json; charset=utf-8",
				'KTT-CSID: '.$this->KTT_CSID)
			);
			$response = curl_exec($ch);
			$ret = json_decode($response, TRUE);
			return $this->decodeRet($ret);
		}
		//C格式的时间戳
		function microtime_c(){
			list($usec, $sec) = explode(" ", microtime());
			return round((((float)$usec + (float)$sec))*1000);
		}
		//C的时间戳转换php时间
		function cTimeToPhp($times){
			return date("Y-m-d H:i:s",floor($times/1000));
		}
	}
?>