<?php
/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
namespace TencentCloud\Batch\V20170312\Models;
use TencentCloud\Common\AbstractModel;

/**
 * 应用程序信息
 *
 * @method string getDeliveryForm() 获取应用程序的交付方式，包括PACKAGE、LOCAL 两种取值，分别指远程存储的软件包、计算环境本地。
注意：此字段可能返回 null，表示取不到有效值。
 * @method void setDeliveryForm(string $DeliveryForm) 设置应用程序的交付方式，包括PACKAGE、LOCAL 两种取值，分别指远程存储的软件包、计算环境本地。
注意：此字段可能返回 null，表示取不到有效值。
 * @method string getCommand() 获取任务执行命令。与Commands不能同时指定。
注意：此字段可能返回 null，表示取不到有效值。
 * @method void setCommand(string $Command) 设置任务执行命令。与Commands不能同时指定。
注意：此字段可能返回 null，表示取不到有效值。
 * @method string getPackagePath() 获取应用程序软件包的远程存储路径
注意：此字段可能返回 null，表示取不到有效值。
 * @method void setPackagePath(string $PackagePath) 设置应用程序软件包的远程存储路径
注意：此字段可能返回 null，表示取不到有效值。
 * @method Docker getDocker() 获取应用使用Docker的相关配置。在使用Docker配置的情况下，DeliveryForm 为 LOCAL 表示直接使用Docker镜像内部的应用软件，通过Docker方式运行；DeliveryForm 为 PACKAGE，表示将远程应用包注入到Docker镜像后，通过Docker方式运行。为避免Docker不同版本的兼容性问题，Docker安装包及相关依赖由Batch统一负责，对于已安装Docker的自定义镜像，请卸载后再使用Docker特性。
注意：此字段可能返回 null，表示取不到有效值。
 * @method void setDocker(Docker $Docker) 设置应用使用Docker的相关配置。在使用Docker配置的情况下，DeliveryForm 为 LOCAL 表示直接使用Docker镜像内部的应用软件，通过Docker方式运行；DeliveryForm 为 PACKAGE，表示将远程应用包注入到Docker镜像后，通过Docker方式运行。为避免Docker不同版本的兼容性问题，Docker安装包及相关依赖由Batch统一负责，对于已安装Docker的自定义镜像，请卸载后再使用Docker特性。
注意：此字段可能返回 null，表示取不到有效值。
 * @method array getCommands() 获取任务执行命令信息。与Command不能同时指定。
注意：此字段可能返回 null，表示取不到有效值。
 * @method void setCommands(array $Commands) 设置任务执行命令信息。与Command不能同时指定。
注意：此字段可能返回 null，表示取不到有效值。
 */
class Application extends AbstractModel
{
    /**
     * @var string 应用程序的交付方式，包括PACKAGE、LOCAL 两种取值，分别指远程存储的软件包、计算环境本地。
注意：此字段可能返回 null，表示取不到有效值。
     */
    public $DeliveryForm;

    /**
     * @var string 任务执行命令。与Commands不能同时指定。
注意：此字段可能返回 null，表示取不到有效值。
     */
    public $Command;

    /**
     * @var string 应用程序软件包的远程存储路径
注意：此字段可能返回 null，表示取不到有效值。
     */
    public $PackagePath;

    /**
     * @var Docker 应用使用Docker的相关配置。在使用Docker配置的情况下，DeliveryForm 为 LOCAL 表示直接使用Docker镜像内部的应用软件，通过Docker方式运行；DeliveryForm 为 PACKAGE，表示将远程应用包注入到Docker镜像后，通过Docker方式运行。为避免Docker不同版本的兼容性问题，Docker安装包及相关依赖由Batch统一负责，对于已安装Docker的自定义镜像，请卸载后再使用Docker特性。
注意：此字段可能返回 null，表示取不到有效值。
     */
    public $Docker;

    /**
     * @var array 任务执行命令信息。与Command不能同时指定。
注意：此字段可能返回 null，表示取不到有效值。
     */
    public $Commands;

    /**
     * @param string $DeliveryForm 应用程序的交付方式，包括PACKAGE、LOCAL 两种取值，分别指远程存储的软件包、计算环境本地。
注意：此字段可能返回 null，表示取不到有效值。
     * @param string $Command 任务执行命令。与Commands不能同时指定。
注意：此字段可能返回 null，表示取不到有效值。
     * @param string $PackagePath 应用程序软件包的远程存储路径
注意：此字段可能返回 null，表示取不到有效值。
     * @param Docker $Docker 应用使用Docker的相关配置。在使用Docker配置的情况下，DeliveryForm 为 LOCAL 表示直接使用Docker镜像内部的应用软件，通过Docker方式运行；DeliveryForm 为 PACKAGE，表示将远程应用包注入到Docker镜像后，通过Docker方式运行。为避免Docker不同版本的兼容性问题，Docker安装包及相关依赖由Batch统一负责，对于已安装Docker的自定义镜像，请卸载后再使用Docker特性。
注意：此字段可能返回 null，表示取不到有效值。
     * @param array $Commands 任务执行命令信息。与Command不能同时指定。
注意：此字段可能返回 null，表示取不到有效值。
     */
    function __construct()
    {

    }

    /**
     * For internal only. DO NOT USE IT.
     */
    public function deserialize($param)
    {
        if ($param === null) {
            return;
        }
        if (array_key_exists("DeliveryForm",$param) and $param["DeliveryForm"] !== null) {
            $this->DeliveryForm = $param["DeliveryForm"];
        }

        if (array_key_exists("Command",$param) and $param["Command"] !== null) {
            $this->Command = $param["Command"];
        }

        if (array_key_exists("PackagePath",$param) and $param["PackagePath"] !== null) {
            $this->PackagePath = $param["PackagePath"];
        }

        if (array_key_exists("Docker",$param) and $param["Docker"] !== null) {
            $this->Docker = new Docker();
            $this->Docker->deserialize($param["Docker"]);
        }

        if (array_key_exists("Commands",$param) and $param["Commands"] !== null) {
            $this->Commands = [];
            foreach ($param["Commands"] as $key => $value){
                $obj = new CommandLine();
                $obj->deserialize($value);
                array_push($this->Commands, $obj);
            }
        }
    }
}
