<?php
/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
namespace TencentCloud\Bda\V20200324\Models;
use TencentCloud\Common\AbstractModel;

/**
 * ModifyGroup请求参数结构体
 *
 * @method string getGroupId() 获取人体库ID。
 * @method void setGroupId(string $GroupId) 设置人体库ID。
 * @method string getGroupName() 获取人体库名称。
 * @method void setGroupName(string $GroupName) 设置人体库名称。
 * @method string getTag() 获取人体库信息备注。
 * @method void setTag(string $Tag) 设置人体库信息备注。
 */
class ModifyGroupRequest extends AbstractModel
{
    /**
     * @var string 人体库ID。
     */
    public $GroupId;

    /**
     * @var string 人体库名称。
     */
    public $GroupName;

    /**
     * @var string 人体库信息备注。
     */
    public $Tag;

    /**
     * @param string $GroupId 人体库ID。
     * @param string $GroupName 人体库名称。
     * @param string $Tag 人体库信息备注。
     */
    function __construct()
    {

    }

    /**
     * For internal only. DO NOT USE IT.
     */
    public function deserialize($param)
    {
        if ($param === null) {
            return;
        }
        if (array_key_exists("GroupId",$param) and $param["GroupId"] !== null) {
            $this->GroupId = $param["GroupId"];
        }

        if (array_key_exists("GroupName",$param) and $param["GroupName"] !== null) {
            $this->GroupName = $param["GroupName"];
        }

        if (array_key_exists("Tag",$param) and $param["Tag"] !== null) {
            $this->Tag = $param["Tag"];
        }
    }
}
