<?php
/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
namespace TencentCloud\Bsca\V20210811\Models;
use TencentCloud\Common\AbstractModel;

/**
 * 与输入组件相关的漏洞信息摘要信息。
 *
 * @method PURL getPURL() 获取用于匹配漏洞的PURL
注意：此字段可能返回 null，表示取不到有效值。
 * @method void setPURL(PURL $PURL) 设置用于匹配漏洞的PURL
注意：此字段可能返回 null，表示取不到有效值。
 * @method boolean getCanBeFixed() 获取该组件是否包含修复漏洞的官方补丁
 * @method void setCanBeFixed(boolean $CanBeFixed) 设置该组件是否包含修复漏洞的官方补丁
 * @method string getFixedVersion() 获取修复漏洞的组件版本号
 * @method void setFixedVersion(string $FixedVersion) 设置修复漏洞的组件版本号
 * @method string getAffectedVersion() 获取漏洞影响的组件版本号
 * @method void setAffectedVersion(string $AffectedVersion) 设置漏洞影响的组件版本号
 * @method string getAffectedComponent() 获取漏洞影响组件
 * @method void setAffectedComponent(string $AffectedComponent) 设置漏洞影响组件
 * @method string getRiskLevel() 获取漏洞在该产品中的风险等级
<li>Critical</li>
<li>High</li>
<li>Medium</li>
<li>Low</li>
 * @method void setRiskLevel(string $RiskLevel) 设置漏洞在该产品中的风险等级
<li>Critical</li>
<li>High</li>
<li>Medium</li>
<li>Low</li>
 */
class ComponentVulnerabilitySummary extends AbstractModel
{
    /**
     * @var PURL 用于匹配漏洞的PURL
注意：此字段可能返回 null，表示取不到有效值。
     */
    public $PURL;

    /**
     * @var boolean 该组件是否包含修复漏洞的官方补丁
     */
    public $CanBeFixed;

    /**
     * @var string 修复漏洞的组件版本号
     */
    public $FixedVersion;

    /**
     * @var string 漏洞影响的组件版本号
     */
    public $AffectedVersion;

    /**
     * @var string 漏洞影响组件
     */
    public $AffectedComponent;

    /**
     * @var string 漏洞在该产品中的风险等级
<li>Critical</li>
<li>High</li>
<li>Medium</li>
<li>Low</li>
     */
    public $RiskLevel;

    /**
     * @param PURL $PURL 用于匹配漏洞的PURL
注意：此字段可能返回 null，表示取不到有效值。
     * @param boolean $CanBeFixed 该组件是否包含修复漏洞的官方补丁
     * @param string $FixedVersion 修复漏洞的组件版本号
     * @param string $AffectedVersion 漏洞影响的组件版本号
     * @param string $AffectedComponent 漏洞影响组件
     * @param string $RiskLevel 漏洞在该产品中的风险等级
<li>Critical</li>
<li>High</li>
<li>Medium</li>
<li>Low</li>
     */
    function __construct()
    {

    }

    /**
     * For internal only. DO NOT USE IT.
     */
    public function deserialize($param)
    {
        if ($param === null) {
            return;
        }
        if (array_key_exists("PURL",$param) and $param["PURL"] !== null) {
            $this->PURL = new PURL();
            $this->PURL->deserialize($param["PURL"]);
        }

        if (array_key_exists("CanBeFixed",$param) and $param["CanBeFixed"] !== null) {
            $this->CanBeFixed = $param["CanBeFixed"];
        }

        if (array_key_exists("FixedVersion",$param) and $param["FixedVersion"] !== null) {
            $this->FixedVersion = $param["FixedVersion"];
        }

        if (array_key_exists("AffectedVersion",$param) and $param["AffectedVersion"] !== null) {
            $this->AffectedVersion = $param["AffectedVersion"];
        }

        if (array_key_exists("AffectedComponent",$param) and $param["AffectedComponent"] !== null) {
            $this->AffectedComponent = $param["AffectedComponent"];
        }

        if (array_key_exists("RiskLevel",$param) and $param["RiskLevel"] !== null) {
            $this->RiskLevel = $param["RiskLevel"];
        }
    }
}
