<?php
/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
namespace TencentCloud\Bsca\V20210811\Models;
use TencentCloud\Common\AbstractModel;

/**
 * 描述漏洞的摘要信息。
 *
 * @method string getVulID() 获取漏洞ID
 * @method void setVulID(string $VulID) 设置漏洞ID
 * @method string getCVEID() 获取漏洞所属CVE编号
 * @method void setCVEID(string $CVEID) 设置漏洞所属CVE编号
 * @method string getCNVDID() 获取漏洞所属CNVD编号
 * @method void setCNVDID(string $CNVDID) 设置漏洞所属CNVD编号
 * @method string getCNNVDID() 获取漏洞所属CNNVD编号
 * @method void setCNNVDID(string $CNNVDID) 设置漏洞所属CNNVD编号
 * @method string getName() 获取漏洞名称
 * @method void setName(string $Name) 设置漏洞名称
 * @method boolean getIsSuggest() 获取该漏洞是否是需重点关注的漏洞
 * @method void setIsSuggest(boolean $IsSuggest) 设置该漏洞是否是需重点关注的漏洞
 * @method string getSeverity() 获取漏洞风险等级
<li>Critical</li>
<li>High</li>
<li>Medium</li>
<li>Low</li>
 * @method void setSeverity(string $Severity) 设置漏洞风险等级
<li>Critical</li>
<li>High</li>
<li>Medium</li>
<li>Low</li>
 */
class VulnerabilitySummary extends AbstractModel
{
    /**
     * @var string 漏洞ID
     */
    public $VulID;

    /**
     * @var string 漏洞所属CVE编号
     */
    public $CVEID;

    /**
     * @var string 漏洞所属CNVD编号
     */
    public $CNVDID;

    /**
     * @var string 漏洞所属CNNVD编号
     */
    public $CNNVDID;

    /**
     * @var string 漏洞名称
     */
    public $Name;

    /**
     * @var boolean 该漏洞是否是需重点关注的漏洞
     */
    public $IsSuggest;

    /**
     * @var string 漏洞风险等级
<li>Critical</li>
<li>High</li>
<li>Medium</li>
<li>Low</li>
     */
    public $Severity;

    /**
     * @param string $VulID 漏洞ID
     * @param string $CVEID 漏洞所属CVE编号
     * @param string $CNVDID 漏洞所属CNVD编号
     * @param string $CNNVDID 漏洞所属CNNVD编号
     * @param string $Name 漏洞名称
     * @param boolean $IsSuggest 该漏洞是否是需重点关注的漏洞
     * @param string $Severity 漏洞风险等级
<li>Critical</li>
<li>High</li>
<li>Medium</li>
<li>Low</li>
     */
    function __construct()
    {

    }

    /**
     * For internal only. DO NOT USE IT.
     */
    public function deserialize($param)
    {
        if ($param === null) {
            return;
        }
        if (array_key_exists("VulID",$param) and $param["VulID"] !== null) {
            $this->VulID = $param["VulID"];
        }

        if (array_key_exists("CVEID",$param) and $param["CVEID"] !== null) {
            $this->CVEID = $param["CVEID"];
        }

        if (array_key_exists("CNVDID",$param) and $param["CNVDID"] !== null) {
            $this->CNVDID = $param["CNVDID"];
        }

        if (array_key_exists("CNNVDID",$param) and $param["CNNVDID"] !== null) {
            $this->CNNVDID = $param["CNNVDID"];
        }

        if (array_key_exists("Name",$param) and $param["Name"] !== null) {
            $this->Name = $param["Name"];
        }

        if (array_key_exists("IsSuggest",$param) and $param["IsSuggest"] !== null) {
            $this->IsSuggest = $param["IsSuggest"];
        }

        if (array_key_exists("Severity",$param) and $param["Severity"] !== null) {
            $this->Severity = $param["Severity"];
        }
    }
}
