<?php
/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
namespace TencentCloud\Cwp\V20180228\Models;
use TencentCloud\Common\AbstractModel;

/**
 * DeleteAttackLogs请求参数结构体
 *
 * @method array getIds() 获取日志ID数组，最大100条。
 * @method void setIds(array $Ids) 设置日志ID数组，最大100条。
 * @method boolean getIsAll() 获取是否全部删除
 * @method void setIsAll(boolean $IsAll) 设置是否全部删除
 */
class DeleteAttackLogsRequest extends AbstractModel
{
    /**
     * @var array 日志ID数组，最大100条。
     */
    public $Ids;

    /**
     * @var boolean 是否全部删除
     */
    public $IsAll;

    /**
     * @param array $Ids 日志ID数组，最大100条。
     * @param boolean $IsAll 是否全部删除
     */
    function __construct()
    {

    }

    /**
     * For internal only. DO NOT USE IT.
     */
    public function deserialize($param)
    {
        if ($param === null) {
            return;
        }
        if (array_key_exists("Ids",$param) and $param["Ids"] !== null) {
            $this->Ids = $param["Ids"];
        }

        if (array_key_exists("IsAll",$param) and $param["IsAll"] !== null) {
            $this->IsAll = $param["IsAll"];
        }
    }
}
