<?php
/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
namespace TencentCloud\Cwp\V20180228\Models;
use TencentCloud\Common\AbstractModel;

/**
 * DescribeMalwareRiskWarning返回参数结构体
 *
 * @method boolean getIsCheckRisk() 获取是否开启自动扫描：true-开启，false-未开启
 * @method void setIsCheckRisk(boolean $IsCheckRisk) 设置是否开启自动扫描：true-开启，false-未开启
 * @method array getList() 获取风险文件列表信息
注意：此字段可能返回 null，表示取不到有效值。
 * @method void setList(array $List) 设置风险文件列表信息
注意：此字段可能返回 null，表示取不到有效值。
 * @method boolean getIsPop() 获取是否弹出提示 true 弹出, false不弹
 * @method void setIsPop(boolean $IsPop) 设置是否弹出提示 true 弹出, false不弹
 * @method array getProcessList() 获取异常进程列表信息
注意：此字段可能返回 null，表示取不到有效值。
 * @method void setProcessList(array $ProcessList) 设置异常进程列表信息
注意：此字段可能返回 null，表示取不到有效值。
 * @method string getRequestId() 获取唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
 * @method void setRequestId(string $RequestId) 设置唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
 */
class DescribeMalwareRiskWarningResponse extends AbstractModel
{
    /**
     * @var boolean 是否开启自动扫描：true-开启，false-未开启
     */
    public $IsCheckRisk;

    /**
     * @var array 风险文件列表信息
注意：此字段可能返回 null，表示取不到有效值。
     */
    public $List;

    /**
     * @var boolean 是否弹出提示 true 弹出, false不弹
     */
    public $IsPop;

    /**
     * @var array 异常进程列表信息
注意：此字段可能返回 null，表示取不到有效值。
     */
    public $ProcessList;

    /**
     * @var string 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     */
    public $RequestId;

    /**
     * @param boolean $IsCheckRisk 是否开启自动扫描：true-开启，false-未开启
     * @param array $List 风险文件列表信息
注意：此字段可能返回 null，表示取不到有效值。
     * @param boolean $IsPop 是否弹出提示 true 弹出, false不弹
     * @param array $ProcessList 异常进程列表信息
注意：此字段可能返回 null，表示取不到有效值。
     * @param string $RequestId 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     */
    function __construct()
    {

    }

    /**
     * For internal only. DO NOT USE IT.
     */
    public function deserialize($param)
    {
        if ($param === null) {
            return;
        }
        if (array_key_exists("IsCheckRisk",$param) and $param["IsCheckRisk"] !== null) {
            $this->IsCheckRisk = $param["IsCheckRisk"];
        }

        if (array_key_exists("List",$param) and $param["List"] !== null) {
            $this->List = [];
            foreach ($param["List"] as $key => $value){
                $obj = new MalwareRisk();
                $obj->deserialize($value);
                array_push($this->List, $obj);
            }
        }

        if (array_key_exists("IsPop",$param) and $param["IsPop"] !== null) {
            $this->IsPop = $param["IsPop"];
        }

        if (array_key_exists("ProcessList",$param) and $param["ProcessList"] !== null) {
            $this->ProcessList = [];
            foreach ($param["ProcessList"] as $key => $value){
                $obj = new MalwareRisk();
                $obj->deserialize($value);
                array_push($this->ProcessList, $obj);
            }
        }

        if (array_key_exists("RequestId",$param) and $param["RequestId"] !== null) {
            $this->RequestId = $param["RequestId"];
        }
    }
}
