<?php
/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
namespace TencentCloud\Dsgc\V20190723\Models;
use TencentCloud\Common\AbstractModel;

/**
 * DescribeMongoAssetSensitiveDistribution返回参数结构体
 *
 * @method MongoAsset getMongoAsset() 获取mongo的资产统计数据
注意：此字段可能返回 null，表示取不到有效值。
 * @method void setMongoAsset(MongoAsset $MongoAsset) 设置mongo的资产统计数据
注意：此字段可能返回 null，表示取不到有效值。
 * @method array getTopAsset() 获取涉敏top数据
注意：此字段可能返回 null，表示取不到有效值。
 * @method void setTopAsset(array $TopAsset) 设置涉敏top数据
注意：此字段可能返回 null，表示取不到有效值。
 * @method array getMongoDetail() 获取mongo的详情列表
注意：此字段可能返回 null，表示取不到有效值。
 * @method void setMongoDetail(array $MongoDetail) 设置mongo的详情列表
注意：此字段可能返回 null，表示取不到有效值。
 * @method string getRequestId() 获取唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
 * @method void setRequestId(string $RequestId) 设置唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
 */
class DescribeMongoAssetSensitiveDistributionResponse extends AbstractModel
{
    /**
     * @var MongoAsset mongo的资产统计数据
注意：此字段可能返回 null，表示取不到有效值。
     */
    public $MongoAsset;

    /**
     * @var array 涉敏top数据
注意：此字段可能返回 null，表示取不到有效值。
     */
    public $TopAsset;

    /**
     * @var array mongo的详情列表
注意：此字段可能返回 null，表示取不到有效值。
     */
    public $MongoDetail;

    /**
     * @var string 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     */
    public $RequestId;

    /**
     * @param MongoAsset $MongoAsset mongo的资产统计数据
注意：此字段可能返回 null，表示取不到有效值。
     * @param array $TopAsset 涉敏top数据
注意：此字段可能返回 null，表示取不到有效值。
     * @param array $MongoDetail mongo的详情列表
注意：此字段可能返回 null，表示取不到有效值。
     * @param string $RequestId 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     */
    function __construct()
    {

    }

    /**
     * For internal only. DO NOT USE IT.
     */
    public function deserialize($param)
    {
        if ($param === null) {
            return;
        }
        if (array_key_exists("MongoAsset",$param) and $param["MongoAsset"] !== null) {
            $this->MongoAsset = new MongoAsset();
            $this->MongoAsset->deserialize($param["MongoAsset"]);
        }

        if (array_key_exists("TopAsset",$param) and $param["TopAsset"] !== null) {
            $this->TopAsset = [];
            foreach ($param["TopAsset"] as $key => $value){
                $obj = new TopAsset();
                $obj->deserialize($value);
                array_push($this->TopAsset, $obj);
            }
        }

        if (array_key_exists("MongoDetail",$param) and $param["MongoDetail"] !== null) {
            $this->MongoDetail = [];
            foreach ($param["MongoDetail"] as $key => $value){
                $obj = new MongoAssetDBDetail();
                $obj->deserialize($value);
                array_push($this->MongoDetail, $obj);
            }
        }

        if (array_key_exists("RequestId",$param) and $param["RequestId"] !== null) {
            $this->RequestId = $param["RequestId"];
        }
    }
}
