<?php
/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
namespace TencentCloud\Ecc\V20181213\Models;
use TencentCloud\Common\AbstractModel;

/**
 * EHOCR返回参数结构体
 *
 * @method CompostionContext getData() 获取接口返回数据
 * @method void setData(CompostionContext $Data) 设置接口返回数据
 * @method CompositionContext getResultData() 获取接口返回数据
 * @method void setResultData(CompositionContext $ResultData) 设置接口返回数据
 * @method string getRequestId() 获取唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
 * @method void setRequestId(string $RequestId) 设置唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
 */
class EHOCRResponse extends AbstractModel
{
    /**
     * @var CompostionContext 接口返回数据
     * @deprecated
     */
    public $Data;

    /**
     * @var CompositionContext 接口返回数据
     */
    public $ResultData;

    /**
     * @var string 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     */
    public $RequestId;

    /**
     * @param CompostionContext $Data 接口返回数据
     * @param CompositionContext $ResultData 接口返回数据
     * @param string $RequestId 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     */
    function __construct()
    {

    }

    /**
     * For internal only. DO NOT USE IT.
     */
    public function deserialize($param)
    {
        if ($param === null) {
            return;
        }
        if (array_key_exists("Data",$param) and $param["Data"] !== null) {
            $this->Data = new CompostionContext();
            $this->Data->deserialize($param["Data"]);
        }

        if (array_key_exists("ResultData",$param) and $param["ResultData"] !== null) {
            $this->ResultData = new CompositionContext();
            $this->ResultData->deserialize($param["ResultData"]);
        }

        if (array_key_exists("RequestId",$param) and $param["RequestId"] !== null) {
            $this->RequestId = $param["RequestId"];
        }
    }
}
