<?php
/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
namespace TencentCloud\Iss\V20230517\Models;
use TencentCloud\Common\AbstractModel;

/**
 * DescribeRecordPlaybackUrl请求参数结构体
 *
 * @method string getChannelId() 获取设备通道ID
 * @method void setChannelId(string $ChannelId) 设置设备通道ID
 * @method integer getStartTime() 获取回放开始时间，UTC秒数，例如：1662114146，开始和结束时间段最长为一天，且不能跨天
 * @method void setStartTime(integer $StartTime) 设置回放开始时间，UTC秒数，例如：1662114146，开始和结束时间段最长为一天，且不能跨天
 * @method integer getEndTime() 获取回放结束时间，UTC秒数，例如：1662114246，开始和结束时间段最长为一天，且不能跨天
 * @method void setEndTime(integer $EndTime) 设置回放结束时间，UTC秒数，例如：1662114246，开始和结束时间段最长为一天，且不能跨天
 */
class DescribeRecordPlaybackUrlRequest extends AbstractModel
{
    /**
     * @var string 设备通道ID
     */
    public $ChannelId;

    /**
     * @var integer 回放开始时间，UTC秒数，例如：1662114146，开始和结束时间段最长为一天，且不能跨天
     */
    public $StartTime;

    /**
     * @var integer 回放结束时间，UTC秒数，例如：1662114246，开始和结束时间段最长为一天，且不能跨天
     */
    public $EndTime;

    /**
     * @param string $ChannelId 设备通道ID
     * @param integer $StartTime 回放开始时间，UTC秒数，例如：1662114146，开始和结束时间段最长为一天，且不能跨天
     * @param integer $EndTime 回放结束时间，UTC秒数，例如：1662114246，开始和结束时间段最长为一天，且不能跨天
     */
    function __construct()
    {

    }

    /**
     * For internal only. DO NOT USE IT.
     */
    public function deserialize($param)
    {
        if ($param === null) {
            return;
        }
        if (array_key_exists("ChannelId",$param) and $param["ChannelId"] !== null) {
            $this->ChannelId = $param["ChannelId"];
        }

        if (array_key_exists("StartTime",$param) and $param["StartTime"] !== null) {
            $this->StartTime = $param["StartTime"];
        }

        if (array_key_exists("EndTime",$param) and $param["EndTime"] !== null) {
            $this->EndTime = $param["EndTime"];
        }
    }
}
