<?php
/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
namespace TencentCloud\Iss\V20230517\Models;
use TencentCloud\Common\AbstractModel;

/**
 * AI识别结果在画面中坐标
 *
 * @method integer getX() 获取左上角 X 坐标轴
 * @method void setX(integer $X) 设置左上角 X 坐标轴
 * @method integer getY() 获取左上角 Y 坐标轴
 * @method void setY(integer $Y) 设置左上角 Y 坐标轴
 * @method integer getWidth() 获取方框宽
 * @method void setWidth(integer $Width) 设置方框宽
 * @method integer getHeight() 获取方框高
 * @method void setHeight(integer $Height) 设置方框高
 */
class Location extends AbstractModel
{
    /**
     * @var integer 左上角 X 坐标轴
     */
    public $X;

    /**
     * @var integer 左上角 Y 坐标轴
     */
    public $Y;

    /**
     * @var integer 方框宽
     */
    public $Width;

    /**
     * @var integer 方框高
     */
    public $Height;

    /**
     * @param integer $X 左上角 X 坐标轴
     * @param integer $Y 左上角 Y 坐标轴
     * @param integer $Width 方框宽
     * @param integer $Height 方框高
     */
    function __construct()
    {

    }

    /**
     * For internal only. DO NOT USE IT.
     */
    public function deserialize($param)
    {
        if ($param === null) {
            return;
        }
        if (array_key_exists("X",$param) and $param["X"] !== null) {
            $this->X = $param["X"];
        }

        if (array_key_exists("Y",$param) and $param["Y"] !== null) {
            $this->Y = $param["Y"];
        }

        if (array_key_exists("Width",$param) and $param["Width"] !== null) {
            $this->Width = $param["Width"];
        }

        if (array_key_exists("Height",$param) and $param["Height"] !== null) {
            $this->Height = $param["Height"];
        }
    }
}
