<?php
/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
namespace TencentCloud\Postgres\V20170312\Models;
use TencentCloud\Common\AbstractModel;

/**
 * ModifySwitchTimePeriod请求参数结构体
 *
 * @method string getDBInstanceId() 获取处于等待切换状态中的实例ID
 * @method void setDBInstanceId(string $DBInstanceId) 设置处于等待切换状态中的实例ID
 * @method integer getSwitchTag() 获取入参取值为 0 ，代表立即切换。
 * @method void setSwitchTag(integer $SwitchTag) 设置入参取值为 0 ，代表立即切换。
 */
class ModifySwitchTimePeriodRequest extends AbstractModel
{
    /**
     * @var string 处于等待切换状态中的实例ID
     */
    public $DBInstanceId;

    /**
     * @var integer 入参取值为 0 ，代表立即切换。
     */
    public $SwitchTag;

    /**
     * @param string $DBInstanceId 处于等待切换状态中的实例ID
     * @param integer $SwitchTag 入参取值为 0 ，代表立即切换。
     */
    function __construct()
    {

    }

    /**
     * For internal only. DO NOT USE IT.
     */
    public function deserialize($param)
    {
        if ($param === null) {
            return;
        }
        if (array_key_exists("DBInstanceId",$param) and $param["DBInstanceId"] !== null) {
            $this->DBInstanceId = $param["DBInstanceId"];
        }

        if (array_key_exists("SwitchTag",$param) and $param["SwitchTag"] !== null) {
            $this->SwitchTag = $param["SwitchTag"];
        }
    }
}
