<?php
/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
namespace TencentCloud\Ssl\V20191205\Models;
use TencentCloud\Common\AbstractModel;

/**
 * ReplaceCertificate请求参数结构体
 *
 * @method string getCertificateId() 获取证书 ID。
 * @method void setCertificateId(string $CertificateId) 设置证书 ID。
 * @method string getValidType() 获取验证类型：DNS_AUTO = 自动DNS验证（仅支持在腾讯云解析且解析状态正常的域名使用该验证类型），DNS = 手动DNS验证，FILE = 文件验证。
 * @method void setValidType(string $ValidType) 设置验证类型：DNS_AUTO = 自动DNS验证（仅支持在腾讯云解析且解析状态正常的域名使用该验证类型），DNS = 手动DNS验证，FILE = 文件验证。
 * @method string getCsrType() 获取类型，默认 Original。可选项：Original = 原证书 CSR，Upload = 手动上传，Online = 在线生成。
 * @method void setCsrType(string $CsrType) 设置类型，默认 Original。可选项：Original = 原证书 CSR，Upload = 手动上传，Online = 在线生成。
 * @method string getCsrContent() 获取CSR 内容。
 * @method void setCsrContent(string $CsrContent) 设置CSR 内容。
 * @method string getCsrkeyPassword() 获取KEY 密码。
 * @method void setCsrkeyPassword(string $CsrkeyPassword) 设置KEY 密码。
 * @method string getReason() 获取重颁发原因。
 * @method void setReason(string $Reason) 设置重颁发原因。
 * @method string getCertCSREncryptAlgo() 获取CSR加密方式，可选：RSA、ECC、SM2
（CsrType为Online才可选）， 默认为RSA
 * @method void setCertCSREncryptAlgo(string $CertCSREncryptAlgo) 设置CSR加密方式，可选：RSA、ECC、SM2
（CsrType为Online才可选）， 默认为RSA
 * @method string getCertCSRKeyParameter() 获取CSR加密参数，CsrEncryptAlgo为RSA时， 可选2048、4096等默认为2048；CsrEncryptAlgo为ECC时，可选prime256v1，secp384r1等，默认为prime256v1; 
 * @method void setCertCSRKeyParameter(string $CertCSRKeyParameter) 设置CSR加密参数，CsrEncryptAlgo为RSA时， 可选2048、4096等默认为2048；CsrEncryptAlgo为ECC时，可选prime256v1，secp384r1等，默认为prime256v1; 
 */
class ReplaceCertificateRequest extends AbstractModel
{
    /**
     * @var string 证书 ID。
     */
    public $CertificateId;

    /**
     * @var string 验证类型：DNS_AUTO = 自动DNS验证（仅支持在腾讯云解析且解析状态正常的域名使用该验证类型），DNS = 手动DNS验证，FILE = 文件验证。
     */
    public $ValidType;

    /**
     * @var string 类型，默认 Original。可选项：Original = 原证书 CSR，Upload = 手动上传，Online = 在线生成。
     */
    public $CsrType;

    /**
     * @var string CSR 内容。
     */
    public $CsrContent;

    /**
     * @var string KEY 密码。
     */
    public $CsrkeyPassword;

    /**
     * @var string 重颁发原因。
     */
    public $Reason;

    /**
     * @var string CSR加密方式，可选：RSA、ECC、SM2
（CsrType为Online才可选）， 默认为RSA
     */
    public $CertCSREncryptAlgo;

    /**
     * @var string CSR加密参数，CsrEncryptAlgo为RSA时， 可选2048、4096等默认为2048；CsrEncryptAlgo为ECC时，可选prime256v1，secp384r1等，默认为prime256v1; 
     */
    public $CertCSRKeyParameter;

    /**
     * @param string $CertificateId 证书 ID。
     * @param string $ValidType 验证类型：DNS_AUTO = 自动DNS验证（仅支持在腾讯云解析且解析状态正常的域名使用该验证类型），DNS = 手动DNS验证，FILE = 文件验证。
     * @param string $CsrType 类型，默认 Original。可选项：Original = 原证书 CSR，Upload = 手动上传，Online = 在线生成。
     * @param string $CsrContent CSR 内容。
     * @param string $CsrkeyPassword KEY 密码。
     * @param string $Reason 重颁发原因。
     * @param string $CertCSREncryptAlgo CSR加密方式，可选：RSA、ECC、SM2
（CsrType为Online才可选）， 默认为RSA
     * @param string $CertCSRKeyParameter CSR加密参数，CsrEncryptAlgo为RSA时， 可选2048、4096等默认为2048；CsrEncryptAlgo为ECC时，可选prime256v1，secp384r1等，默认为prime256v1; 
     */
    function __construct()
    {

    }

    /**
     * For internal only. DO NOT USE IT.
     */
    public function deserialize($param)
    {
        if ($param === null) {
            return;
        }
        if (array_key_exists("CertificateId",$param) and $param["CertificateId"] !== null) {
            $this->CertificateId = $param["CertificateId"];
        }

        if (array_key_exists("ValidType",$param) and $param["ValidType"] !== null) {
            $this->ValidType = $param["ValidType"];
        }

        if (array_key_exists("CsrType",$param) and $param["CsrType"] !== null) {
            $this->CsrType = $param["CsrType"];
        }

        if (array_key_exists("CsrContent",$param) and $param["CsrContent"] !== null) {
            $this->CsrContent = $param["CsrContent"];
        }

        if (array_key_exists("CsrkeyPassword",$param) and $param["CsrkeyPassword"] !== null) {
            $this->CsrkeyPassword = $param["CsrkeyPassword"];
        }

        if (array_key_exists("Reason",$param) and $param["Reason"] !== null) {
            $this->Reason = $param["Reason"];
        }

        if (array_key_exists("CertCSREncryptAlgo",$param) and $param["CertCSREncryptAlgo"] !== null) {
            $this->CertCSREncryptAlgo = $param["CertCSREncryptAlgo"];
        }

        if (array_key_exists("CertCSRKeyParameter",$param) and $param["CertCSRKeyParameter"] !== null) {
            $this->CertCSRKeyParameter = $param["CertCSRKeyParameter"];
        }
    }
}
