<?php
/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
namespace TencentCloud\Tcss\V20201101\Models;
use TencentCloud\Common\AbstractModel;

/**
 * UpdateNetworkFirewallPolicyYamlDetail请求参数结构体
 *
 * @method string getClusterId() 获取集群Id
 * @method void setClusterId(string $ClusterId) 设置集群Id
 * @method integer getId() 获取策略id
 * @method void setId(integer $Id) 设置策略id
 * @method string getYaml() 获取base64编码的networkpolicy yaml字符串
 * @method void setYaml(string $Yaml) 设置base64编码的networkpolicy yaml字符串
 * @method string getDescription() 获取策略描述
 * @method void setDescription(string $Description) 设置策略描述
 */
class UpdateNetworkFirewallPolicyYamlDetailRequest extends AbstractModel
{
    /**
     * @var string 集群Id
     */
    public $ClusterId;

    /**
     * @var integer 策略id
     */
    public $Id;

    /**
     * @var string base64编码的networkpolicy yaml字符串
     */
    public $Yaml;

    /**
     * @var string 策略描述
     */
    public $Description;

    /**
     * @param string $ClusterId 集群Id
     * @param integer $Id 策略id
     * @param string $Yaml base64编码的networkpolicy yaml字符串
     * @param string $Description 策略描述
     */
    function __construct()
    {

    }

    /**
     * For internal only. DO NOT USE IT.
     */
    public function deserialize($param)
    {
        if ($param === null) {
            return;
        }
        if (array_key_exists("ClusterId",$param) and $param["ClusterId"] !== null) {
            $this->ClusterId = $param["ClusterId"];
        }

        if (array_key_exists("Id",$param) and $param["Id"] !== null) {
            $this->Id = $param["Id"];
        }

        if (array_key_exists("Yaml",$param) and $param["Yaml"] !== null) {
            $this->Yaml = $param["Yaml"];
        }

        if (array_key_exists("Description",$param) and $param["Description"] !== null) {
            $this->Description = $param["Description"];
        }
    }
}
