<?php
/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
namespace TencentCloud\Tdmq\V20200217\Models;
use TencentCloud\Common\AbstractModel;

/**
 * DescribeRabbitMQUser返回参数结构体
 *
 * @method integer getTotalCount() 获取返回的User数量
 * @method void setTotalCount(integer $TotalCount) 设置返回的User数量
 * @method array getRabbitMQUserList() 获取当前已创建的RabbitMQ用户列表
 * @method void setRabbitMQUserList(array $RabbitMQUserList) 设置当前已创建的RabbitMQ用户列表
 * @method string getRequestId() 获取唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
 * @method void setRequestId(string $RequestId) 设置唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
 */
class DescribeRabbitMQUserResponse extends AbstractModel
{
    /**
     * @var integer 返回的User数量
     */
    public $TotalCount;

    /**
     * @var array 当前已创建的RabbitMQ用户列表
     */
    public $RabbitMQUserList;

    /**
     * @var string 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     */
    public $RequestId;

    /**
     * @param integer $TotalCount 返回的User数量
     * @param array $RabbitMQUserList 当前已创建的RabbitMQ用户列表
     * @param string $RequestId 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     */
    function __construct()
    {

    }

    /**
     * For internal only. DO NOT USE IT.
     */
    public function deserialize($param)
    {
        if ($param === null) {
            return;
        }
        if (array_key_exists("TotalCount",$param) and $param["TotalCount"] !== null) {
            $this->TotalCount = $param["TotalCount"];
        }

        if (array_key_exists("RabbitMQUserList",$param) and $param["RabbitMQUserList"] !== null) {
            $this->RabbitMQUserList = [];
            foreach ($param["RabbitMQUserList"] as $key => $value){
                $obj = new RabbitMQUser();
                $obj->deserialize($value);
                array_push($this->RabbitMQUserList, $obj);
            }
        }

        if (array_key_exists("RequestId",$param) and $param["RequestId"] !== null) {
            $this->RequestId = $param["RequestId"];
        }
    }
}
