<?php
/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
namespace TencentCloud\Wedata\V20210820\Models;
use TencentCloud\Common\AbstractModel;

/**
 * 分页查询实例响应
 *
 * @method array getBaselineInstances() 获取基线实例数组
注意：此字段可能返回 null，表示取不到有效值。
 * @method void setBaselineInstances(array $BaselineInstances) 设置基线实例数组
注意：此字段可能返回 null，表示取不到有效值。
 * @method integer getTotalCount() 获取总数量
注意：此字段可能返回 null，表示取不到有效值。
 * @method void setTotalCount(integer $TotalCount) 设置总数量
注意：此字段可能返回 null，表示取不到有效值。
 */
class DescribeBaselineInstancesResponse extends AbstractModel
{
    /**
     * @var array 基线实例数组
注意：此字段可能返回 null，表示取不到有效值。
     */
    public $BaselineInstances;

    /**
     * @var integer 总数量
注意：此字段可能返回 null，表示取不到有效值。
     */
    public $TotalCount;

    /**
     * @param array $BaselineInstances 基线实例数组
注意：此字段可能返回 null，表示取不到有效值。
     * @param integer $TotalCount 总数量
注意：此字段可能返回 null，表示取不到有效值。
     */
    function __construct()
    {

    }

    /**
     * For internal only. DO NOT USE IT.
     */
    public function deserialize($param)
    {
        if ($param === null) {
            return;
        }
        if (array_key_exists("BaselineInstances",$param) and $param["BaselineInstances"] !== null) {
            $this->BaselineInstances = [];
            foreach ($param["BaselineInstances"] as $key => $value){
                $obj = new BaselineInstanceVo();
                $obj->deserialize($value);
                array_push($this->BaselineInstances, $obj);
            }
        }

        if (array_key_exists("TotalCount",$param) and $param["TotalCount"] !== null) {
            $this->TotalCount = $param["TotalCount"];
        }
    }
}
