<?php
namespace app\common\util;

use app\service\SessionService;
use app\service\TrackLogService;
use think\facade\Request;
use think\Session;

class ApiResponse
{
    public static function success($data = null, $msg = '操作成功', $code = 200)
    {
        $return = [
            'code' => $code,
            'msg' => $msg,
            'data' => $data,
            'time' => time(),
        ];
        $extra = [];
        $extra['cid'] = \think\facade\Session::get(SessionService::SESSION_KEY_MEMBER_LOGIN) ?? '';
        $extra['request'] = $_REQUEST;
        $extra['header'] = Request::header() ?? [];
        $extra['param'] = Request::param() ?? [];
        $logContent = json_encode([$return, $extra], JSON_UNESCAPED_UNICODE);
        // 获取接口请求地址
        $logApi = $_SERVER['REQUEST_URI'];
        (new TrackLogService())->insertLog('api-success', $logContent, $logApi);
        return json($return);
    }

    public static function error($msg = '操作失败', $code = 400, $data = null)
    {
        if ($msg != '操作失败' && $code != 303) {
            $data = $msg;
            $msg = '操作失败';
        }
        $return = [
            'code' => $code,
            'msg' => $msg,
            'data' => $data,
            'time' => time(),
        ];
        $extra = [];
        $extra['cid'] = \think\facade\Session::get(SessionService::SESSION_KEY_MEMBER_LOGIN) ?? '';
        $extra['request'] = $_REQUEST;
        $extra['header'] = Request::header() ?? [];
        $extra['param'] = Request::param() ?? [];
        $logContent = json_encode([$return, $extra], JSON_UNESCAPED_UNICODE);
        // 获取接口请求地址
        $logApi = $_SERVER['REQUEST_URI'];
        (new TrackLogService())->insertLog('api-error', $logContent, $logApi);
        return json($return);
    }
}