<?php
namespace app\common\util;

class CommonUtils
{
    public static function getByAdOrderNo($platform)
    {
        $prefix = 'AD' . '' . str_pad($platform, 2, '0', STR_PAD_LEFT);
        return self::generateOrderNo($prefix);
    }
    
    public static function generateOrderNo($prefix = '')
    {
        $uniqueId = $prefix . uniqid(mt_rand(1000, 9999), true);
        return str_replace(['.', '/'], '', $uniqueId);
        
        /*$time = explode(' ', microtime());
        $timestamp = date('ymdHis', $time[1]);
        $milliseconds = substr($time[0] * 1000, 0, 3);
        $random = mt_rand(100, 999); // 3位随机数
        return $prefix . $timestamp . $milliseconds . $random;*/
    }

    public static function doBcdiv($coin, $rate)
    {
        $highPrecision = bcdiv((string)$coin, (string)$rate, 4);
        return round((float)$highPrecision, 2);
    }
    
    public static function getVrQrcode($sn, $shop_id, $mem_id)
    {
        if ($sn == 'sn99vip666') {
            if ($shop_id == 6 || $shop_id == 7) {
                $qrcode_code = 'sn0' . $shop_id . date('md') . $mem_id;
            } else {
                $qrcode_code = '';
            }
        } else {
            $qrcode_code = $sn;
        }
        return $qrcode_code;
    }
    
    public static function isVrQrcode($sn, $shop_id, $mem_id)
    {
        if ($sn && ($shop_id == 6 || $shop_id == 7) && $mem_id) {
            $px = substr($sn, 0, 4) == 'sn0' . $shop_id;
            $mem = substr($sn, 8) == $mem_id;
            if ($px && $mem) {
                return true;
            }
        }
        return false;
    }
}