<?php
namespace app\common\util;

use think\facade\Config;

class MetaUtils
{
    public static function coin_day_qrcode_count($platform, $shop_id = 0)
    {
        if ($platform == PlatformUtils::APP) {
            $res = Config::get('coin.app_ad.day_qrcode_count');
        } elseif ($platform == PlatformUtils::DYMP) {
            if ($shop_id) {
                $num = Config::get('coin.dy_ad.custom_shop.' . $shop_id . '.day_qrcode_count');
                if (!is_null($num)) {
                    return $num;
                }
            }
            $res = Config::get('coin.dy_ad.day_qrcode_count');
        } else {
            $res = 0;
        }
        return $res ?: 0;
    }
    
    public static function coin_day_scan_count($platform, $shop_id = 0)
    {
        if ($platform == PlatformUtils::APP) {
            $res = Config::get('coin.app_ad.day_scan_count');
        } elseif ($platform == PlatformUtils::DYMP) {
            if ($shop_id) {
                $num = Config::get('coin.dy_ad.custom_shop.' . $shop_id . '.day_scan_count');
                if (!is_null($num)) {
                    return $num;
                }
            }
            $res = Config::get('coin.dy_ad.day_scan_count');
        } else {
            $res = 0;
        }
        return $res ?: 0;
    }

    /**
     * 会员今日最大获取次数
     * @param $platform
     * @return int
     * @author guanwb<124908292@qq.com>
     */
    public static function coin_day_scan_total($platform, $shop_id = 0)
    {
        if ($platform == PlatformUtils::APP) {
            $res = Config::get('coin.app_ad.day_scan_total');
        } elseif ($platform == PlatformUtils::DYMP) {
            if ($shop_id) {
                $num = Config::get('coin.dy_ad.custom_shop.' . $shop_id . '.day_scan_total');;
                if (!is_null($num)) {
                    $is_share = self::coin_is_share($platform, $shop_id);
                    if ($is_share) {
                        $num += Config::get('coin.dy_ad.custom_shop.' . $shop_id . '.day_normal_count') ?? 0;
                    }
                    return $num;
                }
            }
            $res = Config::get('coin.dy_ad.day_scan_total');
        } else {
            $res = 0;
        }
        return $res ?: 0;
    }
    
    public static function coin_day_normal_count($platform, $shop_id = 0)
    {
        if ($platform == PlatformUtils::APP) {
            $res = Config::get('coin.app_ad.day_normal_count');
        } elseif ($platform == PlatformUtils::DYMP) {
            // 处理特殊叠加
            if ($shop_id) {
                $num = Config::get('coin.dy_ad.custom_shop.' . $shop_id . '.day_normal_count');
                if (!is_null($num)) {
                    $is_share = self::coin_is_share($platform, $shop_id);
                    if ($is_share) {
                        $num += Config::get('coin.dy_ad.custom_shop.' . $shop_id . '.day_scan_total') ?? 0;
                    }
                    return $num;
                }
            }
            $res = Config::get('coin.dy_ad.day_normal_count');
        } else {
            $res = 0;
        }
        return $res ?: 0;
    }
    
    public static function coin_coin_change_point($platform, $shop_id = 0)
    {
        if ($platform == PlatformUtils::APP) {
            $res = Config::get('coin.coin_change_point');
        } elseif ($platform == PlatformUtils::DYMP) {
            $res = Config::get('coin.coin_change_point');
        } else {
            $res = 0;
        }
        return $res ?: 0;
    }
    
    public static function coin_is_share($platform, $shop_id = 0)
    {
        if ($platform == PlatformUtils::APP) {
            $res = Config::get('coin.app_ad.is_share');
        } elseif ($platform == PlatformUtils::DYMP) {
            if ($shop_id) {
                $num = Config::get('coin.dy_ad.custom_shop.' . $shop_id . '.is_share');
                if (!is_null($num)) {
                    return $num;
                }
            }
            $res = Config::get('coin.dy_ad.is_share');
        } else {
            $res = 0;
        }
        return $res ?: 0;
    }
}