<?php
namespace app\common\util;

use app\Request;

class PlatformUtils
{
    protected $request;
    public function __construct(Request $request)
    {
        $this->request = $request;
    }
    
    public const APP = 1;
    public const WX = 2;
    public const WXMP = 3;
    public const DYMP = 4;
    
    //app wx微信公众号 wxmp微信小程序 dymp抖音小程序
    public const NameArr = [
        'app' => self::APP,
        'wx' => self::WX,
        'wxmp' => self::WXMP,
        'dymp' => self::DYMP,
    ];

    public function getPlatform()
    {
        $platform = $this->request->header('X-Client-Platform', '');
        return self::NameArr[$platform] ?? 0;
    }
    
    public function isCanViewAd()
    {
        return $this->getPlatform() == self::APP || $this->getPlatform() == self::DYMP;
    }
}