<?php
namespace app\common\util;

class RequestUtils
{
    public function curlData($url, $data = [], $method = 'POST', $type = 'form-data',$access_token='')
    {
        //初始化
        $ch = curl_init();
        $headers = [
            'form-data' => ['Content-Type: multipart/form-data'], 'json' => ['Content-Type: application/json'],
        ];
        //统一转化为大写
        $method = strtoupper($method);
        if ($method == 'GET') {
            if ($data) {
                $querystring = http_build_query($data);
                $url = $url . '?' . $querystring;
            }
        }
        // 请求头，可以传数组
        curl_setopt($ch, CURLOPT_URL, $url);
        if($access_token){
            curl_setopt($ch, CURLOPT_HTTPHEADER, [
                'content-type: application/json',
                'access-token: '.$access_token,
            ]);
        }else{
            curl_setopt($ch, CURLOPT_HTTPHEADER, [
                'content-type: application/json'
            ]);
        }
        curl_setopt($ch, CURLOPT_HEADER, false);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
        curl_setopt($ch, CURLOPT_TIMEOUT, 10);           //最大相应超时时间
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); // 跳过证书检查
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false); // 不从证书中检查SSL加密算法是否存在
        curl_setopt ($ch,CURLOPT_FOLLOWLOCATION, false);

        $output = curl_exec($ch);
        curl_close($ch);
        return $output;
    }
}