<?php
namespace app\common\wechat;
require_once '../vendor/autoload.php';
/**
 * 微信小程序用户管理类
 * Class WxUser
 * @author 王壮丽 276369046@qq.com
 */
class WxUser
{
    private $appId;
    private $appSecret;

    private $error;

    /**
     * 构造方法
     * WxUser constructor.
     * @param $appId
     * @param $appSecret
     */
    public function __construct($appId, $appSecret)
    {
        $this->appId = $appId;
        $this->appSecret = $appSecret;
    }

    /**
     * 获取session_key
     * @param $code
     * @return array|mixed
     */
    public function sessionKey($code)
    {
        /**
         * code 换取 session_key
         * ​这是一个 HTTPS 接口，开发者服务器使用登录凭证 code 获取 session_key 和 openid。
         * 其中 session_key 是对用户数据进行加密签名的密钥。为了自身应用安全，session_key 不应该在网络上传输。
         */
        // $url = 'https://api.weixin.qq.com/sns/jscode2session';
        // $result = json_decode(curl($url, array(
        //     'appid' => $this->appId,
        //     'secret' => $this->appSecret,
        //     'grant_type' => 'authorization_code',
        //     'js_code' => $code
        // )), true);
        // if (isset($result['errcode'])) {
        //     $this->error = $result['errmsg'];
        //     return false;
        // }
        // return $result;

        $url = 'https://api.weixin.qq.com/sns/jscode2session';
		$params = 		array(
			'appid' => $this->appId,
			'secret' => $this->appSecret,
			'grant_type' => 'authorization_code',
			'js_code' => $code);
		$url .= '?' . http_build_query($params); // 将参数拼接到 URL 中
		// 初始化 CURL
		$ch = curl_init();
		// 设置 CURL 选项
		curl_setopt($ch, CURLOPT_URL, $url);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		// 执行 CURL 请求
		$response = curl_exec($ch);
        curl_close($ch);
        if (isset($result['errcode'])) {
            $this->error = $response['errmsg'];
            return false;
        }
        return $response;
    }

    public function getError()
    {
        return $this->error;
    }

}