<?php
namespace app\controller;

use app\BaseController;
use think\facade\Db;

require_once '../vendor/autoload.php';
// // 导入对应产品模块的client
use TencentCloud\Sms\V20210111\SmsClient;
// 导入要请求接口对应的Request类
use TencentCloud\Sms\V20210111\Models\SendSmsRequest;
use TencentCloud\Common\Exception\TencentCloudSDKException;
use TencentCloud\Common\Credential;
// 导入可选配置类
use TencentCloud\Common\Profile\ClientProfile;
use TencentCloud\Common\Profile\HttpProfile;

//验证类
use app\validate\UserValidate;
use think\exception\ValidateException;
use app\controller\WxUser;
use app\common\wechat\WXBizDataCrypt;
use think\facade\Config;


//接口返回
use app\common\util\ApiResponse;

class Address extends BaseController{

    public function list(){
        $token = $_REQUEST['token'];
        $wxopenid = Db::table('msm_wxopenid')
            ->where('token', $token)
            ->where('tokentime','>', time())
            ->find();
        $address = Db::table('msm_member_address')
        ->where('mem_id', $wxopenid['mem_id'])
        ->select();
        return ApiResponse::success($address, 'success', 200);
    }

    public function add(){

        $token = $_REQUEST['token'];
        $wxopenid = Db::table('msm_wxopenid')
            ->where('token', $token)
            ->where('tokentime','>', time())
            ->find();
        $area = $_REQUEST['area']; //地区
        $info = $_REQUEST['info']; //详细
        $default = $_REQUEST['default']; //是否默认
        $mem = $_REQUEST['mem']; //联系人
        $hand = $_REQUEST['hand']; //联系电话

        $area_arr = explode(' ', $area);
        //省
        $province_name = $area_arr[0];
        $city_name = $area_arr[1];
        $region_name = $area_arr[2];
        $street_name = '暂不选';

        $data['mem_id'] = $wxopenid ['mem_id'];
        $data['province_name'] = $province_name;
        $data['city_name'] = $city_name;
        $data['region_name'] = $region_name;
        $data['street_name'] = $street_name;
        $data['address_info'] = $info;
        $data['address_type'] = 'home';
        $data['address_default'] = $default;
        $data['address_mem'] = $mem;
        $data['address_hand'] = $hand;

        $address = Db::table('msm_member_address')
            ->where('mem_id', $wxopenid['mem_id'])
            ->order('address_line', 'desc')
            ->find();
        if($address){
            $data['address_line'] = $address['address_line'] + 1;
        }else{
            $data['address_line']= 0;
        }

        if($default == "Y"){
            Db::table('msm_member_address')->where('mem_id', $wxopenid['mem_id'])->update(array("address_default"=>"N"));
        }
        Db::table('msm_member_address')->insert($data);
        return ApiResponse::success(null, 'success', 200);
    }


    public function update(){
        $address_line = $_REQUEST['address_line'];
        $token = $_REQUEST['token'];
        $wxopenid = Db::table('msm_wxopenid')
            ->where('token', $token)
            ->where('tokentime','>', time())
            ->find();
        $area = $_REQUEST['area']; //地区
        $info = $_REQUEST['info']; //详细
        $default = $_REQUEST['default']; //是否默认
        $mem = $_REQUEST['mem']; //联系人
        $hand = $_REQUEST['hand']; //联系电话

        $area_arr = explode(' ', $area);
        //省
        $province_name = $area_arr[0];
        $city_name = $area_arr[1];
        $region_name = $area_arr[2];
        $street_name = '暂不选';

        $data['mem_id'] = $wxopenid ['mem_id'];
        $data['province_name'] = $province_name;
        $data['city_name'] = $city_name;
        $data['region_name'] = $region_name;
        $data['street_name'] = $street_name;
        $data['address_info'] = $info;
        $data['address_type'] = 'home';
        $data['address_default'] = $default;
        $data['address_mem'] = $mem;
        $data['address_hand'] = $hand;


        if($default == "Y"){
            Db::table('msm_member_address')
            ->where('mem_id', $wxopenid['mem_id'])
            ->update(array("address_default"=>"N"));
        }
        Db::table('msm_member_address')            
        ->where('address_line', $address_line)
        ->where('mem_id', $wxopenid['mem_id'])->update($data);
        return ApiResponse::success(null, 'success', 200);
    }





    public function delete(){
        $address_line = $_REQUEST['address_line'];
        $token = $_REQUEST['token'];
        $wxopenid = Db::table('msm_wxopenid')
            ->where('token', $token)
            ->where('tokentime','>', time())
            ->find();
   
        Db::table('msm_member_address')            
        ->where('address_line', $address_line)
        ->where('mem_id', $wxopenid['mem_id'])->delete();
        return ApiResponse::success(null, 'success', 200);
    }


    public function info(){
        $address_line = $_REQUEST['address_line'];
        $token = $_REQUEST['token'];
        $wxopenid = Db::table('msm_wxopenid')
            ->where('token', $token)
            ->where('tokentime','>', time())
            ->find();

        $address = Db::table('msm_member_address')
        ->where('mem_id', $wxopenid['mem_id'])
        ->where('address_line', $address_line)
        ->find();
       
        return ApiResponse::success($address, 'success', 200);
    }

  
}
