<?php
namespace app\controller;

use app\BaseController;
use think\facade\Db;

require_once '../vendor/autoload.php';
// // 导入对应产品模块的client
use TencentCloud\Sms\V20210111\SmsClient;
// 导入要请求接口对应的Request类
use TencentCloud\Sms\V20210111\Models\SendSmsRequest;
use TencentCloud\Common\Exception\TencentCloudSDKException;
use TencentCloud\Common\Credential;
// 导入可选配置类
use TencentCloud\Common\Profile\ClientProfile;
use TencentCloud\Common\Profile\HttpProfile;

use think\Request;

//接口返回
use app\common\util\ApiResponse;


class Api extends BaseController{
	//测试接口
	public function getTest(){
		return ApiResponse::success("测试成功", '测试成功', 0);
	}
	//测试接口
	public function getTestDb(){
		$shop = Db::table('msm_shop')
        ->where('shop_code', 'S00000006')
        ->find();

		return ApiResponse::success($shop['shop_name'], '测试成功', 0);
	}

	//抽奖设置
	public function getRaffle(Request $request){
		
		$param = request()->param();
		$scanCode = $param['scan_code'];
		
		//$fp=fopen('00000000000000000000.txt','a');
		//fwrite($fp,var_export($param,true)."\r\n");
		//fclose($fp);
		
		//var_dump($scanCode);
		//判断当前二维码是否存在
		
		$raffle = Db::table('msm_raffle')
        ->where('raffle_code', $scanCode)
        ->find();
		if($raffle){
			//判断二维码的状态
			$query = Db::table('msm_raffle_prize')
			->field('prize_id, prize_code, prize_name,prize_value,prize_state,prize_memo')
			->where('prize_state', 1);
			$prize = $query->select();
			$prizeList=array();
			foreach($prize as $fkey => $fval){
			   $prizeList[$fkey]['name']	= $fval['prize_name'];
			   $prizeList[$fkey]['value']	= $fval['prize_value'];
			   $prizeList[$fkey]['id']		= $fval['prize_id'];
			   $prizeList[$fkey]['image']	= '/static/raffle/thb.png';
			}
			
			return ApiResponse::success($prizeList, 'success', 200);
		}else{
			return ApiResponse::error("二维不存在", 'success', 200);
		}
	}
    
	//抖音小程序登录
    public function login(){
		//传递两个参数
		$param = request()->param();
		$AppID = $param['AppID'];
		$code = $param['code'];
		
		if(!$AppID){
			return ApiResponse::error('操作失败', 401, 'AppID不能为空!');
		}
		if(!$code){
			return ApiResponse::error('操作失败', 401, 'code不能为空!');
		}

		$shop = Db::table('msm_shop')
        ->where('shop_dyappid', $AppID)
        ->find();
		if($shop){
			$url = "https://developer.toutiao.com/api/apps/v2/jscode2session";
			$data = array(
				'appid' => $AppID,
				'secret' => $shop['shop_dyappsecret'],
				'code' => $code,
				//'anonymous_code' => $secret,
			);
			$method = "POST";
			$type = "json";
			$codeArr = $this->curl_data($url,json_encode($data),$method,$type);
			$codeArr = json_decode($codeArr, true);
			
			/*$codeArr = array(
				'err_no' => 0,
				'err_tips' => 'success',
				'log_id' => '2024102117013250E8ABC6F2D070B681DC',
				'data' => array(
					'session_key' => "hZy6t19VPjFqm********",
					'openid'	  => "V3WvSshYq9******",
					'anonymous_openid'	  => "",
					'unionid'	  => "f7510d9ab***********",
				)
			);*/
			
			if($codeArr['err_no']==0){
				$arr = $codeArr['data'];
				$session_key = $arr['session_key'];
				$openid = $arr['openid'];
				$anonymous_openid = $arr['anonymous_openid'];
				$unionid = $arr['unionid'];
				
				//判断当前openid用户是否已经注册，没有注册则新注册  msm_member_collect
				$collect = Db::table('msm_member_collect')
				->where('mem_wxid', $openid)
				->where('mem_unionId', $unionid)
				//->where('mem_shop', $shop['shop_id'])
				->find();

				if($collect){
					$mem = Db::table('msm_member')
					->where('mem_id', $collect['mem_id'])
					//->where('mem_shop', $shop['shop_id'])
					->find();
					if($mem){
						$memArr = array(
							'unionid' => $unionid,
							'openid' => $openid,
							'mem_name' => $mem['mem_name'],
							'wx_account' => $mem['mem_hand']
						);
						return ApiResponse::success($memArr, '登录成功', 0);
					}else{
						//用户信息异常
						return ApiResponse::error('操作失败', 404, '用户信息异常[collect]!');
					}
					//public static function success($data = null, $msg = '操作成功', $code = 200)
					//return ApiResponse::success("传递两个参数", 'success', 200);
				}else{
					//注册新用户
					$memArr = array(
						'mem_name'		=> "抖音".$openid,//昵称
						//'mem_image'	=> $userinfo['headimgurl'],//头像
						'mem_unionId'	=> $unionid,
						//'mem_sex'		=>'M',
						'mem_pwd'		=> MD5(""),
						'mem_addtime'	=>date('Y-m-d H:i:s'),
						'mem_parent'	=> 0,//介绍人
						//'mem_invitecode'=> $mem_invitecode,//推广码
						'mem_from'		=> 'DY',//会员来源
						'mem_level'		=> 0,//分销级别，进来默认V1级别
                        'mem_comp'		=> $shop['comp_id'],
                        'mem_last'		=>date('Y-m-d H:i:s'),
                        //'mem_hand'	=>$mem_hand,
                        'mem_wxid'		=>$openid,
                        'mem_shop'		=>$shop['shop_id']
                    );
                    $mem_id = Db::table('msm_member')->insertGetId($memArr);
					if($mem_id){
						$collectArr = array(
							'mem_id'		=> $mem_id,//会员id
							'shop_id'		=> $shop['shop_id'],//关注的店铺
							'collect_time'	=> date('Y-m-d H:i:s'),//关注时间
							'mem_last'		=> date('Y-m-d H:i:s'),//最后更新时间
							'collect_status'=>'N',//关注状态,绑定微信时候使用
							'comp_id'	=>$shop['shop_id'],
							'mem_station'	=>'A',//A用户
							'mem_wxid'		=>$openid,//用户抖音ID
							'mem_unionId'	=> $unionid
						);
						$inser_id = Db::table('msm_member_collect')->insertGetId($collectArr);
						//入库成功
						if($inser_id){
							$memArr = array(
								'unionid' => $unionid,
								'openid' => $openid,
								'mem_name' => $memArr['mem_name'],
								'wx_account' => ''
							);
							return ApiResponse::success($memArr, '登录成功', 0);
						}else{
							return ApiResponse::error('操作失败', 404, '新增失败[collect]!');
						}
					}else{
						return ApiResponse::error('操作失败', 404, '新增失败[mem]!');
					}
				}

			}else{
				return ApiResponse::error('操作失败', 401, 'AppID['.$AppID.']不存在!');
			}
		}else{
			//public static function error($msg = '操作失败', $code = 400, $data = null)
			return ApiResponse::error('操作失败', 401, 'AppID['.$AppID.']不存在!');
		}
    }

    //绑定手机号
    public function bindwx(){
        $param = request()->param();
		if (!isset($param['appid'])) {
			return ApiResponse::error('操作失败', 401, 'appid参数不存在!');
		}
		if (!isset($param['unionid'])) {
			return ApiResponse::error('操作失败', 401, 'unionid参数不存在!');
		}
		if (!isset($param['openid'])) {
			return ApiResponse::error('操作失败', 401, 'openid参数不存在!');
		}
		if (!isset($param['wx'])) {
			return ApiResponse::error('操作失败', 401, 'wx参数不存在!');
		}
		$appid = $param['appid'];
		$unionid = $param['unionid'];
		$openid = $param['openid'];
		$phone = $param['wx'];//用户输入的手机号
		if(!$appid){
			return ApiResponse::error('操作失败', 401, 'appid不能为空!');
		}
		if(!$unionid){
			return ApiResponse::error('操作失败', 401, 'unionid不能为空!');
		}
		if(!$openid){
			return ApiResponse::error('操作失败', 401, 'openid不能为空!');
		}
		if(!$phone){
			return ApiResponse::error('操作失败', 401, '手机不能为空!');
		}

		//根据openid获取用户信息，判断手机是否绑定
		$shop = Db::table('msm_shop')
        ->where('shop_dyappid', $appid)
        ->find();
		if($shop){
			//判断当前openid用户是否已经注册，没有注册则新注册  msm_member_collect
			$collect = Db::table('msm_member_collect')
			->where('mem_wxid', $openid)
			->where('mem_unionId', $unionid)
			->where('shop_id', $shop['shop_id'])
			->find();
			if($collect){
				$mem = Db::table('msm_member')
				->where('mem_id', $collect['mem_id'])
				//->where('mem_shop', $shop['shop_id'])
				->find();
				if($mem){
					if(!$mem['mem_hand']){
						//判断当前手机号是否已经注册，如果已经注册修改mem_id为已注册的用户
						$memPhone = Db::table('msm_member')
						->where('mem_hand', $phone)
						->find();
						if($memPhone){
							//改下关注表的mem_id
							$upMem = array('mem_id'=>$memPhone['mem_id']);
							$up_id = Db::table('msm_member_collect')->where('mem_id', $mem['mem_id'])->update($upMem);
							//删除member表记录
							$res = Db::name('msm_member')->where('mem_id', $mem['mem_id'])->delete();
							if($res){
								return ApiResponse::success("操作成功", '绑定成功', 0);
							}else{
								return ApiResponse::error('操作失败', 404, '手机绑定失败!');
							}
						}else{
							//修改当前用户的手机号码
							$up = array(
								'mem_hand'=> $phone
							);
							Db::table('msm_member')->where('mem_id', $mem['mem_id'])->update($up);
							return ApiResponse::success("操作成功", '绑定成功', 0);
						}
						return ApiResponse::success("操作成功", '登录成功', 0);
					}else{
						return ApiResponse::error('操作失败', 404, '手机已经绑定【'.$mem['mem_hand'].'】!');
					}
					
				}else{
					//用户信息异常
					return ApiResponse::error('操作失败', 404, '用户信息异常[collect]!');
				}
			}else{
				return ApiResponse::error('操作失败', 401, '用户不存在!');
			}
		}else{
			//public static function error($msg = '操作失败', $code = 400, $data = null)
			return ApiResponse::error('操作失败', 401, 'AppID['.$AppID.']不存在!');
		}
    }
	
	//记录小程序广告次数积分
	public function recordAd(){
		$param = request()->param();
		if (!isset($param['appid'])) {
			return ApiResponse::error('操作失败', 401, 'appid参数不存在!');
		}
		if (!isset($param['unionid'])) {
			return ApiResponse::error('操作失败', 401, 'unionid参数不存在!');
		}
		if (!isset($param['openid'])) {
			return ApiResponse::error('操作失败', 401, 'openid参数不存在!');
		}
		if (!isset($param['score'])) {
			return ApiResponse::error('操作失败', 401, 'score参数不存在!');
		}
		if (!isset($param['SN'])) {
			return ApiResponse::error('操作失败', 401, 'SN参数不存在!');
		}

		$appid = $param['appid'];
		$unionid = $param['unionid'];
		$openid = $param['openid'];
		$score = $param['score'];//积分 不填默认为10
		

		$SN = $param['SN'];//二维码参数
		if(empty($SN)){
			return ApiResponse::error('操作失败', 401, '二维码不能为空!');
		}
		if(!$appid){
			return ApiResponse::error('操作失败', 401, 'appid不能为空!');
		}
		if(!$unionid){
			return ApiResponse::error('操作失败', 401, 'unionid不能为空!');
		}
		if(!$openid){
			return ApiResponse::error('操作失败', 401, 'openid不能为空!');
		}
		if(!$score){
			return ApiResponse::error('操作失败', 401, '没有积分!');
		}
		if(!$SN){
			return ApiResponse::error('操作失败', 401, '二维码不能为空!');
		}
		//根据openid获取用户信息，判断手机是否绑定
		$shop = Db::table('msm_shop')
        ->where('shop_dyappid', $appid)
        ->find();
		if($shop){
			//判断当前openid用户是否已经注册，没有注册则新注册  msm_member_collect
			$collect = Db::table('msm_member_collect')
			->where('mem_wxid', $openid)
			->where('mem_unionId', $unionid)
			->where('shop_id', $shop['shop_id'])
			->find();
			if($collect){
				$mem = Db::table('msm_member')
				->where('mem_id', $collect['mem_id'])
				//->where('mem_shop', $shop['shop_id'])
				->find();
				if($mem){
					//判断二维码
					$qrcode = Db::table('msm_village_qrcode')
					->where('qrcode_code', $SN)
					//->where('qrcode_shop', $shop['shop_id'])//是否要判断必须当前店铺的二维码才能查看
					->find();
					if($qrcode){
						if($qrcode['raffle_state'] != 3){
							$log = array(
								'log_qrcode'	=> $qrcode['qrcode_id'],
								'log_mem'	=> $mem['mem_id'],
								'log_shop'	=> $shop['shop_id'],
								'log_name'	=> $mem['mem_name'],
								'log_time'	=> date('Y-m-d H:i:s'),
								'log_date'	=> date('Y-m-d'),
								'log_state'	=> 1,
								'log_value'	=> $score,
							);
							$inser_id = Db::table('msm_village_qrcode_log')->insertGetId($log);
							//入库成功
							if($inser_id){
								$member_fee = Db::table('msm_member_fee')->where('mem_id', $mem['mem_id'])->find();
								if(empty($member_fee)){
									$fee_arr = array(
										'mem_id'		=> $mem['mem_id'],
										'shop_id'		=> $shop['shop_id'],
										'fee_money'		=> 0, //总收益
										'fee_leave'		=> 0, //剩余余额
										'fee_last'		=> date('Y-m-d H:i:s'),
									);
									$inser_id = Db::table('msm_member_fee')->insertGetId($fee_arr);
									$member_fee = Db::table('msm_member_fee')->where('mem_id', $mem['mem_id'])->find();
								}
								//剩余零钱
								$fee_leave = $member_fee['fee_leave'] + $score;
								$fee_money = $member_fee['fee_money'] + $score;

								//增加零钱记录
								$feechild=array(
									'fee_code'		=> $SN,//单号
									'fee_bill'		=> $SN,//订单号
									'fee_sole'		=> '',//ID和LINE
									'fee_mode'		=> 'FX',//上期结存数量
									'fee_time'		=> date("Y-m-d H:i:s"),
									'fee_money'		=> $score,//金额
									'fee_leave'		=> $fee_leave,//户账总余额（包括不可提现）
									'fee_mem'		=> $mem['mem_id'],//mem_id
									'fee_shop'		=> $shop['shop_id'],//fee_shop店铺
									'fee_memo'		=> '广告赚钱'.$SN,//
									'fee_finish'		=> 'N',//判断这个零钱有没有用完
									'fee_draw'		=> date('Y-m-d'),//提现日期
									'fee_used'		=> 0,//用使金额
									'fee_underling'		=> 0,//下级介绍人（直接下线）
									'fee_buy'		=> $mem['mem_id'],//购买者（订单付款人）
									'fee_depth'		=> 0,//层级数（fee_mem到fee_buy之间的人数）
									'fee_amount'		=> 0,//
								);
								$inser_id = Db::table('msm_member_feechild')->insertGetId($feechild);
								//修改零钱
								$m_f = array('fee_money'=>$fee_money,'fee_leave'=>$fee_leave,'fee_last'=> date('Y-m-d H:i:s'));
								$up_id = Db::table('msm_member_fee')->where('mem_id', $mem['mem_id'])->update($m_f);
								return ApiResponse::success("操作成功", '积分成功!', 0);
							}else{
								return ApiResponse::error('操作失败', 404, '新增失败[collect]!');
							}
						}else{
							return ApiResponse::error('操作失败', 404, '二维码已结束!');
						}
					}
				}else{
					//用户信息异常
					return ApiResponse::error('操作失败', 404, '用户信息异常111[collect]!');
				}
			}else{
				return ApiResponse::error('操作失败', 401, '用户不存在!');
			}
		}else{
			return ApiResponse::error('操作失败', 401, 'AppID['.$AppID.']不存在!');
		}
	}
	
	//查询主页信息
	public function userinfo(){
		$param = request()->param();
		if (!isset($param['appid'])) {
			return ApiResponse::error('操作失败', 401, 'appid参数不存在!');
		}
		if (!isset($param['unionid'])) {
			return ApiResponse::error('操作失败', 401, 'unionid参数不存在!');
		}
		if (!isset($param['openid'])) {
			return ApiResponse::error('操作失败', 401, 'openid参数不存在!');
		}
		$appid = $param['appid'];
		$unionid = $param['unionid'];
		$openid = $param['openid'];
		if(!$appid){
			return ApiResponse::error('操作失败', 401, 'appid不能为空!');
		}
		if(!$unionid){
			return ApiResponse::error('操作失败', 401, 'unionid不能为空!');
		}
		if(!$openid){
			return ApiResponse::error('操作失败', 401, 'openid不能为空!');
		}
		//根据openid获取用户信息，判断手机是否绑定
		$shop = Db::table('msm_shop')
        ->where('shop_dyappid', $appid)
        ->find();
		if($shop){
			//判断当前openid用户是否已经注册，没有注册则新注册  msm_member_collect
			$collect = Db::table('msm_member_collect')
			->where('mem_wxid', $openid)
			->where('mem_unionId', $unionid)
			->where('shop_id', $shop['shop_id'])
			->find();
			if($collect){
				$mem = Db::table('msm_member')
				->where('mem_id', $collect['mem_id'])
				//->where('mem_shop', $shop['shop_id'])
				->find();
				if($mem){
					//$member_fee = $ass->one('member_fee','','mem_id='.$mem['mem_id']);
					$member_fee = Db::table('msm_member_fee')->where('mem_id', $mem['mem_id'])->find();
					$logs = Db::table('msm_village_qrcode_log')
					->where('log_mem', $mem['mem_id'])
					->where('log_date', date('Y-m-d'))
					->select();
					$times = 0;
					$times_total = 0;
					$dayscore = 0;
					$dayscore_toal = 0;
					//$fp=fopen('logs.txt','a');
					//fwrite($fp,var_export($logs,true)."\r\n");
					//fclose($fp);
					foreach($logs as $key => $val){
						$times_total++;
						$dayscore_toal = $dayscore_toal +$val['log_value'];
						if($val['log_shop']==$shop['shop_id']){
							$times++;
							$dayscore = $dayscore +$val['log_value'];
						}
					}
					$data = array(
						'openid'		=> $openid,
						'score_total'	=> $member_fee['fee_money'],
						'times'			=> $times,
						'times_total'	=> $times_total,
						'dayscore'		=> $dayscore,
						'dayscore_toal'	=> $dayscore_toal,
						'wx_account'	=> $mem['mem_hand']
					);
					return ApiResponse::success($data, '操作成功', 0);
				}else{
					//用户信息异常
					return ApiResponse::error('操作失败', 404, '用户信息异常[collect]!');
				}
			}else{
				return ApiResponse::error('操作失败', 401, '用户不存在!');
			}
		}else{
			return ApiResponse::error('操作失败', 401, 'AppID['.$AppID.']不存在!');
		}
	}

	public function curl_data($url, $data = [], $method = 'POST', $type = 'form-data',$access_token='')
    {
        //初始化
        $ch = curl_init();
        $headers = [
            'form-data' => ['Content-Type: multipart/form-data'], 'json' => ['Content-Type: application/json'],
        ];
        //统一转化为大写
        $method = strtoupper($method);
        if ($method == 'GET') {
            if ($data) {
                $querystring = http_build_query($data);
                $url = $url . '?' . $querystring;
            }
        }
        // 请求头，可以传数组
        curl_setopt($ch, CURLOPT_URL, $url);
		if($access_token){
			curl_setopt($ch, CURLOPT_HTTPHEADER, [
				'content-type: application/json',
				'access-token: '.$access_token,
			]);
		}else{
			curl_setopt($ch, CURLOPT_HTTPHEADER, [
				'content-type: application/json'
			]);
		}
        curl_setopt($ch, CURLOPT_HEADER, false);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
		curl_setopt($ch, CURLOPT_POST, true);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
        curl_setopt($ch, CURLOPT_TIMEOUT, 10);           //最大相应超时时间
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); // 跳过证书检查
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false); // 不从证书中检查SSL加密算法是否存在
		curl_setopt ($ch,CURLOPT_FOLLOWLOCATION, false);

        $output = curl_exec($ch);
        curl_close($ch);
        return $output;
    }

}
