<?php
namespace app\controller;

use app\BaseController;
use app\common\util\CommonUtils;
use app\common\util\MetaUtils;
use app\common\util\PlatformUtils;
use app\common\util\SmsUtils;
use app\service\AdService;
use app\service\business\MemberBindMobileService;
use app\service\SessionService;
use app\service\TrackLogService;
use think\facade\Db;

require_once '../vendor/autoload.php';
// // 导入对应产品模块的client
use TencentCloud\Sms\V20210111\SmsClient;
// 导入要请求接口对应的Request类
use TencentCloud\Sms\V20210111\Models\SendSmsRequest;
use TencentCloud\Common\Exception\TencentCloudSDKException;
use TencentCloud\Common\Credential;
// 导入可选配置类
use TencentCloud\Common\Profile\ClientProfile;
use TencentCloud\Common\Profile\HttpProfile;
use think\facade\Config;
use think\facade\Log;
use think\facade\Session;
use think\Request;

//接口返回
use app\common\util\ApiResponse;
use think\App;
use app\service\MemberService;
use app\service\CoinService;
use app\service\PointService;
use app\service\ShopService;
use app\service\CollectService;
use app\common\util\RequestUtils;


class ApiNew
{
    protected $shopService;
    protected $collectService;
    protected $memberService;
    protected $coinService;
    protected $pointService;
    protected $requestUtils;
    protected $sessionService;
    protected $platformUtils;
    protected $adService;
    protected $trackLogService;
    protected $memberBindMobileService;
    
    // 构造函数用于依赖注入
    public function __construct(
        ShopService $shopService,
        CollectService $collectService,
        MemberService $memberService,
        CoinService $coinService,
        PointService $pointService,
        SessionService $sessionService,
        PlatformUtils $platformUtils,
        AdService $adService,
        TrackLogService $trackLogService,
        MemberBindMobileService $memberBindMobileService,
        RequestUtils $requestUtils
    ) {
        $this->shopService = $shopService;
        $this->collectService = $collectService;
        $this->memberService = $memberService;
        $this->coinService = $coinService;
        $this->pointService = $pointService;
        $this->requestUtils = $requestUtils;
        $this->sessionService = $sessionService;
        $this->platformUtils = $platformUtils;
        $this->adService = $adService;
        $this->trackLogService = $trackLogService;
        $this->memberBindMobileService = $memberBindMobileService;
    }
    
    //测试接口
    public function getTest(Request $request)
    {
        //var_dump($this->sessionService->getSession(SessionService::SESSION_KEY_MEMBER_LOGIN));

        //echo phpinfo();exit;
        return ApiResponse::success("测试成功qq", '测试成功', 0);
    }

    //获取通用配置表
    public function configByCommon(Request $request)
    {
        $appid = $request->header('X-Client-Appid', '');
        //$appid = $request->param('appid', '');
        if(!$appid){
            return ApiResponse::error('操作失败', 401, 'appid不能为空!');
        }
        $shop = $this->shopService->getDyShopByAppid($appid);
        if (!$shop) {
            return ApiResponse::error('操作失败', 401, 'appid不存在!');
        }
        $shop_id = $shop['shop_id'] ?? 0;
        $platform = $this->platformUtils->getPlatform();

        $isOpen = MetaUtils::coin_day_qrcode_count($platform, $shop_id);
        $isOpen = $isOpen > 0 ? 1 : 0;
        $data = array(
            'record_open'		=> array('name'=>'抖音积分是否开启','value'=>$isOpen),
            'day_count'			=> array('name'=>'抖音天可扫二维码个数','value'=>MetaUtils::coin_day_qrcode_count($platform, $shop_id)),
            'qrcode_count'		=> array('name'=>'每个二维码扫描次数每个二维码扫描次数','value'=>MetaUtils::coin_day_scan_count($platform, $shop_id)),
            'not_qrcode_count'		=> array('name'=>'不扫码每日观看次数','value'=>MetaUtils::coin_day_normal_count($platform, $shop_id)),
            'point_divisor'	=> array('name'=>'豆子转积分倍率','value'=>MetaUtils::coin_coin_change_point($platform, $shop_id)),
        );
        return ApiResponse::success($data, '操作成功', 0);
    }

    public function loginByDYTest(Request $request)
    {
        $appid = $request->header('X-Client-Appid', '');
        $code = $request->param('code', '');
        $openid = $request->param('openid', '');
        $unionid = $request->param('unionid', '');
        $this->sessionService->clearSessionByMemberLogin();
        if (!$appid) {
            return ApiResponse::error('操作失败', 401, 'appid不能为空!');
        }

//        $shop = $this->shopService->getDyShopByAppid($appid);
//        if (!$shop) {
//            return ApiResponse::error('操作失败', 401, 'appid不存在!');
//        }
        //判断当前openid用户是否已经注册，没有注册则新注册  msm_member_collect
        $collect = $this->collectService->getByOpenid($openid, $unionid);
        if ($collect) {
            $mem = $this->memberService->getByMemID($collect['mem_id']);
            if (!$mem) {
                return ApiResponse::error('操作失败', 401, '用户信息不存在[member]!');
            }

            $this->sessionService->registerSessionByMemberLogin(
                $mem['mem_id'],
                $collect['shop_id'],
                $collect['id']
            );
            $memArr = array(
                'openid' => $openid,
                'unionid' => $unionid,
                'mem_name' => $mem['mem_name'],
                'shop_id' => $collect['shop_id'],
                'mobile' => $mem['mem_hand']
            );
            return ApiResponse::success($memArr, '登录成功', 0);
        }else{
            return ApiResponse::error('登录失败', 401, 'appid不存在!');
        }
    }
    // 抖音登录 返回值wx_account 改为 mobile
    public function loginByDY(Request $request)
    {
        $appid = $request->header('X-Client-Appid', '');
        $code = $request->param('code', '');
        $this->sessionService->clearSessionByMemberLogin();
        if (!$appid) {
            return ApiResponse::error('操作失败', 401, 'appid不能为空!');
        }
        if (!$code) {
            return ApiResponse::error('操作失败', 401, 'code不能为空!');
        }

        $shop = $this->shopService->getDyShopByAppid($appid);
        if (!$shop) {
            return ApiResponse::error('操作失败', 401, 'appid不存在!');
        }
        // 三方交互请求
        $url = "https://developer.toutiao.com/api/apps/v2/jscode2session";
        $data = array(
            'appid' => $appid,
            'secret' => $shop['shop_dyappsecret'],
            'code' => $code,
            //'anonymous_code' => $secret,
        );
        $method = "POST";
        $type = "json";
        $codeArr = $this->requestUtils->curlData($url,json_encode($data),$method,$type);
        $codeArr = json_decode($codeArr, true);
        if ($codeArr['err_no'] != 0) {
            return ApiResponse::error('操作失败', 401, 'AppID['.$appid.']不存在!');
        }

        // 业务逻辑
        $arr = $codeArr['data'];
        $session_key = $arr['session_key'];
        $openid = $arr['openid'];
        $anonymous_openid = $arr['anonymous_openid'];
        $unionid = $arr['unionid'];

        //判断当前openid用户是否已经注册，没有注册则新注册  msm_member_collect
        $collect = $this->collectService->getByOpenid($openid, $unionid);
        if ($collect) {
            $mem = $this->memberService->getByMemID($collect['mem_id']);
            if (!$mem) {
                return ApiResponse::error('操作失败', 401, '用户信息不存在[member]!');
            }
            $this->sessionService->registerSessionByMemberLogin(
                $mem['mem_id'],
                $shop['shop_id'],
                $collect['id']
            );
            $memArr = array(
                'openid' => $openid,
                'unionid' => $unionid,
                'mem_name' => $mem['mem_name'],
                'mobile' => $mem['mem_hand']
            );
            return ApiResponse::success($memArr, '登录成功', 0);
        }else{
            //注册新用户
            $memArr = array(
                'mem_name'		=> "抖音".$openid,//昵称
                //'mem_image'	=> $userinfo['headimgurl'],//头像
                'mem_unionId'	=> $unionid,
                //'mem_sex'		=>'M',
                'mem_pwd'		=> MD5(""),
                'mem_addtime'	=>date('Y-m-d H:i:s'),
                'mem_parent'	=> 0,//介绍人
                //'mem_invitecode'=> $mem_invitecode,//推广码
                'mem_from'		=> 'DY',//会员来源
                'mem_level'		=> 0,//分销级别，进来默认V1级别
                'mem_comp'		=> $shop['comp_id'],
                'mem_last'		=>date('Y-m-d H:i:s'),
                //'mem_hand'	=>$mem_hand,
                'mem_wxid'		=>$openid,
                'mem_shop'		=>$shop['shop_id'],
                'dymp_openid' => $openid,
                'dymp_unionId' => $unionid
            );
            $mem_id = Db::table('msm_member')->insertGetId($memArr);
            if (!$mem_id) {
                return ApiResponse::error('操作失败', 401, '新增失败[mem]!');
            }
            $collectArr = array(
                'mem_id'		=> $mem_id,//会员id
                'shop_id'		=> $shop['shop_id'],//关注的店铺
                'collect_time'	=> date('Y-m-d H:i:s'),//关注时间
                'mem_last'		=> date('Y-m-d H:i:s'),//最后更新时间
                'collect_status'=>'N',//关注状态,绑定微信时候使用
                'comp_id'		=>$shop['shop_id'],
                'mem_station'	=>'A',//A用户
                'mem_wxid'		=>$openid,//用户抖音ID
                'mem_unionId'	=> $unionid,
                'openid_from'	=> "dy",
                'dymp_openid' => $openid,
                'dymp_unionId' => $unionid
            );
            $inser_id = Db::table('msm_member_collect')->insertGetId($collectArr);
            //入库成功
            if(!$inser_id){
                return ApiResponse::error('操作失败', 401, '新增失败[collect]!');
            }
            $this->sessionService->registerSessionByMemberLogin(
                $mem_id,
                $shop['shop_id'],
                $inser_id
            );
            $memArr = array(
                'mem_id' => $mem_id,
                'openid' => $openid,
                'unionid' => $unionid,
                'mem_name' => $memArr['mem_name'],
                'mobile' => ''
            );
            
            return ApiResponse::success($memArr, '登录成功', 0);
        }
    }

    // 获取手机登录短信验证码
    public function loginBySmsCode(Request $request)
    {
        $mobile = $request->param('mobile', '');

        try {
            // 先录入表
            $sendCount = Db::table('msm_ms_sms_code')
                ->where('category', 1)
                ->where('mobile', $mobile)
                ->where('create_time', '>', strtotime(date('Y-m-d')))
                ->count();
            if ($sendCount >= 20) {
                return ApiResponse::error('手机号今天发送验证码次数过多', 401);
            }
            $code = rand(100000, 999999);
            
            $data = [
                'category' => 1,
                'mobile' => $mobile,
                'sms_code' => $code,
                'mem_id' => 0,
                'send_num' => 1,
                'verify_num' => 0,
                'status' => 0,
                'ip' => $request->ip(),
                'platform' => $this->platformUtils->getPlatform(),
                'create_time' => time(),
                'update_time' => time(),
            ];
            $id = Db::table('msm_ms_sms_code')->insertGetId($data);
            if (!$id) {
                return ApiResponse::error('获取短信验证码失败', 401);
            }
            SmsUtils::sendSmsCode($mobile, $code);
        } catch (\Exception $e) {
            return ApiResponse::error('发送验证码失败', 401);
        }
        $return = [];
        return ApiResponse::success($return, '验证码获取成功', 0);
    }

    // 手机验证码登录
    public function loginByMobile(Request $request)
    {
        $appid = $request->header('X-Client-Appid', '');
        $mobile = $request->param('mobile', '');
        $sms_code = $request->param('sms_code', '');
        $this->sessionService->clearSessionByMemberLogin();
        if (!$appid) {
            return ApiResponse::error('appid不能为空', 401);
        }
        if (!$mobile) {
            return ApiResponse::error('手机号不能为空', 401);
        }
        if (!$sms_code) {
            return ApiResponse::error('验证码不能为空', 401);
        }

        // TODO guan 后面要删除 '18726488462', 
        if (!in_array($mobile, ['13916525962'])) {
            // 验证码验证逻辑，失败3次锁定
            $send = Db::table('msm_ms_sms_code')
                ->where('category', 1)
                ->where('mobile', $mobile)
                ->order('create_time', 'desc')
                ->find();
            if (!$send) {
                return ApiResponse::error('请先获取验证码', 401);
            }
            if ($send['status'] != 0) {
                return ApiResponse::error('验证码已失效', 401);
            }
            if ((time() - $send['create_time']) > 600) {
                return ApiResponse::error('验证码已超时失效', 401);
            }
            if ($send['sms_code'] != $sms_code) {
                $dataUp = [
                    'verify_num' => $send['verify_num'] + 1,
                ];
                Db::table('msm_ms_sms_code')->where('id', $send['id'])->update($dataUp);
                return ApiResponse::error('验证码错误', 401);
            }

            $dataUp = [
                'verify_num' => $send['verify_num'] + 1,
                'status' => 1,
            ];
            Db::table('msm_ms_sms_code')->where('id', $send['id'])->update($dataUp);

        }
        // 登录逻辑
        $shop = $this->shopService->getDyShopByAppid($appid);
        if (!$shop) {
            return ApiResponse::error('店铺不存在', 401);
        }
        $mem = $this->memberService->getByMobile($mobile);
        if ($mem) {
            // 手机号登录
            $collect = $this->collectService->getByMemIDAndShopID($mem['mem_id'], $shop['shop_id']);
            if (!$collect) {
                // 关联
                $collectArr = array(
                    'mem_id'		=> $mem['mem_id'],//会员id
                    'shop_id'		=> $shop['shop_id'],//关注的店铺
                    'collect_time'	=> date('Y-m-d H:i:s'),//关注时间
                    'mem_last'		=> date('Y-m-d H:i:s'),//最后更新时间
                    'collect_status'=>'N',//关注状态,绑定微信时候使用
                    'comp_id'		=>$shop['shop_id'],
                    'mem_station'	=>'A',//A用户
                    'mem_wxid'		=> '',
                    'mem_unionId'	=> '',
                    'openid_from'	=> $this->platformUtils->getPlatform(),
                    'dymp_openid' => '',
                    'dymp_unionId' => ''
                );
                $inser_id = Db::table('msm_member_collect')->insertGetId($collectArr);
                //入库成功
                if(!$inser_id){
                    return ApiResponse::error('操作失败', 401, '新增失败[collect]!');
                }
                $this->sessionService->registerSessionByMemberLogin(
                    $mem['mem_id'],
                    $shop['shop_id'],
                    $inser_id
                );
            } else {
                $this->sessionService->registerSessionByMemberLogin(
                    $mem['mem_id'],
                    $shop['shop_id'],
                    $collect['id']
                );
            }
            $mem_id = $mem['mem_id'];
        } else {
            // 手机号注册
            //注册新用户
            $memArr = array(
                'mem_name'		=> "app",//昵称
                //'mem_image'	=> $userinfo['headimgurl'],//头像
                'mem_unionId'	=> '',
                //'mem_sex'		=>'M',
                'mem_pwd'		=> MD5(""),
                'mem_addtime'	=>date('Y-m-d H:i:s'),
                'mem_parent'	=> 0,//介绍人
                //'mem_invitecode'=> $mem_invitecode,//推广码
                'mem_from'		=> 'DY',//会员来源
                'mem_level'		=> 0,//分销级别，进来默认V1级别
                'mem_comp'		=> $shop['comp_id'],
                'mem_last'		=>date('Y-m-d H:i:s'),
                //'mem_hand'	=>$mem_hand,
                'mem_wxid'		=>'',
                'mem_shop'		=>$shop['shop_id']
            );
            $mem_id = Db::table('msm_member')->insertGetId($memArr);
            if (!$mem_id) {
                return ApiResponse::error('操作失败', 401, '新增失败[mem]!');
            }
            $platform = $this->platformUtils->getPlatform();
            // 'wx','dy','xcx','app'
            if ($platform == PlatformUtils::WX) {
                $openid_from = 'wx';
            } elseif ($platform == PlatformUtils::DYMP) {
                $openid_from = 'dy';
            } elseif ($platform == PlatformUtils::WXMP) {
                $openid_from = 'xcx';
            } else {
                $openid_from = 'app';
            }
            $collectArr = array(
                'mem_id'		=> $mem_id,//会员id
                'shop_id'		=> $shop['shop_id'],//关注的店铺
                'collect_time'	=> date('Y-m-d H:i:s'),//关注时间
                'mem_last'		=> date('Y-m-d H:i:s'),//最后更新时间
                'collect_status'=>'N',//关注状态,绑定微信时候使用
                'comp_id'		=>$shop['shop_id'],
                'mem_station'	=>'A',//A用户
                'mem_wxid'		=>'',//用户抖音ID
                'mem_unionId'	=> '',
                'openid_from'	=> $openid_from
            );
            $inser_id = Db::table('msm_member_collect')->insertGetId($collectArr);
            //入库成功
            if(!$inser_id){
                return ApiResponse::error('操作失败', 401, '新增失败[collect]!');
            }
            $this->sessionService->registerSessionByMemberLogin(
                $mem_id,
                $shop['shop_id'],
                $inser_id
            );
            $memArr = array();
            return ApiResponse::success($memArr, '登录成功', 0);
        }
        $return = [
            'mem_id' => $mem_id,
        ];
        return ApiResponse::success($return, '登录成功', 0);
    }

    //绑定手机号
    public function bindMobile(Request $request)
    {
        $mobile = $request->param('mobile', '');
        if (!$mobile) {
            return ApiResponse::error('请输入手机号', 401);
        }

        $memSession = $this->sessionService->getSessionByMemberLogin();
        if (!$memSession) {
            return ApiResponse::error('未登录', 30001);
        }
        try {
            $return = $this->memberBindMobileService->handle(
                $mobile,
                $memSession['collect_id'],
                $memSession['mem_id'],
                $memSession['shop_id']
            );
            return ApiResponse::success($return, '绑定成功', 0);
        } catch (\Exception $e) {
            return ApiResponse::error($e->getMessage());
        }
    }

    //设置坐标
    public function saveMapLatlng(Request $request)
    {
        $appid = $request->header('X-Client-Appid', '');
        $city = $request->param('city', '');
        $latitude = $request->param('latitude', '');
        $longitude = $request->param('longitude', '');
        if (!$city) {
            return ApiResponse::error('city参数不存在', 401);
        }
        if (!$latitude || !$longitude) {
            return ApiResponse::error('定位参数不存在', 401);
        }
        $memSession = $this->sessionService->getSessionByMemberLogin();
        if (!$memSession) {
            return ApiResponse::error('未登录', 30001);
        }
        $mem = $this->memberService->getByMemID($memSession['mem_id']);
        if (!$mem) {
            return ApiResponse::error('登录账号信息不存在', 30001);
        }
        // 修改当前用户坐标
        $up = array(
            'mem_geocoder'=> $city,
            'mem_longitude'=> $longitude,
            'mem_latitude'=> $latitude
        );
        Db::table('msm_member')->where('mem_id', $mem['mem_id'])->update($up);
        return ApiResponse::success("设置坐标成功", '操作成功', 0);
    }

    // 用户信息显示
    public function memberInfo(Request $request)
    {
        //$appid = $request->header('X-Client-Appid', '');

        $memSession = $this->sessionService->getSessionByMemberLogin();
        if (!$memSession) {
            return ApiResponse::error('未登录', 30001);
        }
        $mem = $this->memberService->getByMemID($memSession['mem_id']);
        if (!$mem) {
            return ApiResponse::error('登录账号信息不存在', 30001);
        }
        $platform = $this->platformUtils->getPlatform();
        
        $fee = $this->memberService->getFeeByMemID($memSession['mem_id']);
        $is_share = MetaUtils::coin_is_share($platform, $memSession['shop_id']);

        $scanAdCountByLooked = $this->coinService->getTodayCountPlatform($mem['mem_id'], $memSession['shop_id'], CoinService::CATEGORY_ADD_SCAN_AD, $platform);
        $dayViewAdCountByLooked = $this->coinService->getTodayCountPlatform($mem['mem_id'], $memSession['shop_id'], CoinService::CATEGORY_ADD_NORMAL_AD, $platform);
        $scanAdCountBySurplus = MetaUtils::coin_day_scan_total($platform, $memSession['shop_id']) - $scanAdCountByLooked;
        $scanAdCountBySurplus = $is_share ? ($scanAdCountBySurplus - $dayViewAdCountByLooked) : $scanAdCountBySurplus;
        $dayViewAdCountBySurplus = MetaUtils::coin_day_normal_count($platform, $memSession['shop_id']) - $dayViewAdCountByLooked;
        $dayViewAdCountBySurplus = $is_share ? ($dayViewAdCountBySurplus - $scanAdCountByLooked) : $dayViewAdCountBySurplus;
        
        $day_coin = $this->coinService->getTodayCoin($mem['mem_id'], CoinService::CATEGORY_ADD_SCAN_AD)
            + $this->coinService->getTodayCoin($mem['mem_id'], CoinService::CATEGORY_ADD_NORMAL_AD);
        // 手机号，总积分，总豆子，今日获取豆子，扫码已看次数，今日不扫码已看次数、扫码剩余可看次数、今日不扫码剩余可看次数
        $data = array(
            'mobile' => $mem['mem_hand'] ?? '', // 手机号
            'fee_leave' => $fee['fee_leave'] ?? '0.00', // 总积分
            'coin' => $fee ? $fee['coin'] : 0, // 总豆子
            'coin_used' => $fee ? $fee['coin_used'] : 0, // 消耗的豆子
            'coin_use' => $fee ? ($fee['coin'] - $fee['coin_used']) : 0, // 可用豆子
            'day_coin' => $day_coin, // 今日获取豆子
            'scanAdCountByLooked' => $scanAdCountByLooked, // 扫码已看次数
            'scanAdCountBySurplus' => $scanAdCountBySurplus, // 扫码剩余可看次数
            'dayViewAdCountByLooked' => $dayViewAdCountByLooked, // 今日不扫码已看次数
            'dayViewAdCountBySurplus' => $dayViewAdCountBySurplus, // 今日不扫码剩余可看次数
        );
        $data['can_change_coin'] = $data['coin_use'] > 0 ? ($data['coin_use'] - $data['coin_use']%MetaUtils::coin_coin_change_point($platform, $memSession['shop_id'])) : 0; // 可转积分豆子
        return ApiResponse::success($data, '操作成功', 0);
    }

    // 跟踪广告打开初始化
    public function initOpenAd(Request $request)
    {
        //$appid = $request->header('X-Client-Appid', '');
        $category = $request->param('category', 1); // 类型：1正常 2广告
        $qrcode_code = $request->param('qrcode_code', '');
        if ($category == AdService::AD_SCAN) {
            if (!$qrcode_code) {
                return ApiResponse::error('请输入二维码', 303);
            }
            //判断二维码
            $qrcode = Db::table('msm_village_qrcode')->where('qrcode_code', $qrcode_code)->find();
            if(!$qrcode){
                return ApiResponse::error('二维码信息不存在', 303);
            }
            if($qrcode['raffle_state'] == 3){
                return ApiResponse::error('二维码已失效', 303);
            }
        }

        $memSession = $this->sessionService->getSessionByMemberLogin();
        if (!$memSession) {
            return ApiResponse::error('未登录', 30001);
        }
        $mem = $this->memberService->getByMemID($memSession['mem_id']);
        if (!$mem) {
            return ApiResponse::error('登录账号信息不存在', 30001);
        }
        if ($category == AdService::AD_SCAN) {
            // TODO 第二和第三DYMP临时转换
            $qrcode_code = CommonUtils::getVrQrcode($qrcode_code, $memSession['shop_id'], $memSession['mem_id']);
            if (!$qrcode_code) {
                return ApiResponse::error('二维码失效');
            }
        }
        $order_no = CommonUtils::getByAdOrderNo($this->platformUtils->getPlatform());
        
        // 记录广告时间
        $paramData = array(
            'category' => $category,
            'collect_id' => $memSession['collect_id'],
            'mem_id' => $memSession['mem_id'],
            'shop_id' => $memSession['shop_id'],
            'order_no' => $order_no,
            'qrcode_code' => $qrcode_code,
            'platform' => $this->platformUtils->getPlatform(),
            'create_time' => time(),
            'end_time' => 0,
        );
        $this->adService->insertLog($paramData);

        $return = [
            'order_no' => $order_no
        ];
        return ApiResponse::success($return, '操作成功', 0);
    }

    // 跟踪广告打开结束调用 扫二维码看广告获得捉米豆 正常看广告获得捉米豆
    public function resultOpenAd(Request $request)
    {
        //$appid = $request->header('X-Client-Appid', '');
        $order_no = $request->param('order_no', '');
        if (!$order_no) {
            return ApiResponse::error('参数错误', 401);
        }
        $log = $this->adService->getByOrderNo($order_no);
        if (!$log) {
            return ApiResponse::error('广告不存在', 401);
        }
        $platform = $this->platformUtils->getPlatform();
        $this->adService->updateSecond($order_no);
        
        $memSession = $this->sessionService->getSessionByMemberLogin();
        if (!$memSession) {
            return ApiResponse::error('未登录', 30001);
        }
        $mem = $this->memberService->getByMemID($memSession['mem_id']);
        if (!$mem) {
            return ApiResponse::error('登录账号信息不存在', 30001);
        }

        // 计算广告得分并录入系统
        $sql = "SELECT * FROM msm_ms_coin_record WHERE order_no=? limit 1";
        $result = Db::query($sql, [$order_no]);
        $id = $result[0]['id'] ?? 0;
        if ($id > 0) {
            return ApiResponse::error('广告已录入', 401);
        }
        
        $isScanAd = $log['category'] == AdService::AD_SCAN;
        $isNormalAd = $log['category'] == AdService::AD_NORMAL;
        // 检测是否可进行广告查看
        if (!$this->platformUtils->isCanViewAd()) {
            return ApiResponse::error('当前平台无法获取广告奖励', 401);
        }
        // 检测当前二维码是否属于有效的二维码
        $isScanAdEnd = false;
        if ($isScanAd) {
            $coinCategory = CoinService::CATEGORY_ADD_SCAN_AD;
            $qrcode_code = $log['qrcode_code'];
            if (!$qrcode_code) {
                return ApiResponse::error('请扫码二维码', 401);
            }

            // TODO 第二和第三DYMP临时转换
            $isVrQrcode = CommonUtils::isVrQrcode($qrcode_code, $memSession['shop_id'], $memSession['mem_id']);
            if ($isVrQrcode) {
                $maxCoin = MetaUtils::coin_coin_change_point($platform, $memSession['shop_id']);
            } else {
                //判断二维码
                $qrcode = Db::table('msm_village_qrcode')->where('qrcode_code', $qrcode_code)->find();
                if(!$qrcode){
                    return ApiResponse::error('二维码信息不存在', 401);
                }
                if($qrcode['raffle_state'] == 3){
                    return ApiResponse::error('二维码已失效', 401);
                }
                $maxCoin = $qrcode['qrcode_money'] * MetaUtils::coin_coin_change_point($platform, $memSession['shop_id']);
            }
            // 扫码操作的二维码：当前二维码获取捉米豆次数已到上限
            $sql = "SELECT COUNT(*) AS count FROM msm_ms_coin_record WHERE category = ? and qrcode_code=?";
            $result = Db::query($sql, [$coinCategory, $qrcode_code]);
            $scanCount = $result[0]['count'];
            if ($scanCount >= MetaUtils::coin_day_scan_count($platform, $memSession['shop_id'])) {
                $q_data = array('raffle_state'=>3);
                Db::table('msm_village_qrcode')->where('qrcode_code', $qrcode_code)->update($q_data);
                return ApiResponse::error('当前二维码获取捉米豆次数已到上限', 401);
            }
            $isScanAdEnd = ($scanCount+1) >= MetaUtils::coin_day_scan_count($platform, $memSession['shop_id']);
            // 扫码操作的二维码
            $sql = "SELECT qrcode_code, COUNT(qrcode_code) as scan_count FROM msm_ms_coin_record WHERE category = ? and in_mem_id=? and create_time>=? and platform=? and qrcode_code<>'' and in_shop_id=? group by qrcode_code";
            $result = Db::query($sql, [$coinCategory, $mem['mem_id'], strtotime(date('Y-m-d')), $platform, $memSession['shop_id']]);
            $todayQrcodeData = [$qrcode_code]; // 二维码data
            $todayQrcodeCount = 0; // 二维码数量
            $todayScanCount = 0; // 当天扫码数量
            if ($result) {
                foreach ($result as $item) {
                    $todayScanCount += $item['scan_count'];
                    if (!in_array($item['qrcode_code'], $todayQrcodeData)) {
                        $todayQrcodeData[] = $item['qrcode_code'];
                        $todayQrcodeCount++;
                    }
                }
            }
            
            $is_share = MetaUtils::coin_is_share($platform, $memSession['shop_id']);
            $todayTaskCount = 0;
            if ($is_share) {
                // 任务操作的广告
                $sql = "SELECT COUNT(id) as task_count FROM msm_ms_coin_record WHERE category = ? and in_mem_id=? and create_time>=? and platform=? and in_shop_id=?";
                $result = Db::query($sql, [CoinService::CATEGORY_ADD_NORMAL_AD, $mem['mem_id'], strtotime(date('Y-m-d')), $platform, $memSession['shop_id']]);
                if ($result) {
                    foreach ($result as $item) {
                        $todayTaskCount += $item['task_count'];
                    }
                }
            }
            // 扫码操作的二维码：今天用户在当前平台扫二维码数量已到上限（包含了当前二维码，大于就是超出）
            if ($todayQrcodeCount > MetaUtils::coin_day_qrcode_count($platform, $memSession['shop_id'])) {
                return ApiResponse::error('今天用户在当前平台扫二维码数量已到上限', 401);
            }
            // 扫码操作的二维码：今天用户在当前平台扫二维码获取捉米豆次数已到上限（未包含本次）
            if (($todayScanCount + $todayTaskCount) >= MetaUtils::coin_day_scan_total($platform, $memSession['shop_id'])) {
                return ApiResponse::error('今天用户在当前平台扫二维码获取捉米豆次数已到上限', 401);
            }
            // 扫码操作的二维码:
            $sql = "SELECT * FROM msm_ms_coin_record WHERE category = ? and qrcode_code=?";
            $result = Db::query($sql, [$coinCategory, $qrcode_code]);
            $in_mem_id = $result[0]['in_mem_id'] ?? 0;
            $in_shop_id = $result[0]['in_shop_id'] ?? 0;
            $in_platform = $result[0]['platform'] ?? 0;
            $nowCount = $result ? count($result) : 0;
            $qrcodeCoinSum = 0;
            if ($nowCount > 0) {
                if ($in_mem_id != $memSession['mem_id'] || $in_shop_id != $memSession['shop_id'] || $in_platform != $platform) {
                    return ApiResponse::error('该二维码已被其他用户扫描使用过');
                }
            }
            if ($result) {
                foreach ($result as $item) {
                    $qrcodeCoinSum += $item['coin'];
                }
            }
            
            // $maxCoin
            $coin = $this->adService->randomCoinByScan($nowCount, $maxCoin, $qrcodeCoinSum);
        } elseif ($isNormalAd) {
            $coinCategory = CoinService::CATEGORY_ADD_NORMAL_AD;
            $qrcode_code = $log['qrcode_code'];

            // 任务操作的广告
            $sql = "SELECT COUNT(id) as task_count FROM msm_ms_coin_record WHERE category = ? and in_mem_id=? and create_time>=? and platform=? and in_shop_id=?";
            $result = Db::query($sql, [CoinService::CATEGORY_ADD_NORMAL_AD, $mem['mem_id'], strtotime(date('Y-m-d')), $platform, $memSession['shop_id']]);
            $todayTaskCount = 0;
            if ($result) {
                foreach ($result as $item) {
                    $todayTaskCount += $item['task_count'];
                }
            }
            $is_share = MetaUtils::coin_is_share($platform, $memSession['shop_id']);
            $todayScanCount = 0; // 当天扫码数量
            if ($is_share) {
                // 扫码操作的二维码
                $sql = "SELECT qrcode_code, COUNT(qrcode_code) as scan_count, sum(coin) as coin_sum FROM msm_ms_coin_record WHERE category = ? and in_mem_id=? and create_time>=? and platform=? and qrcode_code<>'' and in_shop_id=? group by qrcode_code";
                $result = Db::query($sql, [CoinService::CATEGORY_ADD_SCAN_AD, $mem['mem_id'], strtotime(date('Y-m-d')), $platform, $memSession['shop_id']]);
                if ($result) {
                    foreach ($result as $item) {
                        $todayScanCount += $item['scan_count'];
                    }
                }
            }
            // 任务操作的广告：今天用户在当前平台任务获取捉米豆次数已到上限（未包含本次）
            if (($todayTaskCount + $todayScanCount) >= MetaUtils::coin_day_normal_count($platform, $memSession['shop_id'])) {
                return ApiResponse::error('今天用户在当前平台任务获取捉米豆次数已到上限', 401);
            }
            $coin = $this->adService->randomCoinByNormal($todayTaskCount);
        } else {
            return ApiResponse::error('无效访问', 401);
        }

        // TODO guan 时间间隔没做
        /*//获取上次记录时间，如果时间小于30秒丢弃
        $logsData = Db::table('msm_score_log')
            ->where('log_mem', $mem['mem_id'])
            ->where('log_openid', $openid)
            //->where('log_date', date('Y-m-d'))
            ->order('log_time', 'desc')
            ->limit(0, 1)
            ->select();
        if(count($logsData)){
            if((time() - strtotime($logsData[0]['log_time'])<10)){
                return ApiResponse::success('两次广告时间太短', '操作失败', 0);
            }
            //return ApiResponse::success($logsData[0]['log_time'], '操作成功', 0);
        }else{
            return ApiResponse::success($logsData, '没有数据', 0);
        }*/

        $inFee = $this->memberService->getFeeByMemID($memSession['mem_id']);
        $inCoin = $inFee['coin'] ?? 0;
        $inCoinUsed = $inFee['coin_used'] ?? 0;
        $inCoinUse = $inCoin - $inCoinUsed;
        if (!$inFee) {
            $feeData = [
                'mem_id' => $memSession['mem_id'],
                'shop_id' => $memSession['shop_id'],
            ];
            $fee_id = Db::table('msm_member_fee')->insertGetId($feeData);
            if(!$fee_id){
                return ApiResponse::error('会员信息不存在', 401);
            }
        }
        // 赠送豆子
        $coinData = array(
            'category' => $coinCategory,
            'out_collect_id' => 0,
            'out_mem_id' => 0,
            'out_shop_id' => 0,
            'in_collect_id' => $memSession['collect_id'],
            'in_mem_id' => $memSession['mem_id'],
            'in_shop_id' => $memSession['shop_id'],
            'coin' => $coin,
            'old_coin' => $inCoinUse,
            'order_no' => $order_no,
            'qrcode_code' => $qrcode_code,
            'remark' => '',
            'ip' => $request->ip(),
            'platform' => $this->platformUtils->getPlatform(),
            'create_time' => time(),
            'update_time' => time(),
        );
        $inser_id = Db::table('msm_ms_coin_record')->insertGetId($coinData);
        if($inser_id){
            $feeUpdate = array(
                'coin'=> $coin + $inCoin,
            );
            Db::table('msm_member_fee')->where('mem_id', $memSession['mem_id'])->update($feeUpdate);
        }else{
            return ApiResponse::error('操作失败', 401, '新增失败!');
        }
        if ($isScanAd) {
            $q_data = array('raffle_state' => $isScanAdEnd ? 3 : 2);
            Db::table('msm_village_qrcode')->where('qrcode_code', $qrcode_code)->update($q_data);
        }
        $return = [
            'coin' => $coin,
        ];
        return ApiResponse::success($return, '操作成功', 0);
    }

    // 豆子赠送操作
    public function giveCoinToCoin(Request $request)
    {
        //$appid = $request->header('X-Client-Appid', '');
        $mobile = $request->param('mobile', '');
        $coin = $request->param('coin', '');
        $memSession = $this->sessionService->getSessionByMemberLogin();
        if (!$memSession) {
            return ApiResponse::error('未登录', 30001);
        }
        $mem = $this->memberService->getByMemID($memSession['mem_id']);
        if (!$mem) {
            return ApiResponse::error('登录账号信息不存在', 30001);
        }
        if (!$mobile) {
            return ApiResponse::error("手机号码不能为空", 401);
        }
        if ($coin <= 0) {
            return ApiResponse::error("捉米豆需大于0的正整数", 401);
        }
        $inMem = $this->memberService->getByMobile($mobile);
        if (!$inMem) {
            return ApiResponse::error("转入会员不存在", 401);
        }
        $inCollect = $this->collectService->getByMemIDAndShopID($inMem['mem_id'], $memSession['shop_id']);
        if (!$inCollect) {
            return ApiResponse::error("转入会员关系不存在", 401);
        }
        if ($mobile == $mem['mem_hand']) {
            return ApiResponse::error("不能自己赠送自己", 401);
        }
        // 业务逻辑
        $outFee = $this->memberService->getFeeByMemID($mem['mem_id']);
        $outCoin = $outFee['coin'] ?? 0;
        $outCoinUsed = $outFee['coin_used'] ?? 0;
        $outCoinUse = $outCoin - $outCoinUsed;
        if ($coin > $outCoinUse) {
            return ApiResponse::error("捉米豆不足", 401);
        }
        $inFee = $this->memberService->getFeeByMemID($inMem['mem_id']);
        $inCoin = $inFee['coin'] ?? 0;
        $inCoinUsed = $inFee['coin_used'] ?? 0;
        $inCoinUse = $inCoin - $inCoinUsed;
        if (!$inFee) {
            $feeData = [
                'mem_id' => $inCollect['mem_id'],
                'shop_id' => $inCollect['shop_id'],
            ];
            $fee_id = Db::table('msm_member_fee')->insertGetId($feeData);
            if(!$fee_id){
                return ApiResponse::error('转入会员信息不存在', 401);
            }
        }
        
        $order_no = CommonUtils::getByAdOrderNo($this->platformUtils->getPlatform());
        // 转出豆子
        $coinData = array(
            'category' => CoinService::CATEGORY_REDUCE_GIFT_COIN,
            'out_collect_id' => $memSession['collect_id'],
            'out_mem_id' => $memSession['mem_id'],
            'out_shop_id' => $memSession['shop_id'],
            'in_collect_id' => $inCollect['id'],
            'in_mem_id' => $inCollect['mem_id'],
            'in_shop_id' => $inCollect['shop_id'],
            'coin' => -$coin,
            'old_coin' => $outCoinUse,
            'order_no' => $order_no,
            'qrcode_code' => '',
            'remark' => '',
            'ip' => $request->ip(),
            'platform' => $this->platformUtils->getPlatform(),
            'create_time' => time(),
            'update_time' => time(),
        );
        $inser_id = Db::table('msm_ms_coin_record')->insertGetId($coinData);
        if($inser_id){
            $feeUpdate = array(
                'coin'=> $outCoinUsed + $coin,
            );
            Db::table('msm_member_fee')->where('mem_id', $mem['mem_id'])->update($feeUpdate);
        }else{
            return ApiResponse::error('操作失败', 401, '新增失败!');
        }
        // 转入
        $coinData = array(
            'category' => CoinService::CATEGORY_ADD_GIFT_COIN,
            'out_collect_id' => $memSession['collect_id'],
            'out_mem_id' => $memSession['mem_id'],
            'out_shop_id' => $memSession['shop_id'],
            'in_collect_id' => $inCollect['id'],
            'in_mem_id' => $inCollect['mem_id'],
            'in_shop_id' => $inCollect['shop_id'],
            'coin' => $coin,
            'old_coin' => $inCoinUse,
            'order_no' => $order_no,
            'qrcode_code' => '',
            'remark' => '',
            'ip' => $request->ip(),
            'platform' => $this->platformUtils->getPlatform(),
            'create_time' => time(),
            'update_time' => time(),
        );
        $inser_id = Db::table('msm_ms_coin_record')->insertGetId($coinData);
        if($inser_id){
            $feeUpdate = array(
                'coin'=> $inCoin + $coin,
            );
            Db::table('msm_member_fee')->where('mem_id', $inMem['mem_id'])->update($feeUpdate);
        }else{
            return ApiResponse::error('操作失败', 401, '新增失败!');
        }
        return ApiResponse::success([], '提交成功', 0);
    }
    
    // 豆子转积分赠送操作
    public function giveCoinToPoint(Request $request)
    {
        //$appid = $request->header('X-Client-Appid', '');
        $mobile = $request->param('mobile', '');
        $coin = $request->param('coin', '');
        $memSession = $this->sessionService->getSessionByMemberLogin();
        if (!$memSession) {
            return ApiResponse::error('未登录', 30001);
        }
        $mem = $this->memberService->getByMemID($memSession['mem_id']);
        if (!$mem) {
            return ApiResponse::error('登录账号信息不存在', 30001);
        }
        if (!$mobile) {
            return ApiResponse::error("手机号码不能为空", 401);
        }
        $rate = MetaUtils::coin_coin_change_point($this->platformUtils->getPlatform(), $memSession['shop_id']);
        if ($rate <= 0) {
            return ApiResponse::error("积分倍率错误", 401);
        }
        if ($coin < $rate) {
            return ApiResponse::error("捉米豆需大于" . $rate . "的正整数", 401);
        }
        $point = CommonUtils::doBcdiv($coin, $rate);
        if ($point <= 0) {
            return ApiResponse::error("转积分不足", 401);
        }
        
        $inMem = $this->memberService->getByMobile($mobile);
        if (!$inMem) {
            return ApiResponse::error("转入会员不存在", 401);
        }
        $inCollect = $this->collectService->getByMemIDAndShopID($inMem['mem_id'], $memSession['shop_id']);
        if (!$inCollect) {
            return ApiResponse::error("转入会员关系不存在", 401);
        }
        
        // 业务逻辑
        $outFee = $this->memberService->getFeeByMemID($mem['mem_id']);
        $outCoin = $outFee['coin'] ?? 0;
        $outCoinUsed = $outFee['coin_used'] ?? 0;
        $outCoinUse = $outCoin - $outCoinUsed;
        if ($coin > $outCoinUse) {
            return ApiResponse::error("捉米豆不足", 401);
        }
        $inFee = $this->memberService->getFeeByMemID($inMem['mem_id']);
        $inPoint = $inFee['fee_leave'] ?? 0;
        $inFeeMoney = $inFee['fee_money'] ?? 0;
        if (!$inFee) {
            $feeData = [
                'mem_id' => $inCollect['mem_id'],
                'shop_id' => $inCollect['shop_id'],
            ];
            $fee_id = Db::table('msm_member_fee')->insertGetId($feeData);
            if(!$fee_id){
                return ApiResponse::error('转入会员信息不存在', 401);
            }
        }

        $order_no = CommonUtils::getByAdOrderNo($this->platformUtils->getPlatform());
        // 转出豆子
        $coinData = array(
            'category' => CoinService::CATEGORY_REDUCE_GIFT_COIN_POINT,
            'out_collect_id' => $memSession['collect_id'],
            'out_mem_id' => $memSession['mem_id'],
            'out_shop_id' => $memSession['shop_id'],
            'in_collect_id' => $inCollect['id'],
            'in_mem_id' => $inCollect['mem_id'],
            'in_shop_id' => $inCollect['shop_id'],
            'coin' => -$coin,
            'old_coin' => $outCoinUse,
            'order_no' => $order_no,
            'qrcode_code' => '',
            'remark' => '',
            'ip' => $request->ip(),
            'platform' => $this->platformUtils->getPlatform(),
            'create_time' => time(),
            'update_time' => time(),
        );
        $inser_id = Db::table('msm_ms_coin_record')->insertGetId($coinData);
        if($inser_id){
            $feeUpdate = array(
                'coin_used'=> $outCoinUsed + $coin,
            );
            Db::table('msm_member_fee')->where('mem_id', $mem['mem_id'])->update($feeUpdate);
        }else{
            return ApiResponse::error('操作失败', 401, '新增失败!');
        }
        // 转入
        $coinData = array(
            'category' => PointService::CATEGORY_ADD_GIFT_COIN_POINT,
            'out_collect_id' => $memSession['collect_id'],
            'out_mem_id' => $memSession['mem_id'],
            'out_shop_id' => $memSession['shop_id'],
            'in_collect_id' => $inCollect['id'],
            'in_mem_id' => $inCollect['mem_id'],
            'in_shop_id' => $inCollect['shop_id'],
            'point' => $point,
            'old_point' => $inPoint,
            'coin' => $coin,
            'order_no' => $order_no,
            'remark' => '',
            'ip' => $request->ip(),
            'platform' => $this->platformUtils->getPlatform(),
            'create_time' => time(),
            'update_time' => time(),
        );
        $inser_id = Db::table('msm_ms_point_record')->insertGetId($coinData);
        if($inser_id){
            $feeUpdate = array(
                'fee_leave'=> $inPoint + $point,
                'fee_money'=> $inFeeMoney + $point,
            );
            Db::table('msm_member_fee')->where('mem_id', $inMem['mem_id'])->update($feeUpdate);
        }else{
            return ApiResponse::error('操作失败', 401, '新增失败!');
        }
        return ApiResponse::success([], '提交成功', 0);
    }
    
    // 看广告豆子获取记录列表
    public function listCoinByViewAd(Request $request)
    {
        //$appid = $request->header('X-Client-Appid', '');
        $page = $request->param('page', 1);
        $pageSize = $request->param('pageSize', 20);
        
        $memSession = $this->sessionService->getSessionByMemberLogin();
        if (!$memSession) {
            return ApiResponse::error('未登录', 30001);
        }
        $mem = $this->memberService->getByMemID($memSession['mem_id']);
        if (!$mem) {
            return ApiResponse::error('登录账号信息不存在', 30001);
        }
        $mem_id = $mem['mem_id'];
        
        $logs = Db::table('msm_ms_coin_record')
            ->where('in_mem_id', $mem_id)
            ->whereIn('category', CoinService::AD_ARR)
            ->order('create_time', 'desc')
            ->limit(($page-1)*$pageSize, $pageSize)
            ->select();

        $logsList = array();
        // 时间 数量 (任务/扫码)
        foreach($logs as $key => $val){
            $logsList[] = array(
                'category' => $val['category'],
                'categoryName' => $this->coinService->getCategoryName($val['category']),
                'coin'=> $val['coin'],
                'createDate'=>date('Y-m-d H:i:s', $val['create_time']),
            );
        }
        return ApiResponse::success($logsList, '操作成功', 0);
    }
    
    // 豆子赠送接收记录列表
    public function listGiveCoin(Request $request)
    {
        //$appid = $request->header('X-Client-Appid', '');
        $page = $request->param('page', 1);
        $pageSize = $request->param('pageSize', 20);

        $memSession = $this->sessionService->getSessionByMemberLogin();
        if (!$memSession) {
            return ApiResponse::error('未登录', 30001);
        }
        $mem = $this->memberService->getByMemID($memSession['mem_id']);
        if (!$mem) {
            return ApiResponse::error('登录账号信息不存在', 30001);
        }
        $mem_id = $mem['mem_id'];

        $logs = Db::table('msm_ms_coin_record')
            ->where(function($query) use ($mem_id) {
                $query->where(function ($query) use ($mem_id) {
                    $query->where('out_mem_id', $mem_id)
                        ->whereIn('category', CoinService::CATEGORY_REDUCE_GIFT_COIN);
                })
                    ->whereOr(function ($query) use ($mem_id) {
                        $query->where('in_mem_id', $mem_id)
                            ->whereIn('category', CoinService::CATEGORY_ADD_GIFT_COIN);
                    });
            })
            ->order('create_time', 'desc')
            ->limit(($page-1)*$pageSize, $pageSize)
            ->select();

        $mem_ids = [];
        foreach($logs as $key => $val){
            $mem_ids[] = $val['out_mem_id'];
            $mem_ids[] = $val['in_mem_id'];
        }
        $memArr = [];
        if ($mem_ids) {
            $res = Db::table('msm_member')->whereIn('mem_id', $mem_ids)->select();
            if ($res) {
                foreach ($res as $key => $val) {
                    $memArr[$val['mem_id']] = $val['mem_hand'];
                }
            }
        }
        // 时间 数量 我自己手机号  别人手机号
        $logsList = array();
        foreach($logs as $key => $val){
            $logsList[] = array(
                'category' => $val['category'],
                'categoryName' => CoinService::CATEGORY_ARR[$val['category']] ?? '',
                'coin'=> $val['coin'],
                'createDate'=> date('Y-m-d H:i:s', $val['create_time']),
                'mobile'=> ($val['out_mem_id'] == $mem['mem_id'] ? ($memArr[$val['in_mem_id']] ?? '') : ($memArr[$val['out_mem_id']] ?? '')),
            );
        }
        return ApiResponse::success($logsList, '操作成功', 0);
    }
    
    // 豆子转积分赠送接收记录列表
    public function listGiveCoinToPoint(Request $request)
    {
        //$appid = $request->header('X-Client-Appid', '');
        $page = $request->param('page', 1);
        $pageSize = $request->param('pageSize', 20);

        $memSession = $this->sessionService->getSessionByMemberLogin();
        if (!$memSession) {
            return ApiResponse::error('未登录', 30001);
        }
        $mem = $this->memberService->getByMemID($memSession['mem_id']);
        if (!$mem) {
            return ApiResponse::error('登录账号信息不存在', 30001);
        }
        $mem_id = $mem['mem_id'];

        $logs = Db::table('msm_ms_point_record')
            ->where(function($query) use ($mem_id) {
                $query->where(function ($query) use ($mem_id) {
                    $query->where('out_mem_id', $mem_id)
                        ->whereIn('category', PointService::CATEGORY_ADD_GIFT_COIN_POINT);
                })
                    ->whereOr(function ($query) use ($mem_id) {
                        $query->where('in_mem_id', $mem_id)
                            ->whereIn('category', PointService::CATEGORY_ADD_GIFT_COIN_POINT);
                    });
            })
            ->order('create_time', 'desc')
            ->limit(($page-1)*$pageSize, $pageSize)
            ->select();

        $mem_ids = [];
        foreach($logs as $key => $val){
            $mem_ids[] = $val['out_mem_id'];
            $mem_ids[] = $val['in_mem_id'];
        }
        $memArr = [];
        if ($mem_ids) {
            $res = Db::table('msm_member')->whereIn('mem_id', $mem_ids)->select();
            if ($res) {
                foreach ($res as $key => $val) {
                    $memArr[$val['mem_id']] = $val['mem_hand'];
                }
            }
        }
        $logsList = array();
        // 时间 豆子数量 积分数量 我自己手机号  别人手机号
        foreach($logs as $key => $val){
            $logsList[] = array(
                'category' => $val['category'],
                'categoryName' => CoinService::CATEGORY_ARR[$val['category']] ?? '',
                'coin'=> $val['coin'],
                'point'=> $val['point'],
                'createDate'=> date('Y-m-d H:i:s', $val['create_time']),
                'mobile'=> ($val['out_mem_id'] == $mem['mem_id'] ? ($memArr[$val['in_mem_id']] ?? '') : ($memArr[$val['out_mem_id']] ?? '')),
            );
        }
        return ApiResponse::success($logsList, '操作成功', 0);
    }

    public function callbackRequest(Request $request)
    {
        $logData = json_encode($_REQUEST, JSON_UNESCAPED_UNICODE);
        $this->trackLogService->insertLog('app-callback', $logData);
        
        $callbackToken = $request->param('callbackToken', '');
        $adpid = $request->param('adpid', '');
        $trans_id = $request->param('trans_id', '');
        $user_id = $request->param('user_id', '');
        $extra = $request->param('extra', '');
        $sign = $request->param('sign', '');
        if ($callbackToken != 'abc89f0c7c7f4c8b9a8c7f4c8b9a8c7f4' || !$trans_id) {
            return json_encode(['isValid' => false]);
        }
        $res = $extra ? explode('||', $extra) : [];
        $log = array(
            'title' => 'app-callback',
            'content' => $logData,
            'order_no' => $res[0] ?? '',
            'user_id' => $user_id,
            'extra' => $extra,
            'adpid' => $adpid,
            'trans_id' => $trans_id,
            'sign' => $sign,
            'create_time' => time(),
        );
        $id = Db::table('msm_ms_callback_log')->insertGetId($log);
        return json_encode(['isValid' => true]);
    }

    public function callbackResult(Request $request)
    {
        $adpid = $request->param('adpid', '');
        $user_id = $request->param('user_id', '');
        $extra = $request->param('extra', '');
        if (!$adpid) {
            return ApiResponse::error('广告加载错误', 401);
        }
        if (!$extra) {
            return ApiResponse::error('广告参数加载错误', 401);
        }
        
        $res = Db::table('msm_ms_callback_log')
            ->where('extra', $extra)
            ->find();
        if (!$res) {
            return ApiResponse::error('广告回调结果未获取到', 30002);
        }

        if ($res['result_time'] > 0) {
            return ApiResponse::error('广告已获取过结果', 401);
        }
        $secretArr  = [
            '1519886465' => '0bd012eaa8f4faa5cc63d73eeceda2b68dc13bcc620037c03f63a00e66d1e663',
            '1564059528' => 'dea5d694e8e76aaf8ded946b2c0a5c5399f81195dd55bd275b92932e61397e9f',
            '1405410410' => '8e9d483213d57fccfd7cac4eee96a98417e276c5bd8ab59584f4a416a36a492b',
            '1408846899' => '957736565ba310f824e05f8b117375adf91d3ade4c3586bb14789fbd02e3a2cd',
            '1684539614' => '69b954afbb519a0ea2bee47ff061f6323efa14ecf171fdf9765102adf48e6e42',
            //'1940104310' => '',
            //'1785081359' => '',
            '1661283132' => '5220840405f08e52b458fbb4743102fdeb0053e8155a15245130524a1003c7d0',
            //'1595858154' => '',
        ];
        // 进行签名
        $secret = $secretArr[$res['adpid']] ?? '';
        $newSign = hash('sha256', $secret . ':' . $res['trans_id']);
        if ($newSign != $res['sign']) {
            return ApiResponse::error('验签失败', 401);
        }
        $up = [
            'result_time' => time()
        ];
        Db::table('msm_ms_callback_log')->where('trans_id', $res['trans_id'])->update($up);

        // 成功返回响应
        $return = [
            'order_no' => $res['order_no']
        ];
        return ApiResponse::success($return, '操作成功', 0);
    }

    // 随机获取app广告
    public function adRandomByApp(Request $request)
    {
        $memSession = $this->sessionService->getSessionByMemberLogin();
        if (!$memSession) {
            return ApiResponse::error('未登录', 30001);
        }
        $mem = $this->memberService->getByMemID($memSession['mem_id']);
        if (!$mem) {
            return ApiResponse::error('登录账号信息不存在', 30001);
        }

        $secretArr  = [
            '1519886465',
            '1564059528',
            '1405410410',
            '1408846899',
            '1684539614',
            //'1940104310' => '',
            //'1785081359' => '',
            '1661283132',
            //'1595858154' => '',
        ];

        // 从以上数组随机一个
        $secret = $secretArr[array_rand($secretArr)];
        // 成功返回响应
        $return = [
            'adpid' => $secret
        ];
        return ApiResponse::success($return, '操作成功', 0);
    }

    // App扫码结果code处理
    public function scanAppCode(Request $request)
    {
        $scan_code = $request->param('scan_code', '');
        
        $memSession = $this->sessionService->getSessionByMemberLogin();
        if (!$memSession) {
            return ApiResponse::error('未登录', 30001);
        }
        $mem = $this->memberService->getByMemID($memSession['mem_id']);
        if (!$mem) {
            return ApiResponse::error('登录账号信息不存在', 30001);
        }
        if (!$scan_code) {
            return ApiResponse::error('扫码未获取到有效信息', 401);
        }
        // scan_code = https://www.ysoo.com/dy/ad.php?q=97K0000A1FE44 将这段地址转换成url和参数
        $url = parse_url($scan_code);
        $scheme = $url['scheme'] ?? '';
        $host = $url['host'] ?? '';
        $path = $url['path'] ?? '';
        $query = $url['query'] ?? '';
        // 将query进行转换成参数数组
        $queryArr = [];
        if ($query) {
            parse_str($query, $queryArr);
        }
        $qrcode_code = $queryArr['q'] ?? '';
        
        if (!($scheme == 'https' && $host == 'www.ysoo.com' && $path == '/dy/ad.php' && $qrcode_code)) {
            return ApiResponse::error('非法请求');
        }
        //$qrcode_code = $scan_code;
        //判断二维码
        $qrcode = Db::table('msm_village_qrcode')->where('qrcode_code', $qrcode_code)->find();
        if(!$qrcode){
            return ApiResponse::error('二维码信息不存在', 401);
        }
        if($qrcode['raffle_state'] == 3){
            return ApiResponse::error('二维码已失效', 401);
        }
        $return = [
            'scan_type' => 'ad',
            'qrcode_code' => $qrcode_code
        ];
        return ApiResponse::success($return, '操作成功', 0);
    }
}
