<?php
namespace app\controller;

use app\BaseController;
use think\facade\Db;

require_once '../vendor/autoload.php';
// // 导入对应产品模块的client
use TencentCloud\Sms\V20210111\SmsClient;
// 导入要请求接口对应的Request类
use TencentCloud\Sms\V20210111\Models\SendSmsRequest;
use TencentCloud\Common\Exception\TencentCloudSDKException;
use TencentCloud\Common\Credential;
// 导入可选配置类
use TencentCloud\Common\Profile\ClientProfile;
use TencentCloud\Common\Profile\HttpProfile;

//验证类
use app\validate\UserValidate;
use think\exception\ValidateException;
use app\controller\WxUser;
use app\common\wechat\WXBizDataCrypt;
use think\facade\Config;
use think\Request;


//接口返回
use app\common\util\ApiResponse;

class Goods extends BaseController{

    public function list(){
        // $shop_code = $_REQUEST['shop_code'];

        $appConfig = Config::get('app');
        $shop_code = $appConfig['shop_code'];

        $shop = Db::table('msm_shop')
        ->where('shop_code', $shop_code)
        ->find();
        // dd($shop_code);
        $goods = Db::table('msm_goods')
        ->where('shop_id', $shop['shop_id'])
        ->where('goods_cseries', 0)
        ->where('goods_view', 'Y')
        ->order('goods_code','desc')
        ->select();
        
        foreach($goods as $key => $val){
            $SELFARR = explode("/",$_SERVER['PHP_SELF']);
            $PHP_SELF = $_SERVER['PHP_SELF'];
            $PHP_SELF = str_replace('/'.$SELFARR[count($SELFARR)-1],"",$PHP_SELF);
            $PHP_SELF = str_replace('/'.$SELFARR[count($SELFARR)-2],"",$PHP_SELF);
            $goods_image = str_replace("..","",$val['goods_image']);

            $share_img = 'http://'.'www.yubinkeji.cn/joinme'.$goods_image;
            $val['share_img'] = $share_img;
            $goods[$key] = $val;

        }


       
        return ApiResponse::success($goods, 'success', 200);
      
    }


    public function info(){

        $goods_id = $_REQUEST['goods_id'];
        $goods = Db::table('msm_goods')
        ->where('goods_id', $goods_id)
        ->find();
        if(!$goods){
            return ApiResponse::success(null, '商品不存在', 0);
        }
        $ImgArr=array();
        if($goods['goods_image'])$ImgArr[] = $goods['goods_image'];
        if($goods['goods_img1'])$ImgArr[] = $goods['goods_img1'];
        if($goods['goods_img2'])$ImgArr[] = $goods['goods_img2'];
        if($goods['goods_img3'])$ImgArr[] = $goods['goods_img3'];
        if($goods['goods_img4'])$ImgArr[] = $goods['goods_img4'];
        $one = Db::table('msm_goods_html')
        ->where('goods_id', $goods_id)
        ->find();
        $goods_explain = str_replace('\\"','"',$one['goods_explain']);
        $goods_explain = str_replace('\"','"',$goods_explain);
        $goods['explain'] = $goods_explain;
        $SELFARR = explode("/",$_SERVER['PHP_SELF']);
        $PHP_SELF = $_SERVER['PHP_SELF'];
        $PHP_SELF = str_replace('/'.$SELFARR[count($SELFARR)-1],"",$PHP_SELF);
        $PHP_SELF = str_replace('/'.$SELFARR[count($SELFARR)-2],"",$PHP_SELF);
        $goods_image = str_replace("..","",$goods['goods_image']);
        $share_img = 'http://'.'www.yubinkeji.cn/joinme'.$goods_image;
        $goods['share_img'] = $share_img;

        return ApiResponse::success($goods, 'success', 200);



        // dd($goods);
        // // dd($shop['shop_id']);
        // $goods = Db::table('msm_goods')
        // ->where('shop_id', $shop['shop_id'])
        // ->where('goods_cseries', 0)
        // ->where('goods_view', 'Y')
        // ->order('goods_code','desc')
        // ->select();
       
        // return ApiResponse::success($goods, 'success', 200);
      
    }

    //购买储值卡列表
    public function vipcardList(){

        $appConfig = Config::get('app');
        $shop_code = $appConfig['shop_code'];

        $shop = Db::table('msm_shop')
        ->where('shop_code', $shop_code)
        ->find();

        $goods = Db::table('msm_goods')
        ->where('shop_id', $shop['shop_id'])
        ->where('goods_cseries', 0)
        ->where('goods_view', 'Y')
        ->where('goods_member','>' ,0)
        ->order('goods_code','desc')
        ->select();

        foreach($goods as $key => $val){
            $SELFARR = explode("/",$_SERVER['PHP_SELF']);
            $PHP_SELF = $_SERVER['PHP_SELF'];
            $PHP_SELF = str_replace('/'.$SELFARR[count($SELFARR)-1],"",$PHP_SELF);
            $PHP_SELF = str_replace('/'.$SELFARR[count($SELFARR)-2],"",$PHP_SELF);
            $goods_image = str_replace("..","",$val['goods_image']);

            $share_img = 'http://'.'www.yubinkeji.cn/joinme'.$goods_image;
            $val['share_img'] = $share_img;
            $goods[$key] = $val;
        }
        return ApiResponse::success($goods, 'success', 200);
    }

    //文件上传
    public function uploadFile(Request $request){

        // 检查是否有文件上传
        if ($_FILES['file']['error'] === 0) {
            // 获取上传文件的临时文件名
            $tmp_name = $_FILES['file']['tmp_name'];
            // 获取上传文件的原始文件名
            $filename = $_FILES['file']['name'];
            // 指定保存文件的目录
            $upload_dir = './uploads/';
            
            // 将上传的文件移动到指定目录下
            if (move_uploaded_file($tmp_name, $upload_dir . $filename)) {
                return ApiResponse::success('/uploads/'.$filename, '文件上传成功', 200);
            } else {
                return ApiResponse::success(null, '文件上传错误', 200);
            }
        } else {
            return ApiResponse::success(null, '文件上传错误', 0);
        }

    }

    //文件删除
    public function delFile(Request $request){

        $file_path = '.'.$_REQUEST['upload_dir'];

        if (file_exists($file_path)) {
            unlink($file_path);
            return ApiResponse::success(null, '文件删除成功', 200);
        } else {
            return ApiResponse::success(null, '文件删除失败', 0);
        }
    }

    // 添加类别
    public function addGoodsClass(Request $request){
        $wxopenid = $request->wxopenid;
        
        $shop = $request->shop;
        $mem = $request->mem;
        $class_name = $_REQUEST['class_name'];
        $class_code = $_REQUEST['class_code'];
        $class_memo = $_REQUEST['class_memo'];
        $shop_id = $shop['shop_id'];
              
        //增加类别
        $data['class_name'] = $class_name; //名称
        $data['class_code'] = $class_code; //编号
        $data['class_memo'] = $class_memo; //备注
        $data['shop_id'] = $shop_id; //店铺
        Db::table('msm_goods_class')->insert($data); //增加订单
        return ApiResponse::success(null, 'success', 200);
    }

    // 修改类别
    public function updateGoodsClass(Request $request){
        $wxopenid = $request->wxopenid;
        $shop = $request->shop;
        $mem = $request->mem;
        $class_name = $_REQUEST['class_name'];
        $class_code = $_REQUEST['class_code'];
        $class_memo = $_REQUEST['class_memo'];
        $shop_id = $shop['shop_id'];

        $class_id = $_REQUEST['class_id'];
                
        //增加类别
        $data['class_name'] = $class_name; //名称
        $data['class_code'] = $class_code; //编号
        $data['class_memo'] = $class_memo; //备注
        // $data['shop_id'] = $shop_id; //店铺
        Db::table('msm_goods_class')
        ->where('class_id', $class_id)
        ->update($data);

        return ApiResponse::success(null, 'success', 200);
    }

    // 类别列表
    public function goodsClassList(Request $request){
        $wxopenid = $request->wxopenid;
        $shop = $request->shop;
        $mem = $request->mem;
        $goods_class = Db::table('msm_goods_class')
        ->field('class_id, class_code, class_name,class_memo')
        ->where('shop_id', $shop['shop_id'])
        ->select();
        return ApiResponse::success($goods_class, 'success', 200);
    }

    // 平台类别列表
    public function goodsSortList(Request $request){
        $wxopenid = $request->wxopenid;
        $shop = $request->shop;
        $mem = $request->mem;

        $sort = Db::table('msm_sort')
        ->field('sort_id,sort_code,sort_name,sort_memo')
        ->select();

        return ApiResponse::success($sort, 'success', 200);
    }

    public function goodsVarietyList(Request $request){
        $wxopenid = $request->wxopenid;
        $shop = $request->shop;
        $mem = $request->mem;
        $goods_class = Db::table('msm_variety')
        ->field('variety_id,variety_code,variety_name')
        ->where('variety_audit', 'Y')
        ->select();

        return ApiResponse::success($goods_class, 'success', 200);
    }

    public function goodsVarietyList1(Request $request){
        $wxopenid = $request->wxopenid;
        $shop = $request->shop;
        $mem = $request->mem;
        $goods_class = Db::table('msm_variety')
        ->field('variety_id,variety_code,variety_name')
        ->where('variety_audit', 'Y')
        ->select();


        return ApiResponse::success($goods_class, 'success', 200);
    }

    //添加商品
    public function goodsSave(){
        $wxopenid = $request->wxopenid;
        $shop = $request->shop;
        $mem = $request->mem;

        $data['class_id'] = $_REQUEST['class_id'];  //商品类别
        $data['sort_id'] = $_REQUEST['sort_id'];  //平台类别
        $data['variety_id'] = $_REQUEST['variety_id'];  //商品品牌
        $data['img1'] = $_REQUEST['img1']; 
        $data['img2'] = $_REQUEST['img2'];
        $data['goods_name'] = $_REQUEST['goods_name'];//商品名称
        $data['goods_code'] = $_REQUEST['goods_code'];//商品编号
        $data['goods_mart'] = $_REQUEST['goods_mart'];//市场价格
        $data['goods_price'] = $_REQUEST['goods_price'];//商品价格
        $data['goods_unit'] = $_REQUEST['goods_unit'];//商品单位

        $data['goods_cseries'] = $_REQUEST['goods_cseries'];//商品属性 商品/礼券套餐 待定
        $data['goods_recommend'] = $_REQUEST['goods_recommend'];//是否推广
        $data['goods_selfdelivery'] = $_REQUEST['goods_selfdelivery'];//自己发货
        $data['goods_mail'] = $_REQUEST['goods_mail'];//是否包邮
        $data['goods_promotion'] = $_REQUEST['goods_promotion'];//拼团商品
        $data['goods_commission'] = $_REQUEST['goods_commission'];//佣金比例
        $data['goods_label1'] = $_REQUEST['goods_label1'];//标签说明
        $data['goods_label2'] = $_REQUEST['goods_label2'];//简介2
        $data['img3'] = $_REQUEST['img3'];//商品封面图
        
        Db::table('msm_goods')->insert($data); //新增商品
        
    

    }

    //上传文件
    public function uplodeFile(Request $request){

        dd($_REQUEST);



    }
  
}
