<?php
namespace app\controller;

use app\BaseController;
use think\facade\Db;

require_once '../vendor/autoload.php';
// // 导入对应产品模块的client
use TencentCloud\Sms\V20210111\SmsClient;
// 导入要请求接口对应的Request类
use TencentCloud\Sms\V20210111\Models\SendSmsRequest;
use TencentCloud\Common\Exception\TencentCloudSDKException;
use TencentCloud\Common\Credential;
// 导入可选配置类
use TencentCloud\Common\Profile\ClientProfile;
use TencentCloud\Common\Profile\HttpProfile;

//验证类
use app\validate\UserValidate;
use think\exception\ValidateException;
use app\controller\WxUser;
use app\common\wechat\WXBizDataCrypt;
use think\facade\Config;

use think\Request;

//接口返回
use app\common\util\ApiResponse;


//支付

use WeChatPay\Builder;
use WeChatPay\Crypto\Rsa;
use WeChatPay\Util\PemUtil;
//签名
use WeChatPay\Formatter;

use think\facade\Log;
//回调
use WeChatPay\Crypto\AesGcm;

class Order extends BaseController{

    public function buy(Request $request){
        $wxopenid = $request->wxopenid;
        
        $shop =$request->shop;
        $mem =$request->mem;
        $data['bill_type'] = 'XCX'; //
        $data['mobile_number'] = $mem['mem_hand']; //用户手机号
        $data['come_time'] = date('Y-m-d H:i:s'); //时间
        $glide = $this->getGlide();
        $data['bill_glide'] = $glide; //订单编号
        $number = $_REQUEST['goods_number'];
        $data['goods_number'] = $number; //商品数量
        $data['from_shop'] = $shop['shop_code']; //商店编号
        $data['from_nick'] = $mem['mem_name']; //用户昵称
        $data['shop_name'] = $shop['shop_name']; //商店名称
        $data['receiver_addr'] = $_REQUEST['receiver_addr']; //地址

        //商品详情
        $goods = Db::table('msm_goods')
        ->where('goods_id', $_REQUEST['goods_id'])
        ->find();

        $money = $goods['goods_price'] * $number;
        $data['goods_money'] = $money; //价格
        $data['shop_id'] = $shop['shop_id']; //商店id
        $data['member_id'] = $mem['mem_id']; //
        $data['bill_payment'] = 'N'; //是否支付
        $data['bill_ordertime'] = date('Y-m-d H:i:s'); //预订时间
        $data['bill_state'] = 1; //支付状态
        $data['bill_pickup'] = $glide; //是否支付
        $data['bill_comp'] = 1; //公司字段
        $data['bill_gprice'] = $money; //商品金额
        $data['bill_xftax'] = 0; //消费税
        $data['receiver_name'] = $_REQUEST['receiver_name']; //收货人
        $data['receiver_hand'] = $_REQUEST['receiver_hand']; //收货人电话
        $data['bill_paymode'] = 'wx';  //微信支付

        $order_id = Db::table('msm_front')->insertGetId($data); //增加订单

        $line = Db::name('msm_front_child')
        ->where('bill_id',$order_id)
        ->max('goods_line');

        $dataChild = array(
            'bill_id'		=>	$order_id,
            'goods_line'	=>	$line,
            'goods_id'		=>	$goods['goods_id'],
            'goods_name'	=>	$goods['goods_name'],
            'goods_code'	=>	$goods['goods_code'],
            'goods_unit'	=>	$goods['goods_unit'],
            'goods_number'	=>	$number,
            'goods_copies'	=>	$number,
            'goods_mart'	=>	$goods['goods_mart'],
            'goods_price'	=>	$goods['goods_price'],
            'goods_sell'	=>	$goods['goods_price'],
            'goods_truesell'	=>	$goods['goods_price'],
        );

        Db::table('msm_front_child')->insert($dataChild); //增加订单
        
        return ApiResponse::success($data, 'success', 200);
      
    }

    public function list(Request $request){

        //0待支付 1已付款 2待收货 3已完成
        //待支付 waitPay  已付款 alreadyPay  待收货 waitReceive 已完成complete
        //1未付款,2未成团(已付款),3已付款,4已发货,5已收货,6已评价,7退单
        $type = $_REQUEST['type'];

        $wxopenid = $request->wxopenid;
        $shop =$request->shop;
        $mem =$request->mem;
        $query = Db::table('msm_front')
        ->field('bill_id, goods_money, bill_status,goods_number,bill_glide')
        ->where('member_id', $mem['mem_id']);
        if($type == 'waitPay'){
            $query->where('bill_status',1);
        }else if($type == 'alreadyPay'){
            $query->whereIn('bill_status',[2,3]);
        }else if($type == 'waitReceive'){
            $query->where('bill_status',4);
        }else{
            $query->whereIn('bill_status',[5,6]);
        }
        $front = $query->select();

        foreach($front as $fkey => $fval){
            $goods = Db::table('msm_front_child')
            ->field('msm_goods.goods_id,msm_goods.goods_name,msm_goods.goods_price,msm_goods.goods_image,msm_goods.goods_buys')
            ->join('msm_goods', 'msm_front_child.goods_id = msm_goods.goods_id')
            ->where('msm_front_child.bill_id', $fval['bill_id'])
            ->select();

            foreach($goods as $key => $val){
                $SELFARR = explode("/",$_SERVER['PHP_SELF']);
                $PHP_SELF = $_SERVER['PHP_SELF'];
                $PHP_SELF = str_replace('/'.$SELFARR[count($SELFARR)-1],"",$PHP_SELF);
                $PHP_SELF = str_replace('/'.$SELFARR[count($SELFARR)-2],"",$PHP_SELF);
                $goods_image = str_replace("..","",$val['goods_image']);
    
                $share_img = 'http://'.'www.yubinkeji.cn/joinme'.$goods_image;
                $val['goods_image'] = $share_img;
                $goods[$key] = $val;
    
            }
            $fval['goods'] = $goods;
            $front[$fkey] = $fval;
        }
        return ApiResponse::success($front, 'success', 200);

    }
    

    public function getGlide($pre='CX'){
        $glide = $pre.date("YmdHis").rand(1000,9999);
        return $glide;
    }

    //预支付
    public function reservePay(Request $request){
        $wxopenid = $request->wxopenid;
        $shop =$request->shop;
        $mem =$request->mem;
        $bill_glide = $_REQUEST['bill_glide'];//订单号
        $pay_type = $_REQUEST['pay_type'];//支付方式

        if($pay_type == 'wechat'){

        }
        
        $front = Db::table('msm_front')
        ->where('bill_glide', $bill_glide)
        ->find();

        $res = $this->pay('水业商品',$bill_glide,$front['goods_money']*100,$wxopenid['openid']);
        $file = './pay.log';
        // $params ='请求体';
        file_put_contents($file, json_encode($res) . PHP_EOL, FILE_APPEND);
        return ApiResponse::success($res, 'success', 200);

    }


    //description商品简介 out_trade_no订单编号 
    public function pay($description,$out_trade_no,$total,$openid){
        // 设置参数

        // 商户号
        $merchantId = '1665476593';
        // 从本地文件中加载「商户API私钥」，「商户API私钥」会用来生成请求的签名
        // $merchantPrivateKeyFilePath = 'file:///path/to/merchant/apiclient_key.pem';
        $merchantPrivateKeyFilePath = 'file://'. __DIR__.'/pem/apiclient_key.pem';
        $merchantPrivateKeyInstance = Rsa::from($merchantPrivateKeyFilePath, Rsa::KEY_TYPE_PRIVATE);
        // 「商户API证书」的「证书序列号」
        $merchantCertificateSerial = '3D2102CA9F9F8ED84B07869297FEC603984BA5BE';

        // 从本地文件中加载「微信支付平台证书」，用来验证微信支付应答的签名
        // $platformCertificateFilePath = 'file:///path/to/wechatpay/cert.pem';
        $platformCertificateFilePath = 'file://'. __DIR__.'/pem/wechatpay.pem';
        $platformPublicKeyInstance = Rsa::from($platformCertificateFilePath, Rsa::KEY_TYPE_PUBLIC);

        // 从「微信支付平台证书」中获取「证书序列号」
        $platformCertificateSerial = PemUtil::parseCertificateSerialNo($platformCertificateFilePath);
        
        // 构造一个 APIv3 客户端实例
        $instance = Builder::factory([
            'mchid'      => $merchantId,
            'serial'     => $merchantCertificateSerial,
            'privateKey' => $merchantPrivateKeyInstance,
            'certs'      => [
                $platformCertificateSerial => $platformPublicKeyInstance,
            ],
        ]);

        $resp = $instance
        ->chain('/v3/pay/transactions/jsapi')
        ->post(['json' => [
            'appid'        => 'wxf531f94f2626c28d',
            'mchid'        => $merchantId,
            'description'  => $description,
            'out_trade_no' => $out_trade_no,
            'notify_url'   => 'https://www.yubinkeji.cn/msmsy/public/index.php/api/payNotify',
            'amount'       => [
                'total'    => $total,
                'currency' => 'CNY'
            ],
            'payer'       => [
                'openid'    => $openid
            ],

        ]]);

        $res = $resp->getBody();


        $data = json_decode($res, true);
        // 检查是否成功解析 JSON 字符串
        if ($data !== null) {
            // 获取 prepay_id
            if (isset($data['prepay_id'])) {
                $prepay_id = $data['prepay_id'];
                // echo "prepay_id: $prepay_id";
            } else {
                // echo "JSON 中没有 prepay_id";
            }
        } else {
            // echo "解析 JSON 失败";
        }

        $merchantPrivateKeyFilePath = 'file://'. __DIR__.'/pem/apiclient_key.pem';
        $merchantPrivateKeyInstance = Rsa::from($merchantPrivateKeyFilePath);
        
        $params = [
            'appId'     => 'wxf531f94f2626c28d',
            'timeStamp' => (string)Formatter::timestamp(),
            'nonceStr'  => Formatter::nonce(),
            'package'   => 'prepay_id='.$prepay_id.'',
        ];
        $params += ['paySign' => Rsa::sign(
            Formatter::joinedByLineFeed(...array_values($params)),
            $merchantPrivateKeyInstance
        ), 'signType' => 'RSA'];
        
        // echo json_encode($params);
        return $params;
    }

    public function notify(Request $request){

        $file = './notify.log';
        // //接收
        $params ='请求头';
        file_put_contents($file, $params . PHP_EOL, FILE_APPEND);
        $params =json_encode(request()->header());
        file_put_contents($file, $params . PHP_EOL, FILE_APPEND);

        $params ='请求体';
        file_put_contents($file, $params . PHP_EOL, FILE_APPEND);
        $params =json_encode(request()->param());
        file_put_contents($file, $params . PHP_EOL, FILE_APPEND);

        $heder = json_encode(request()->header());
        $heder = json_decode($heder,true);
        $params ='数组';
        file_put_contents($file, $params . PHP_EOL, FILE_APPEND);
        file_put_contents($file, $heder['wechatpay-signature'] . PHP_EOL, FILE_APPEND);

        $inWechatpaySignature = $heder['wechatpay-signature'];// 请根据实际情况获取
        $inWechatpayTimestamp = $heder['wechatpay-timestamp'];// 请根据实际情况获取
        $inWechatpaySerial = $heder['wechatpay-serial'];// 请根据实际情况获取
        $inWechatpayNonce = $heder['wechatpay-nonce'];// 请根据实际情况获取

        // $inBody = '';// 请根据实际情况获取，例如: file_get_contents('php://input');
        $inBody = json_encode(request()->param());
        $apiv3Key = '6a9edb85af443d73bbdd1fc36315d1e6';// 在商户平台上设置的APIv3密钥
        // 根据通知的平台证书序列号，查询本地平台证书文件，
        // 假定为 `/path/to/wechatpay/inWechatpaySerial.pem`
        // $platformPublicKeyInstance = Rsa::from('file:///path/to/wechatpay/inWechatpaySerial.pem', Rsa::KEY_TYPE_PUBLIC);
        $platformPublicKeyInstance = Rsa::from('file://'. __DIR__.'/pem/wechatpay.pem', Rsa::KEY_TYPE_PUBLIC);

        // 检查通知时间偏移量，允许5分钟之内的偏移
        $timeOffsetStatus = 300 >= abs(Formatter::timestamp() - (int)$inWechatpayTimestamp);
        $verifiedStatus = Rsa::verify(
            // 构造验签名串
            Formatter::joinedByLineFeed($inWechatpayTimestamp, $inWechatpayNonce, $inBody),
            $inWechatpaySignature,
            $platformPublicKeyInstance
        );

        $verifiedStatus = true;
        if ($verifiedStatus) {
        // if ($timeOffsetStatus && $verifiedStatus) {
            // 转换通知的JSON文本消息为PHP Array数组
            $inBodyArray = (array)json_decode($inBody, true);
            // 使用PHP7的数据解构语法，从Array中解构并赋值变量
            ['resource' => [
                'ciphertext'      => $ciphertext,
                'nonce'           => $nonce,
                'associated_data' => $aad
            ]] = $inBodyArray;
            // 加密文本消息解密
            $inBodyResource = AesGcm::decrypt($ciphertext, $apiv3Key, $nonce, $aad);
            // 把解密后的文本转换为PHP Array数组
            $inBodyResourceArray = (array)json_decode($inBodyResource, true);
            
            //下面处理逻辑
            file_put_contents($file, '数据体数组' . PHP_EOL, FILE_APPEND);
            file_put_contents($file, $inBodyResourceArray['trade_state'] . PHP_EOL, FILE_APPEND);
            if($inBodyResourceArray['trade_state'] = 'SUCCESS'){
                $out_trade_no = $inBodyResourceArray['out_trade_no'];
                $transaction_id = $inBodyResourceArray['transaction_id'];
                
                //修改订单状态
                Db::table('msm_front')
                ->where('bill_glide', $out_trade_no)
                ->update(array("bill_status"=>3));

                $front = Db::table('msm_front')
                ->where('bill_glide', $out_trade_no)
                ->find();

                //增加支付订单
                $data['pay_code'] = $transaction_id; //付款单号
                $data['pay_origin'] = $transaction_id; //原始单号
                $data['pay_glide'] = $front['bill_glide']; //订单流水号 front订单号
                $data['pay_mem'] = $front['member_id']; //是否支付
                $data['pay_time'] = date('Y-m-d H:i:s'); //支付时间
                $data['pay_ordermoney'] = $front['goods_money']; //订单金额
                // $data['bill_comp'] = $front['bill_comp']; //公司字段
                $data['pay_type'] = '1'; //付款方式
                $data['pay_status'] = 'Y'; //消费税
                $data['pay_payname'] = '小程序微信支付'; //付款账户名称
                $data['pay_paycard'] = '小程序微信支付'; //付款账户
                $data['pay_shop'] = $front['shop_id'];  //销售店家ID
                $data['pay_rshop'] = $front['shop_id'];  //收款店家ID
                $data['pay_comp'] = $front['bill_comp'];  //收款账户
                $data['transaction_id'] = $transaction_id;  //收款账户
                 Db::table('msm_front_pay')->insert($data); //增加订单
            }
        }
        return 'success';
    }



    public function orderCancel(Request $request){


        //0待支付 1已付款 2待收货 3已完成
        //待支付 waitPay  已付款 alreadyPay  待收货 waitReceive 已完成complete
        //1未付款,2未成团(已付款),3已付款,4已发货,5已收货,6已评价,7退单
        $bill_glide = $_REQUEST['bill_glide'];

        $wxopenid = $request->wxopenid;
        $shop =$request->shop;
        $mem =$request->mem;
        $front = Db::table('msm_front')
        ->where('bill_glide', $bill_glide)
        ->where('member_id', $mem['mem_id'])
        ->find();
        if(!$front){
            return ApiResponse::success(null, '取消订单失败', 0);
        }


        Db::table('msm_front_child')
        ->where('bill_id', $front['bill_id'])
        ->delete();

        Db::table('msm_front')
        ->where('bill_id', $front['bill_id'])
        ->delete();

        return ApiResponse::success(null, 'success', 200);
    }

    public function orderReceiving(Request $request){

        //0待支付 1已付款 2待收货 3已完成
        //待支付 waitPay  已付款 alreadyPay  待收货 waitReceive 已完成complete
        //1未付款,2未成团(已付款),3已付款,4已发货,5已收货,6已评价,7退单
        $bill_glide = $_REQUEST['bill_glide'];

        $wxopenid = $request->wxopenid;
        $shop =$request->shop;
        $mem =$request->mem;
        $front = Db::table('msm_front')
        ->where('bill_glide', $bill_glide)
        ->where('member_id', $mem['mem_id'])
        ->where('bill_status', 4)
        ->find();
        if(!$front){
            return ApiResponse::success(null, '确认收货失败', 0);
        }
        
        Db::table('msm_front')
        ->where('bill_id', $front['bill_id'])
        ->update(array('bill_status'=>5));

        
        return ApiResponse::success(null, 'success', 200);

       
    }


    //订单详情
    public function orderInfo(Request $request){

        //0待支付 1已付款 2待收货 3已完成
        //待支付 waitPay  已付款 alreadyPay  待收货 waitReceive 已完成complete
        //1未付款,2未成团(已付款),3已付款,4已发货,5已收货,6已评价,7退单
        $bill_glide = $_REQUEST['bill_glide'];

        $wxopenid = $request->wxopenid;
        $shop =$request->shop;
        $mem =$request->mem;
        $front = Db::table('msm_front')
        ->field('msm_front_child.goods_name,
        msm_front.bill_freight,msm_front.bill_gprice,
        msm_front.bill_glide,msm_front.goods_number,
        msm_front.come_time,msm_front.bill_status,
        msm_front.receiver_name,msm_front.receiver_hand,msm_front.receiver_addr,
        msm_front.bill_paymode,msm_front_child.goods_price')
        ->join('msm_front_child',' msm_front.bill_id = msm_front_child.bill_id')
        ->where('msm_front.bill_glide', $bill_glide)
        ->where('msm_front.member_id', $mem['mem_id'])
        // ->where('bill_status', 4)
        ->find();
        if($front){
            return ApiResponse::success($front, 'success', 200);
        }
        return ApiResponse::success(null, '获取失败', 0);
       
    }
    
  
    //支付方式
    public function payType(Request $request){
        $wxopenid = $request->wxopenid;
        $shop = $request->shop;
        $mem = $request->mem;
        $data['wx'] = array();

        //member商店
        $member_shop = Db::table('zxsy_member.member_shop')
        ->where('shop_code', $shop['shop_code'])
        ->find();
        //是否有会员卡
        $mycard = Db::table('zxsy_member.member_list')
        ->field('member_id,member_save,member_type,member_discount')
        ->where('member_hand', $mem['mem_hand'])
        ->where('member_shop', $member_shop['shop_id'])
        ->select();
        if($mycard){
            foreach($mycard as $key => $val){
                $mtype = Db::table('zxsy_member.member_mtype')
                ->field('mtype_name')
                // ->where('bill_glide', $bill_glide)
                ->where('mtype_id', $val['member_type'])
                ->find();

                $val['mtype_name'] = $mtype['mtype_name'];
                $mycard[$key] = $val;
            }


            $data['card'] = $mycard;
        }
        return ApiResponse::success($data, 'success', 200);

    }

    //修改支付方式
    public function updatePayType(Request $request){
        $wxopenid = $request->wxopenid;
        $shop = $request->shop;
        $mem = $request->mem;

        $member_id = $_REQUEST['member_id'];    //会员卡号
        $bill_glide = $_REQUEST['bill_glide'];  //订单号
        $pay_type = $_REQUEST['pay_type'];  //支付方式

        Db::table('zxsy_member.member_list')
        ->field('member_id,member_save,member_type,member_discount')
        ->where('member_hand', $mem['mem_hand'])
        ->select();

        return ApiResponse::success($data, 'success', 200);

    }


}
