<?php
namespace app\controller;

use app\BaseController;
use think\facade\Db;

require_once '../vendor/autoload.php';
// // 导入对应产品模块的client
use TencentCloud\Sms\V20210111\SmsClient;
// 导入要请求接口对应的Request类
use TencentCloud\Sms\V20210111\Models\SendSmsRequest;
use TencentCloud\Common\Exception\TencentCloudSDKException;
use TencentCloud\Common\Credential;
// 导入可选配置类
use TencentCloud\Common\Profile\ClientProfile;
use TencentCloud\Common\Profile\HttpProfile;

//验证类
use app\validate\UserValidate;
use think\exception\ValidateException;
use app\controller\WxUser;
use app\common\wechat\WXBizDataCrypt;
use think\facade\Config;


//接口返回
use app\common\util\ApiResponse;

class SignIn extends BaseController{

    public function list(){
        $token = $_REQUEST['token'];
        $month =  $_REQUEST['month']; //月份
        $year =  $_REQUEST['year']; //年份
        // $year = date('Y'); // 获取当前年份
        // 获取特定月份的第一天和最后一天
        $firstDayOfMonth = date('Y-m-01', strtotime("$year-$month-01"));
        $lastDayOfMonth = date('Y-m-t', strtotime("$year-$month-01"));
        $wxopenid = Db::table('msm_wxopenid')
            ->where('token', $token)
            ->where('tokentime','>', time())
            ->find();
        // dd($wxopenid);
        $signInList = Db::table('msm_sign_in')
        
        ->where('mem_id', $wxopenid['mem_id'])
        ->where('date','>=', $firstDayOfMonth)
        ->where('date','<=', $lastDayOfMonth)
        // ->column('date');
        ->select();
        // foreach($signInList as $key => $val){
            // $val['fee_return'] = 0; //0未返还 1已返还
            // $val['fee'] = $key;
            // $signInList[$key] = $val;
        // }

        //连续签到天数
        $allSignInList = Db::table('msm_sign_in')
        ->where('mem_id', $wxopenid['mem_id'])
        ->order('date','desc')
        ->select();
        
        $day = date('Y-m-d');
        $continuous = 0;    //连续签到天数
        foreach ($allSignInList as $ak => $av) {
            if($day != ""){
                //对比前一天
                if($day == $av['date']){
                    $continuous = $continuous +1;
                }else{
                    break;
                }
            }
            $day = date('Y-m-d', strtotime($av['date'] . ' -1 day'));
        }

        //是否已签到
        $today = date('Y-m-d');
        $todaySignIn = Db::table('msm_sign_in')
        ->where('mem_id', $wxopenid['mem_id'])
        ->where('date', $today)
        ->find();
        if($todaySignIn){
            $todaySignIn = 1;
        }else{
            $todaySignIn = 0;
        }
        $complete_fee = Db::table('msm_sign_in')
        ->where('mem_id', $wxopenid['mem_id'])
        ->where('fee_return',1)
        ->sum('fee');
        $wait_fee = Db::table('msm_sign_in')
        ->where('mem_id', $wxopenid['mem_id'])
        ->where('fee_return',0)
        ->sum('fee');

        $data['list'] = $signInList;//签到列表
        $data['continuous'] = $continuous; //连续签到天数
        $data['is_sign_in'] = $todaySignIn; //1 已签到 0未签到
        $data['complete_fee'] = $complete_fee; //已返还
        $data['wait_fee'] = $wait_fee; //待返还
        return ApiResponse::success($data, 'success', 200);
      
    }

    public function signIn(){

        // $tourist_type = 2;  //1固定金额 2百分比 剩余返还余额*百分比
        // $tourist_return = 0.001;//0.01代表1%
        
        $appConfig = Config::get('agent');
        $tourist_type = $appConfig['tourist_type'];
        $tourist_return = $appConfig['tourist_return'];

        
        $today = date('Y-m-d');
        $token = $_REQUEST['token'];
        $wxopenid = Db::table('msm_wxopenid')
        ->where('token', $token)
        ->where('tokentime','>', time())   
        ->find();
        // dd($wxopenid);
        // $wxopenid = $wxopenid;
        // 查看是否有返还单
        $mem_id = $wxopenid['mem_id'];
        $shop_id = $wxopenid['shop_id'];


        $todaySignIn = Db::table('msm_sign_in')
        ->where('mem_id', $wxopenid['mem_id'])
        ->where('date', $today)
        ->find();
        if($todaySignIn){
            return ApiResponse::success(null, '今日已签到', -1);
        }

        $insert = array(
           'mem_id'=> $wxopenid['mem_id'],
           'date'=> $today,
        );


        $sign_id = Db::table('msm_sign_in')->insertGetId($insert);

        if($sign_id){
            //如果有金额，增加返还单
            $rebate_list = Db::table('msm_rebate_list')
            ->where('mem_id', $wxopenid['mem_id'])
            ->where('is_over', 'N')
            ->find();
    
            if($rebate_list){
    
                if($tourist_type == 2){
                    //按照百分比取可返还金额
                    $tourist_return_new = $rebate_list['wait_fee'] * $tourist_return;
                }else{
                    $tourist_return_new = $tourist_return;
                }
    
                $shop = Db::table('msm_shop')
                ->where('shop_id', $shop_id)
                ->find();
                // dd($shop);
                $today_total = $shop['today_total'];

                if($today_total > $tourist_return_new){
                    $fee_arr = array(
                        'fee'		=>$tourist_return_new,
                        'creat_time'		=> date('Y-m-d H:i:s'),
                        'mem_name'		=> $rebate_list['mem_name'],
                        'mem_hand'		=> $rebate_list['mem_hand'],
                        'mem_grade'		=> $rebate_list['mem_grade'],
                        'mem_shop'		=> $rebate_list['mem_shop'],
                        'mem_comp'		=> $rebate_list['mem_comp'],
                        'mem_id'		=> $rebate_list['mem_id'],
                        'status'		=> 0,
                        'rebate_id'		=> $rebate_list['rebate_id'],
                        'return_lv'		=> $rebate_list['return_lv'], //返还星级
                        'fee_total'		=> $rebate_list['fee_total'],
                        'wait_fee'		=> $rebate_list['wait_fee'],
                        'already_fee'		=> $rebate_list['already_fee'],
                        'is_appoint'		=> 3, //是否指定 1指定 2平均 3级别
                    );
        
                    // $res = Db::table('msm_rebate_toexamine_signin')->insert($fee_arr);
                    $rebate_id = Db::table('msm_rebate_toexamine_signin')->insertGetId($fee_arr);
                    $up = array(
                        'fee'=> $tourist_return_new,
                        'rebate_id'=> $rebate_id,
                    );
                    Db::table('msm_sign_in')->where('id', $sign_id)->update($up);


                }
            }

            return ApiResponse::success(null, '签到成功', 200);
        }else{
            return ApiResponse::success(null, '签到失败', -1);
        }

    }

  
}
