<?php
namespace app\controller;

use app\BaseController;
use think\facade\Db;

require_once '../vendor/autoload.php';
// // 导入对应产品模块的client
use TencentCloud\Sms\V20210111\SmsClient;
// 导入要请求接口对应的Request类
use TencentCloud\Sms\V20210111\Models\SendSmsRequest;
use TencentCloud\Common\Exception\TencentCloudSDKException;
use TencentCloud\Common\Credential;
// 导入可选配置类
use TencentCloud\Common\Profile\ClientProfile;
use TencentCloud\Common\Profile\HttpProfile;

//验证类
use app\validate\UserValidate;
use think\exception\ValidateException;
use app\controller\WxUser;
use app\common\wechat\WXBizDataCrypt;
use think\facade\Config;

//接口返回
use app\common\util\ApiResponse;

use think\Request;

class User extends BaseController{

    public function test(){

        $appConfig = Config::get('agent');
        dd($appConfig['tourist_type']);

        phpinfo();
        dd(11);
    }

    public function info(){
        $request = $_REQUEST;
        $token = $request['token'];
        $wxopenid = Db::table('msm_wxopenid')->where('token', $token)->find();
        $mem_id = $wxopenid['mem_id'];
        $fields = ['mem_id','mem_name','mem_image','mem_sex','mem_currency','mem_hand'];
        $mem = Db::table('msm_member')
        ->field($fields)
        ->where('mem_id', $mem_id)->find();
        //零钱余额
        $member_fee = Db::table('msm_member_fee')->where('mem_id', $mem_id)->find();
        if($member_fee){
            $mem['fee_leave'] = $member_fee['fee_leave'];
        }else{
            $mem['fee_leave'] = 0;
        }

        return ApiResponse::success($mem, 'success', '200');
    }


    public function login(){

        //查询店铺id
        //通过微信
        $request = $_REQUEST;
        try {
            validate(UserValidate::class)->check($request);
        } catch (ValidateException $e) {
            // 验证失败 输出错误信息
            return ApiResponse::error(null, $e->getError(), -1);
        }
        
        $appConfig = Config::get('app');
        $shop_code = $appConfig['shop_code'];

        $wxapp_id = $request['wxapp_id'];
        $wxapp = Db::table('msm_wxapp')
        ->where('wxapp_mchid', $shop_code)
        ->where('wxapp_id', $wxapp_id)
        ->find();
        $shop = Db::table('msm_shop')->where('shop_id', $wxapp['wxapp_shop'])->find();
        $shop_id = $shop['shop_id'];
        //登录
        $encryptedData = $_REQUEST['encrypted_data'];
		$iv = $_REQUEST['iv'];
		// $sharemem = $_REQUEST['sharemem'];
		// $shareuser = $_REQUEST['shareuser'];

		// if($sharemem && $shareuser){
		// 	$shareman=$ass->one('wxopenid','','mem_id="'.$sharemem.'" and id="'.$shareuser.'"');
		// }


		// // 微信登录 获取session_key
		$session = $this->wxlogin($_REQUEST['code'],$wxapp, $iv, $encryptedData);
        if(isset($session['errcode'])){

            return ApiResponse::success(null, $session['errmsg'], -1);

        }

        //先写死
        // $session['session_key'] = 'n9WV397x7ca9UX5KuVSGXA==';
        // $session['openid'] = 'on0HI6wbGF__05TShe3Pm3cHg_UU';
        //自动注册用户
        $userInfo = json_decode(htmlspecialchars_decode($_REQUEST['user_info']), true);
        //去掉微信表情符号
        $nickName = preg_replace('/[\xf0-\xf7].{3}/', '', $userInfo['nickName']);
        $gender = $userInfo['gender'];
		$city = $userInfo['city'];
		$province = $userInfo['province'];
		$country = $userInfo['country'];
		$avatarUrl = $userInfo['avatarUrl'];
        $time = date("Y-m-d H:i:s");
		$token=$this->getToken($session['openid'],$wxapp_id);

        //获取到token
        $tokentime = time()+86400 * 7;
		$data=array(
			'nickName'	=> $nickName,
			'gender'	=> $gender,
			'city'		=> $city,
			'province'	=> $province,
			'country'	=> $country,
			'avatarUrl'	=> $avatarUrl,
			'new_time'	=> $time,
			'token'	=> $token,
			'tokentime'	=> $tokentime
		);

        if(Db::table('msm_wxopenid')->where('wxapp_id', $wxapp_id)->where('openid',$session['openid'])->find()){

            if(Db::table('msm_wxopenid')->where('wxapp_id', $wxapp_id)->where('openid',$session['openid'])->update($data)){
                $one = Db::table('msm_wxopenid')->where('wxapp_id', $wxapp_id)->where('openid',$session['openid'])->find();
				$mem_id = $one['mem_id'];
            }
		}else{

            //是否存在相同unionid用户 如果存在就不新增用户
            $mem = Db::table('msm_member')
            ->where('mem_shop', $shop_id)
            ->where('mem_unionid',$session['unionid'])
            ->find();

            if($mem){
                $mem_id = $mem['mem_id'];
                $data['openid'] = $session['openid'];
                $data['unionId'] = $session['unionid'];
                $data['wxapp_id'] = $wxapp_id;
                $data['mem_id'] = $mem_id;
                $data['begin_time'] = $time;
                $data['shop_id'] = $shop['shop_id'];
                $data['comp_id'] = $shop['comp_id'];
                Db::table('msm_wxopenid')->insert($data);
            }else{
                $mdata=array(
                    'mem_name'	=> $data['nickName'],
                    'mem_image'	=> $avatarUrl,
                    'mem_addtime'	=> $time,
                    'mem_city'	=> $city,
                    'mem_sex'	=> $gender==1?'M':'F',
                    'mem_from'	=> 'XCX',
                    'mem_shop'	=> $shop['shop_id'],
                    'mem_comp'	=> $shop['comp_id'],
                    'mem_unionId'	=> $session['unionid'],
                    
                );
                // mem_unionid
                if(Db::table('msm_member')->insert($mdata)){
                    $mem_id = Db::name('msm_member')->getLastInsID();
                    $data['openid'] = $session['openid'];
                    $data['unionId'] = $session['unionid'];
                    $data['wxapp_id'] = $wxapp_id;
                    $data['mem_id'] = $mem_id;
                    $data['begin_time'] = $time;
                    $data['shop_id'] = $shop['shop_id'];
                    $data['comp_id'] = $shop['comp_id'];
                    Db::table('msm_wxopenid')->insert($data);
                }
            }
		}

        if($mem_id){
			$code = 200;
			$msg = 'success';
		}else{
			$code = -1;
			$msg = '登录失败！';
		}

        return ApiResponse::success(array(
            'token'	 => $token,
            'user_id'=> $mem_id,
        ), $msg, $code);
    }

    /**
     * 生成用户认证的token
     * @param $openid
     * @return string
     */
    function getToken($openid,$wxapp_id)
    {
        // 生成一个不会重复的随机字符串
        $rand = rand(1000,9999);
        // 当前时间戳 (精确到毫秒)
        $timeStamp = microtime(true);
        // 自定义一个盐
        $salt = 'token_salt';
        return md5("{$wxapp_id}_{$timeStamp}_{$rand}_{$openid}_{$salt}");
    }

    function wxlogin($code,$wxapp,$iv, $encryptedData)
    {
        // include_once("./includes/wechat/WxUser.php");
        // include_once("./includes/wechat/WxBizDataCrypt.php");
        // 微信登录 (获取session_key)
        $WxUser = new WxUser($wxapp['wxapp_id'], $wxapp['wxapp_secret']);
        if(!$session = $WxUser->sessionKey($code)){
            $msg = $WxUser->getError();
            
        }
        return $session;
    }


    //绑定银行卡
    public function bindBank(Request $request){

        $wxopenid = $request->wxopenid;
        $shop =$request->shop;
        $mem =$request->mem;

        $account = Db::table('msm_account')
        ->where('account_code', $mem['mem_hand'])
        ->where('account_mode', 'receive')
        ->find();


        if($account){

            $res = Db::table('msm_account')
            ->where('account_code', $mem['mem_hand'])
            ->update(array('account_name'=>$_REQUEST['account_name'],'account_bank'=>$_REQUEST['account_bank']));

            if($res){
                return ApiResponse::success(null, 'success', 200);
            }else{
                return ApiResponse::success(null, '绑定银行卡失败', 0);
            }
        }


        $data['account_name'] = $_REQUEST['account_name'];
        $data['account_bank'] = $_REQUEST['account_bank'];
        $data['account_code'] = $mem['mem_hand'];
        $data['account_mode'] = 'receive';
        $data['account_comp'] = $mem['mem_comp'];

        $res = Db::table('msm_account')->insert($data); 
        if($res){
            return ApiResponse::success(null, 'success', 200);
        }else{
            return ApiResponse::success(null, '绑定银行卡失败', 0);
        }
        
        


    }

    //绑定银行卡
    public function bindBankInfo(Request $request){
        $wxopenid = $request->wxopenid;
        $shop =$request->shop;
        $mem =$request->mem;


        $account = Db::table('msm_account')
            ->field('account_name,account_bank')
            ->where('account_code', $mem['mem_hand'])
            ->find();

        return ApiResponse::success($account, 'success', 200);

    }


    
    //获取验证码
    public function obtainCode(Request $request){

        $wxopenid = $request->wxopenid;
        $shop =$request->shop;
        $mem =$request->mem;
		$phone = $_REQUEST['phone'];

        $vcode = rand(1000,9999);

        $this->sendCode($phone,$vcode);

        Db::table('msm_verify')
        ->where('mobile_number', $phone)
        ->delete();
        $data['mobile_number'] = $phone;
        $data['verify_code'] = $vcode;
        $data['verify_time'] = date('Y-m-d H:i:s');
        Db::table('msm_verify')->insert($data);


        return ApiResponse::success(null, 'success', 200);

    }

    //发送验证码
    public function sendCode($phone,$vcode){
        $url = 'http://www.yubinkeji.cn:81/msm/public/index.php/smsSend?mobile='.$phone.'&code='.$vcode.'';
        $ch=curl_init(); 
        curl_setopt($ch,CURLOPT_URL,$url); 
        curl_setopt($ch,CURLOPT_RETURNTRANSFER,1); 
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        $res=curl_exec($ch); 
        curl_close($ch); 
        // error_log($response,3,"./apisms2.log");
        return $res;

    }


    //绑定手机号
    public function bindPhone(Request $request){
        $wxopenid = $request->wxopenid;
        $shop =$request->shop;
        $mem =$request->mem;
        $phone = $_REQUEST['phone'];
        $verify = $_REQUEST['verify'];

        $verify = Db::table('msm_verify')
        ->where('mobile_number', $phone)
        ->where('verify_code', $verify)
        ->find();

        if($verify){

            if(date("Y-m-d H:i:s",strtotime(date("Y-m-d H:i:s"))-1800)>$verify){
                return ApiResponse::success(null, '您输入的验证超过30分钟！', 0);
            }

            $phonemsm = Db::table('msm_member')
            ->where('mem_hand', $phone)
            ->where('mem_shop', $mem['mem_shop'])
            ->find();

            if($phonemsm){
                return ApiResponse::success(null, '此手机号已被绑定', 0);
            }

            $data['mem_hand'] = $phone;
            Db::table('msm_member')
            ->where('mem_id', $mem['mem_id'])
            ->update($data);
        }else{
            return ApiResponse::success(null, '验证码不正确', 0);
        }

        return ApiResponse::success(null, 'success', 200);

    }

    //零钱余额
    public function balance(Request $request){

        $wxopenid = $request->wxopenid;
        $shop =$request->shop;
        $mem =$request->mem;

        $fee = Db::table('msm_member_fee')
        ->where('mem_id', $mem['mem_id'])
        ->where('shop_id', $mem['mem_shop'])
        ->find();

        $date['fee'] = 0;
        if($fee){
            $date['fee_leave'] = $fee['fee_leave'];
        }

        $comp = Db::table('msm_company')
        ->where('comp_id', $mem['mem_comp'])
        ->find();

        $date['comp_lowcash'] = 0;
        if($comp){
            $date['comp_lowcash'] = $comp['comp_lowcash'];
        }

        // if($fee['fee_leave'] < $comp['comp_lowcash'] ||  $fee['fee_leave'] == 0){
        //     return ApiResponse::success(null, '零钱余额不足', 0);
        // }

        //实名认证
        $date['real_name'] = 0;
        if($mem['mem_audit'] == 'Y'){
            $date['real_name'] = 1;
        }
        // else{
        //     return ApiResponse::success(null, '未实名认证', 0);
        // }

        $account = Db::table('msm_account')
        ->where('account_code', $mem['mem_hand'])
        ->where('account_mode', 'receive')
        ->find();
        $date['bind_bank'] = 0; //绑定银行卡
        if($account){
            $date['bind_bank'] = 1;
            
        }
        // else{
        //     return ApiResponse::success(null, '未绑定银行卡', 0);
        // }

        //代理级别
        $date['mem_grade'] = $mem['mem_grade'];
        // if($mem['mem_grade'] < 1){
        //     return ApiResponse::success(null, '代理级别不够', 0);
        // }

        return ApiResponse::success($date, 'success', 200);

    }

    //储值余额
    public function stored(Request $request){

        $wxopenid = $request->wxopenid;
        $shop =$request->shop;
        $mem =$request->mem;
        //查询membershop
        $member_shop = Db::table('zxsy_member.member_shop')
        ->where('shop_code', $shop['shop_code'])
        ->find();

        //储值卡余额总和
        $member_save = Db::table('zxsy_member.member_list')
        ->where('member_hand', $mem['mem_hand'])
        ->where('member_shop', $member_shop['shop_id'])
        ->where('member_audit', 'Y')
        ->sum('member_save');
        $date['member_save'] = 0;
        if($member_save){
            $date['member_save'] = $member_save;
        }

        return ApiResponse::success($date, 'success', 200);

    }

    //申请提现
    public function applicationWithdrawal(Request $request){


    }

    //我的会员卡
    public function myVipcard(Request $request){

        
        $wxopenid = $request->wxopenid;
        $shop =$request->shop;
        $mem =$request->mem;
        //查询membershop
        $member_shop = Db::table('zxsy_member.member_shop')
        ->where('shop_code', $shop['shop_code'])
        ->find();
        // dd($member_shop['shop_id']);

        $mycard = Db::table('zxsy_member.member_list')
        ->field('member_id,member_save,member_type')
        ->where('member_hand', $mem['mem_hand'])
        ->where('member_shop', $member_shop['shop_id'])
        ->where('member_audit', 'Y')
        ->select();

        foreach($mycard as $key => $val){
            $member_type = Db::table('zxsy_member.member_mtype')
            ->where('mtype_id', $val['member_type'])
            ->where('mtype_shop', $member_shop['shop_id'])
            ->find();
            $val['mtype_name'] = $member_type['mtype_name'];
            $mycard[$key] = $val;
        }

        return ApiResponse::success($mycard, 'success', 200);
    }

    //零钱明细
    public function changeRecord(Request $request){
                
        $wxopenid = $request->wxopenid;
        $shop =$request->shop;
        $mem =$request->mem;

        $feechild = Db::table('msm_member_feechild')
        // ->field('member_id,member_save,member_type')
        ->where('fee_mem', $mem['mem_id'])
        ->where('fee_shop', $shop['shop_id'])
        // ->where('member_audit', 'Y')
        ->select();
        $mode=array('TC'=>'提成','TX'=>'提现','XF'=>'消费','FX'=>'分销');
        foreach($feechild as $key => $val){
            $val['fee_mode'] = $mode[$val['fee_mode']];
            $feechild[$key] = $val;
         }

         return ApiResponse::success($feechild, 'success', 200);

    }



}
