<?php
namespace app\controller;

use app\BaseController;
use think\facade\Db;

require_once '../vendor/autoload.php';


class WxUser extends BaseController{

	private $appid;
	private $appSecret;
	private $error;
    /**
     * 构造方法
     * WxUser constructor.
     * @param $appId
     * @param $appSecret
     */
    public function __construct($appId, $appSecret)
    {
        $this->appId = $appId;
        $this->appSecret = $appSecret;
    }

	/**
     * 获取session_key
     * @param $code
     * @return array|mixed
     */
    public function sessionKey($code)
    {
        /**
         * code 换取 session_key
         * ​这是一个 HTTPS 接口，开发者服务器使用登录凭证 code 获取 session_key 和 openid。
         * 其中 session_key 是对用户数据进行加密签名的密钥。为了自身应用安全，session_key 不应该在网络上传输。
         */
        $url = 'https://api.weixin.qq.com/sns/jscode2session';


        // $result = json_decode(curl($url, array(
        //     'appid' => $this->appId,
        //     'secret' => $this->appSecret,
        //     'grant_type' => 'authorization_code',
        //     'js_code' => $code
        // )), true);
        // if (isset($result['errcode'])) {
        //     $this->error = $result['errmsg'];
        //     return false;
        // }

		$url = 'https://api.weixin.qq.com/sns/jscode2session';
		$params = 		array(
			'appid' => $this->appId,
			'secret' => $this->appSecret,
			'grant_type' => 'authorization_code',
			'js_code' => $code);
			
		// dd($params);
		$url .= '?' . http_build_query($params); // 将参数拼接到 URL 中
		
		// dd($url);
		// dd($url);
		// dd(11);
		// dd($url);
		// 初始化 CURL
		$ch = curl_init();
		// 设置 CURL 选项
		curl_setopt($ch, CURLOPT_URL, $url);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		// 执行 CURL 请求
		$response = curl_exec($ch);
		// 检查请求是否成功
		if ($response === false) {
			// 请求失败时的处理
			$error = curl_error($ch);
			// 处理错误信息
			// ...
		} else {
			// 请求成功时的处理
			// 处理响应数据
			// ...
		}
		// 关闭 CURL 资源
		curl_close($ch);
		// 返回响应或其他处理结果
		// dd($response);
		return json_decode($response,true);

        // return $result;
    }

    public function getError()
    {
        return $this->error;
    }

}