<?php

namespace app\middleware;

use think\response;
class Cors
{
    public function handle($request, \Closure $next)
    {
        //
        
        // 如果是 OPTIONS 预检请求，直接返回 204 并带上 CORS 头部
        if ($request->isOptions()) {
            $origin = $request->header('origin', '*');

            $allowedOrigins = [
                'http://vue.goodjobs.demo:5173',
                // 可以添加更多允许的域名
            ];
            $headers = [
                'Access-Control-Allow-Origin'      => in_array($origin, $allowedOrigins) ? $origin : '*',
                'Access-Control-Allow-Credentials' => 'true',
                'Access-Control-Allow-Methods'     => 'GET, POST, OPTIONS, PUT, DELETE, PATCH',
                'Access-Control-Allow-Headers'     => 'Content-Type, Authorization, Accept, X-Client-Appid, X-Client-Platform, X-Requested-With',
                'Access-Control-Max-Age'           => '86400',
            ];

            return response('', 204)->header($headers);
        }
        // 设置允许的请求来源，* 表示允许所有来源
        //header("Access-Control-Allow-Origin:http://vue.goodjobs.demo:5173");

        // 如果需要限制特定域名，可以这样设置：
        // header("Access-Control-Allow-Origin: https://yourdomain.com");


        //header("Access-Control-Allow-Origin: " . ($_SERVER['HTTP_ORIGIN'] ?? '*'));

        // 白名单域名（Vue Web 前端）
        $allowedOrigins = [
            'http://vue.goodjobs.demo:5173',
            'http://localhost:8081',
        ];

        // 获取当前请求的 Origin
        $origin = $_SERVER['HTTP_ORIGIN'] ?? '';

        if (!empty($origin)) {
            // 判断是否在白名单中
            if (in_array($origin, $allowedOrigins)) {
                //exit('Forbidden' . json_encode($origin));
                header("Access-Control-Allow-Origin: " . $origin);
            } else {
                // 不在白名单中，可以选择拒绝访问或直接不设置该 Header
                // header("HTTP/1.1 403 Forbidden");
                //exit('ABC:' . json_encode($origin));
            }
        }
        header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS");
        header("Access-Control-Allow-Headers: Content-Type, X-Client-Appid, X-Client-Platform, Authorization, X-Requested-With");
        header("Access-Control-Allow-Credentials: true"); // 关键
        // 如果是预检请求(preflight request)，直接返回
        if ($request->method(true) == 'OPTIONS') {
            exit;
        }

        return $next($request);
    }
}