<?php

namespace app\middleware;

class Cors
{
    public function handle($request, \Closure $next)
    {
        // 设置允许的请求来源，* 表示允许所有来源
        header("Access-Control-Allow-Origin: *");

        // 如果需要限制特定域名，可以这样设置：
        // header("Access-Control-Allow-Origin: https://yourdomain.com");

        // 允许的请求方法
        header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS");

        // 允许的请求头
        header("Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With");

        // 如果是预检请求(preflight request)，直接返回
        if ($request->method(true) == 'OPTIONS') {
            exit;
        }

        return $next($request);
    }
}