<?php
namespace app\model;
use think\facade\Db;

class Point
{
    public function getDyShopOne($appid)
    {
        $shop = Db::table('msm_shop')
            ->where('shop_dyappid', $appid)
            ->find();
        return $shop ?: [];
    }
    
    public function getMemberCollect($shop_id, $openid, $unionid)
    {
        $collect = Db::table('msm_member_collect')
            ->where('mem_wxid', $openid)
            ->where('mem_unionId', $unionid)
            ->where('shop_id', $shop_id)
            ->find();
        return $collect ?: [];
    }
    
    public function getMemberCollectByShopID($shop_id, $mem_id)
    {
        $collect = Db::table('msm_member_collect')
            ->where('mem_id', $mem_id)
            ->where('shop_id', $shop_id)
            ->find();
        return $collect ?: [];
    }
    
    public function getMember($mem_id) {
        $member = Db::table('msm_member')
            ->where('mem_id', $mem_id)
            ->find();
        return $member ?: [];
    }
    
    public function getMemberByMobile($mobile) {
        $member = Db::table('msm_member')
            ->where('mem_hand', $mobile)
            ->find();
        return $member ?: [];
    }
    
    public function insertMemberFee($param)
    {
        $mobile = $param['mobile'] ?? '';
        if (!$mobile) {
            throw new \Exception('会员手机号码不能为空');
        }
        $opMem = $this->getMemberByMobile($mobile);
        if (!$opMem) {
            throw new \Exception('转入会员不存在');
        }
        $op_mem_id = $opMem['mem_id'];
        $opCollect = $this->getMemberCollectByShopID($param['shop_id'], $op_mem_id);
        if (!$opCollect) {
            throw new \Exception('关注信息不存在');
        }
        // 转出
        $mscore = Db::table('msm_score')->where('score_mem', $param['mem_id'])->find();
        if (!$mscore) {
            throw new \Exception('没有要转出的积分');
        }
        if ($mscore['score_points'] < $param['log_score']) {
            throw new \Exception('会员积分不足');
        }
        $score_points = $mscore['score_points'] - $param['log_score'];
        $log = array(
            'log_type'=> 1,
            'out_mem_id'=> $param['mem_id'],
            'out_shop_id'=> $param['shop_id'],
            'out_openid'=> $param['openid'],
            'out_unionid'=> $param['unionid'],

            'in_mobile'=> $mobile,
            'in_mem_id'=> $opCollect['mem_id'],
            'in_shop_id'=> $opCollect['shop_id'],
            'in_openid'=> $opCollect['mem_wxid'],
            'in_unionid'=> $opCollect['mem_unionId'],
            
            'log_value'=> -$param['log_value'],
            'log_score'=> -$param['log_score'],
            'new_score'=> $score_points,
            'log_time'=> date('Y-m-d H:i:s'),
        );

        $add_id = Db::table('msm_point_log')->insertGetId($log);
        if (!$add_id) {
            throw new \Exception('积分记录失败');
        }
        // 
        $score_data = array(
            'score_points'=>$score_points,
            'score_time1'=>date('Y-m-d H:i:s')
        );
        Db::table('msm_score')->where('score_id', $mscore['score_id'])->update($score_data);

        // 转入
        $member_fee = Db::table('msm_member_fee')->where('mem_id', $opCollect['mem_id'])->find();
        if(!$member_fee){
            $fee_arr = array(
                'mem_id'		=> $opCollect['mem_id'],
                'shop_id'		=> $opCollect['shop_id'],
                'fee_money'		=> 0, //总收益
                'fee_leave'		=> 0, //剩余余额
                'fee_last'		=> date('Y-m-d H:i:s'),
            );
            $insert_id = Db::table('msm_member_fee')->insertGetId($fee_arr);
            $member_fee = Db::table('msm_member_fee')->where('mem_id', $opCollect['mem_id'])->find();
        }
        if (!$member_fee) {
            throw new \Exception('会员积分信息获取失败');
        }
        //剩余零钱
        $fee_leave = $member_fee['fee_leave'] + $param['log_score'];
        $fee_money = $member_fee['fee_money'] + $param['log_score'];

        $log = array(
            'log_type'=> 2,
            'out_mem_id'=> $param['mem_id'],
            'out_shop_id'=> $param['shop_id'],
            'out_openid'=> $param['openid'],
            'out_unionid'=> $param['unionid'],

            'in_mobile'=> $mobile,
            'in_mem_id'=> $opCollect['mem_id'],
            'in_shop_id'=> $opCollect['shop_id'],
            'in_openid'=> $opCollect['mem_wxid'],
            'in_unionid'=> $opCollect['mem_unionId'],

            'log_value'=> $param['log_value'],
            'log_score'=> $param['log_score'],
            'new_fee_leave'=> $fee_leave,
            'new_fee_money'=> $fee_money,
            'log_time'=> date('Y-m-d H:i:s'),
        );
        $add_id = Db::table('msm_point_log')->insertGetId($log);
        if (!$add_id) {
            throw new \Exception('积分记录失败');
        }
        //修改零钱
        $m_f = array('fee_money'=>$fee_money,'fee_leave'=>$fee_leave,'fee_last'=> date('Y-m-d H:i:s'));
        $up_id = Db::table('msm_member_fee')->where('mem_id', $opCollect['mem_id'])->update($m_f);
        return true;
    }
}