<?php
namespace app\service;
use app\common\util\MetaUtils;
use think\facade\Db;

class AdService
{
    public const AD_NORMAL = 1;
    public const AD_SCAN = 2;

    public const CATEGORY_ARR = [
        1 => '扫码看广告',
        2 => '正常看广告',
    ];
    public function getByOrderNo($orderNo)
    {
        $res = Db::table('msm_ms_ad_log')
            ->where('order_no', $orderNo)
            ->find();
        return $res ?: [];
    }

    public function insertLog($param) {
        $log = array(
            'category' => $param['category'],
            'collect_id' => $param['collect_id'],
            'mem_id' => $param['mem_id'],
            'shop_id' => $param['shop_id'],
            'second' => 0,
            'order_no' => $param['order_no'],
            'qrcode_code' => $param['qrcode_code'],
            'remark' => $param['remark'] ?? '',
            'ip' => '',
            'platform' => $param['platform'],
            'create_time' => time(),
            'end_time' => 0,
        );
        $id = Db::table('msm_ms_ad_log')->insertGetId($log);
        return $id;
    }

    public function updateSecond($order_no) {
        $log = $this->getByOrderNo($order_no);
        if ($log && $log['second'] == 0) {
            $time = time();
            $second = $time - $log['create_time'];
            $data = array(
                'second' => $second,
                'end_time' => $time,
            );
            Db::table('msm_ms_ad_log')->where('order_no', $order_no)->update($data);
        }
        return true;
    }


    public function randomCoinByScan($num, $maxCoin, $todayCoin)
    {
        $scores = [];
        // 第一次：2000 - 3000
        $min = (int)($maxCoin * 0.2);
        $max = (int)($maxCoin * 0.3);
        $scores[0] = mt_rand($min, $max);
        // 第二次：500 - 1000
        $min = (int)($maxCoin * 0.05);
        $max = (int)($maxCoin * 0.1);
        $scores[1] = mt_rand($min, $max);
        // 第三次：1000 - 1500
        $min = (int)($maxCoin * 0.1);
        $max = (int)($maxCoin * 0.15);
        $scores[2] = mt_rand($min, $max);
        // 第四次：500 - 1000
        $min = (int)($maxCoin * 0.05);
        $max = (int)($maxCoin * 0.1);
        $scores[3] = mt_rand($min, $max);
        // 第五次：100 - 500
        $min = (int)($maxCoin * 0.01);
        $max = (int)($maxCoin * 0.05);
        $scores[4] = mt_rand($min, $max);
        // 第六次：补足到 10000 分
        $scores[5] = $maxCoin - $todayCoin;

        if ($num >= 0 && $num < $max) {
            $num = $num%6;
            return $scores[$num] > 0 ? $scores[$num] : 0;
        } else {
            return 0;
        }
    }


    public function randomCoinByNormal($num)
    {
        if ($num >= 0 && $num <= 14) {
            return mt_rand(70, 150);
        } else {
            return 0;
        }
    }

}