<?php
namespace app\service;
use think\facade\Db;

class CoinService
{
    public const CATEGORY_ADD_SCAN_AD = 101;
    public const CATEGORY_ADD_NORMAL_AD = 102;
    public const CATEGORY_ADD_GIFT_COIN = 103;
    public const CATEGORY_ADD_MOBILE = 104;
    
    public const CATEGORY_REDUCE_GIFT_COIN = 201;
    public const CATEGORY_REDUCE_GIFT_COIN_POINT = 202;
    public const CATEGORY_REDUCE_MOBILE = 203;

    public const CATEGORY_ARR = [
        self::CATEGORY_ADD_SCAN_AD => '扫码看广告增加',
        self::CATEGORY_ADD_NORMAL_AD => '正常看广告增加',
        self::CATEGORY_ADD_GIFT_COIN => '赠送豆子增加',
        self::CATEGORY_ADD_MOBILE => '账号绑定迁移增加',
        
        self::CATEGORY_REDUCE_GIFT_COIN => '赠送豆子扣除',
        self::CATEGORY_REDUCE_GIFT_COIN_POINT => '赠送豆子转积分扣除',
        self::CATEGORY_REDUCE_MOBILE => '账号绑定迁移扣除'
    ];
    
    public const AD_ARR = [
        self::CATEGORY_ADD_SCAN_AD,
        self::CATEGORY_ADD_NORMAL_AD,
    ];
    
    public function getCategoryName($category) {
        $arr = [
            self::CATEGORY_ADD_SCAN_AD => '扫码',
            self::CATEGORY_ADD_NORMAL_AD => '任务',
        ];
        return $arr[$category] ?? '';
    }
    
    public function getByOrderNo($mem_id, $order_no) {
        $count = Db::table('msm_ms_coin_record')
            ->where('order_no', $order_no)
            ->where('in_mem_id', $mem_id)
            ->find();
        return $count ?: [];
    }

    public function getByQrcode($qrcode_code) {
        $count = Db::table('msm_ms_coin_record')
            ->where('qrcode_code', $qrcode_code)
            ->find();
        return $count ?: [];
    }

    public function countTodayByCategory($mem_id, $category) {
        $res = Db::table('msm_ms_coin_record')
            ->where('category', $category)
            ->where('in_mem_id', $mem_id)
            ->where('create_time', '>=', strtotime(date('Y-m-d')))
            ->group('qrcode_code')
            ->select();
        return $res ? count($res) : 0;
    }

    public function getTodayCountPlatform($mem_id, $shop_id, $category, $platform) {
        $count = Db::table('msm_ms_coin_record')
            ->where('category', $category)
            ->where('in_mem_id', $mem_id)
            ->where('in_shop_id', $shop_id)
            ->where('platform', $platform)
            ->where('create_time', '>=', strtotime(date('Y-m-d')))
            ->count();
        return $count ?: 0;
    }

    public function getTodayCoin($mem_id, $category) {
        $sum = Db::table('msm_ms_coin_record')
            ->where('category', $category)
            ->where('in_mem_id', $mem_id)
            ->where('create_time', '>=', strtotime(date('Y-m-d')))
            ->sum('coin');
        return $sum ?: 0;
    }
}