<?php
namespace app\service;
use think\facade\Db;
use think\facade\Session;

class SessionService
{
    public const SESSION_KEY_MEMBER_LOGIN = 'ss_reg_member_login';
    public function registerSessionByMemberLogin($mem_id, $shop_id, $collect_id)
    {
        $data = [];
        $data['mem_id'] = $mem_id;
        $data['collect_id'] = $collect_id;
        $data['shop_id'] = $shop_id;
        Session::set(self::SESSION_KEY_MEMBER_LOGIN, json_encode($data));
        return true;
    }
    
    public function clearSessionByMemberLogin()
    {
        Session::delete(self::SESSION_KEY_MEMBER_LOGIN);
        return true;
    }
    
    public function getSession($key)
    {
        $json = Session::get($key);
        return $json ? json_decode($json, true) : null;
    }
    
    public function getSessionByMemberLogin()
    {
        return $this->getSession(self::SESSION_KEY_MEMBER_LOGIN);
    }
}