<?php

namespace app\validate;

use think\Validate;
include_once 'validate.php';

class UserValidate extends Validate
{
    protected $rule =   [
        'wxapp_id'  => 'require',
        'encrypted_data'  => 'require',
        'iv'  => 'require',
        'code'  => 'require',
        'user_info'  => 'require',
        // 'token'   => 'number|between:1,120',
        // 'email' => 'email',    
    ];
    
    protected $message  =   [
        'wxapp_id.require' => '微信id不能为空',
        'encrypted_data.require' => 'encrypted_data不能为空',
        'iv.require' => 'iv不能为空',
        'code.require' => 'code不能为空',
        'user_info.require' => 'user_info不能为空',
        // 'name.max'     => '名称最多不能超过25个字符',
        // 'age.number'   => '年龄必须是数字',
        // 'age.between'  => '年龄只能在1-120之间',
        // 'email'        => '邮箱格式错误',    
    ];

     // 新的验证方法
     protected function customValidation($data)
     {
         $rules = [
             'email' => 'require|email',
             'phone' => 'require|mobile',
             // 其他字段的验证规则...
         ];
 
         $messages = [
             'email.require' => '邮箱不能为空',
             'email.email' => '邮箱格式不正确',
             'phone.require' => '手机号不能为空',
             'phone.mobile' => '手机号格式不正确',
             // 其他字段的错误信息...
         ];
 
         $this->rule($rules)->message($messages);
 
         return $this->check($data);
     }

}