<?php
/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
namespace TencentCloud\Batch\V20170312\Models;
use TencentCloud\Common\AbstractModel;

/**
 * Docker容器信息
 *
 * @method string getUser() 获取Docker Hub 用户名或 Tencent Registry 用户名
 * @method void setUser(string $User) 设置Docker Hub 用户名或 Tencent Registry 用户名
 * @method string getPassword() 获取Docker Hub 密码或 Tencent Registry 密码
 * @method void setPassword(string $Password) 设置Docker Hub 密码或 Tencent Registry 密码
 * @method string getImage() 获取Docker Hub填写“[user/repo]:[tag]”，Tencent Registry填写“ccr.ccs.tencentyun.com/[namespace/repo]:[tag]”
 * @method void setImage(string $Image) 设置Docker Hub填写“[user/repo]:[tag]”，Tencent Registry填写“ccr.ccs.tencentyun.com/[namespace/repo]:[tag]”
 * @method string getServer() 获取Docker Hub 可以不填，但确保具有公网访问能力。或者是 Tencent Registry 服务地址“ccr.ccs.tencentyun.com”
 * @method void setServer(string $Server) 设置Docker Hub 可以不填，但确保具有公网访问能力。或者是 Tencent Registry 服务地址“ccr.ccs.tencentyun.com”
 * @method integer getMaxRetryCount() 获取拉取Docker镜像重试次数。默认值：0。
 * @method void setMaxRetryCount(integer $MaxRetryCount) 设置拉取Docker镜像重试次数。默认值：0。
 * @method integer getDelayOnRetry() 获取拉取Docker镜像失败时延迟时间。单位：秒。
 * @method void setDelayOnRetry(integer $DelayOnRetry) 设置拉取Docker镜像失败时延迟时间。单位：秒。
 * @method string getDockerRunOption() 获取Docker命令运行参数。
注意：此字段可能返回 null，表示取不到有效值。
 * @method void setDockerRunOption(string $DockerRunOption) 设置Docker命令运行参数。
注意：此字段可能返回 null，表示取不到有效值。
 */
class Docker extends AbstractModel
{
    /**
     * @var string Docker Hub 用户名或 Tencent Registry 用户名
     */
    public $User;

    /**
     * @var string Docker Hub 密码或 Tencent Registry 密码
     */
    public $Password;

    /**
     * @var string Docker Hub填写“[user/repo]:[tag]”，Tencent Registry填写“ccr.ccs.tencentyun.com/[namespace/repo]:[tag]”
     */
    public $Image;

    /**
     * @var string Docker Hub 可以不填，但确保具有公网访问能力。或者是 Tencent Registry 服务地址“ccr.ccs.tencentyun.com”
     */
    public $Server;

    /**
     * @var integer 拉取Docker镜像重试次数。默认值：0。
     */
    public $MaxRetryCount;

    /**
     * @var integer 拉取Docker镜像失败时延迟时间。单位：秒。
     */
    public $DelayOnRetry;

    /**
     * @var string Docker命令运行参数。
注意：此字段可能返回 null，表示取不到有效值。
     */
    public $DockerRunOption;

    /**
     * @param string $User Docker Hub 用户名或 Tencent Registry 用户名
     * @param string $Password Docker Hub 密码或 Tencent Registry 密码
     * @param string $Image Docker Hub填写“[user/repo]:[tag]”，Tencent Registry填写“ccr.ccs.tencentyun.com/[namespace/repo]:[tag]”
     * @param string $Server Docker Hub 可以不填，但确保具有公网访问能力。或者是 Tencent Registry 服务地址“ccr.ccs.tencentyun.com”
     * @param integer $MaxRetryCount 拉取Docker镜像重试次数。默认值：0。
     * @param integer $DelayOnRetry 拉取Docker镜像失败时延迟时间。单位：秒。
     * @param string $DockerRunOption Docker命令运行参数。
注意：此字段可能返回 null，表示取不到有效值。
     */
    function __construct()
    {

    }

    /**
     * For internal only. DO NOT USE IT.
     */
    public function deserialize($param)
    {
        if ($param === null) {
            return;
        }
        if (array_key_exists("User",$param) and $param["User"] !== null) {
            $this->User = $param["User"];
        }

        if (array_key_exists("Password",$param) and $param["Password"] !== null) {
            $this->Password = $param["Password"];
        }

        if (array_key_exists("Image",$param) and $param["Image"] !== null) {
            $this->Image = $param["Image"];
        }

        if (array_key_exists("Server",$param) and $param["Server"] !== null) {
            $this->Server = $param["Server"];
        }

        if (array_key_exists("MaxRetryCount",$param) and $param["MaxRetryCount"] !== null) {
            $this->MaxRetryCount = $param["MaxRetryCount"];
        }

        if (array_key_exists("DelayOnRetry",$param) and $param["DelayOnRetry"] !== null) {
            $this->DelayOnRetry = $param["DelayOnRetry"];
        }

        if (array_key_exists("DockerRunOption",$param) and $param["DockerRunOption"] !== null) {
            $this->DockerRunOption = $param["DockerRunOption"];
        }
    }
}
