<?php
/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
namespace TencentCloud\Bsca\V20210811\Models;
use TencentCloud\Common\AbstractModel;

/**
 * DescribeKBVulnerability请求参数结构体
 *
 * @method array getCVEID() 获取根据CVE ID查询（不能与其他参数同时存在）
 * @method void setCVEID(array $CVEID) 设置根据CVE ID查询（不能与其他参数同时存在）
 * @method array getVulID() 获取根据Vul ID查询（不能与其他参数同时存在）
 * @method void setVulID(array $VulID) 设置根据Vul ID查询（不能与其他参数同时存在）
 * @method array getCNVDID() 获取根据CNVD ID查询（不能与其他参数同时存在）
 * @method void setCNVDID(array $CNVDID) 设置根据CNVD ID查询（不能与其他参数同时存在）
 * @method array getCNNVDID() 获取根据CNNVD ID查询（不能与其他参数同时存在）
 * @method void setCNNVDID(array $CNNVDID) 设置根据CNNVD ID查询（不能与其他参数同时存在）
 */
class DescribeKBVulnerabilityRequest extends AbstractModel
{
    /**
     * @var array 根据CVE ID查询（不能与其他参数同时存在）
     */
    public $CVEID;

    /**
     * @var array 根据Vul ID查询（不能与其他参数同时存在）
     */
    public $VulID;

    /**
     * @var array 根据CNVD ID查询（不能与其他参数同时存在）
     */
    public $CNVDID;

    /**
     * @var array 根据CNNVD ID查询（不能与其他参数同时存在）
     */
    public $CNNVDID;

    /**
     * @param array $CVEID 根据CVE ID查询（不能与其他参数同时存在）
     * @param array $VulID 根据Vul ID查询（不能与其他参数同时存在）
     * @param array $CNVDID 根据CNVD ID查询（不能与其他参数同时存在）
     * @param array $CNNVDID 根据CNNVD ID查询（不能与其他参数同时存在）
     */
    function __construct()
    {

    }

    /**
     * For internal only. DO NOT USE IT.
     */
    public function deserialize($param)
    {
        if ($param === null) {
            return;
        }
        if (array_key_exists("CVEID",$param) and $param["CVEID"] !== null) {
            $this->CVEID = $param["CVEID"];
        }

        if (array_key_exists("VulID",$param) and $param["VulID"] !== null) {
            $this->VulID = $param["VulID"];
        }

        if (array_key_exists("CNVDID",$param) and $param["CNVDID"] !== null) {
            $this->CNVDID = $param["CNVDID"];
        }

        if (array_key_exists("CNNVDID",$param) and $param["CNNVDID"] !== null) {
            $this->CNNVDID = $param["CNNVDID"];
        }
    }
}
