<?php
/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
namespace TencentCloud\Cfw\V20190904\Models;
use TencentCloud\Common\AbstractModel;

/**
 * DescribeAddressTemplateList返回参数结构体
 *
 * @method integer getTotal() 获取模板总数
 * @method void setTotal(integer $Total) 设置模板总数
 * @method array getData() 获取模板列表数据
 * @method void setData(array $Data) 设置模板列表数据
 * @method array getNameList() 获取模板名称列表
 * @method void setNameList(array $NameList) 设置模板名称列表
 * @method integer getIpTemplateCount() 获取Ip地址模板数量
 * @method void setIpTemplateCount(integer $IpTemplateCount) 设置Ip地址模板数量
 * @method integer getDomainTemplateCount() 获取域名地址模板数量
 * @method void setDomainTemplateCount(integer $DomainTemplateCount) 设置域名地址模板数量
 * @method integer getPortTemplateCount() 获取协议端口模板数量
 * @method void setPortTemplateCount(integer $PortTemplateCount) 设置协议端口模板数量
 * @method string getRequestId() 获取唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
 * @method void setRequestId(string $RequestId) 设置唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
 */
class DescribeAddressTemplateListResponse extends AbstractModel
{
    /**
     * @var integer 模板总数
     */
    public $Total;

    /**
     * @var array 模板列表数据
     */
    public $Data;

    /**
     * @var array 模板名称列表
     */
    public $NameList;

    /**
     * @var integer Ip地址模板数量
     */
    public $IpTemplateCount;

    /**
     * @var integer 域名地址模板数量
     */
    public $DomainTemplateCount;

    /**
     * @var integer 协议端口模板数量
     */
    public $PortTemplateCount;

    /**
     * @var string 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     */
    public $RequestId;

    /**
     * @param integer $Total 模板总数
     * @param array $Data 模板列表数据
     * @param array $NameList 模板名称列表
     * @param integer $IpTemplateCount Ip地址模板数量
     * @param integer $DomainTemplateCount 域名地址模板数量
     * @param integer $PortTemplateCount 协议端口模板数量
     * @param string $RequestId 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     */
    function __construct()
    {

    }

    /**
     * For internal only. DO NOT USE IT.
     */
    public function deserialize($param)
    {
        if ($param === null) {
            return;
        }
        if (array_key_exists("Total",$param) and $param["Total"] !== null) {
            $this->Total = $param["Total"];
        }

        if (array_key_exists("Data",$param) and $param["Data"] !== null) {
            $this->Data = [];
            foreach ($param["Data"] as $key => $value){
                $obj = new TemplateListInfo();
                $obj->deserialize($value);
                array_push($this->Data, $obj);
            }
        }

        if (array_key_exists("NameList",$param) and $param["NameList"] !== null) {
            $this->NameList = $param["NameList"];
        }

        if (array_key_exists("IpTemplateCount",$param) and $param["IpTemplateCount"] !== null) {
            $this->IpTemplateCount = $param["IpTemplateCount"];
        }

        if (array_key_exists("DomainTemplateCount",$param) and $param["DomainTemplateCount"] !== null) {
            $this->DomainTemplateCount = $param["DomainTemplateCount"];
        }

        if (array_key_exists("PortTemplateCount",$param) and $param["PortTemplateCount"] !== null) {
            $this->PortTemplateCount = $param["PortTemplateCount"];
        }

        if (array_key_exists("RequestId",$param) and $param["RequestId"] !== null) {
            $this->RequestId = $param["RequestId"];
        }
    }
}
