<?php
/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
namespace TencentCloud\Csip\V20221121\Models;
use TencentCloud\Common\AbstractModel;

/**
 * DescribeScanTaskList返回参数结构体
 *
 * @method integer getTotalCount() 获取总条数
注意：此字段可能返回 null，表示取不到有效值。
 * @method void setTotalCount(integer $TotalCount) 设置总条数
注意：此字段可能返回 null，表示取不到有效值。
 * @method array getData() 获取任务日志列表
注意：此字段可能返回 null，表示取不到有效值。
 * @method void setData(array $Data) 设置任务日志列表
注意：此字段可能返回 null，表示取不到有效值。
 * @method array getUINList() 获取主账户ID列表
注意：此字段可能返回 null，表示取不到有效值。
 * @method void setUINList(array $UINList) 设置主账户ID列表
注意：此字段可能返回 null，表示取不到有效值。
 * @method array getTaskModeList() 获取体检模式过滤列表
注意：此字段可能返回 null，表示取不到有效值。
 * @method void setTaskModeList(array $TaskModeList) 设置体检模式过滤列表
注意：此字段可能返回 null，表示取不到有效值。
 * @method string getRequestId() 获取唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
 * @method void setRequestId(string $RequestId) 设置唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
 */
class DescribeScanTaskListResponse extends AbstractModel
{
    /**
     * @var integer 总条数
注意：此字段可能返回 null，表示取不到有效值。
     */
    public $TotalCount;

    /**
     * @var array 任务日志列表
注意：此字段可能返回 null，表示取不到有效值。
     */
    public $Data;

    /**
     * @var array 主账户ID列表
注意：此字段可能返回 null，表示取不到有效值。
     */
    public $UINList;

    /**
     * @var array 体检模式过滤列表
注意：此字段可能返回 null，表示取不到有效值。
     */
    public $TaskModeList;

    /**
     * @var string 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     */
    public $RequestId;

    /**
     * @param integer $TotalCount 总条数
注意：此字段可能返回 null，表示取不到有效值。
     * @param array $Data 任务日志列表
注意：此字段可能返回 null，表示取不到有效值。
     * @param array $UINList 主账户ID列表
注意：此字段可能返回 null，表示取不到有效值。
     * @param array $TaskModeList 体检模式过滤列表
注意：此字段可能返回 null，表示取不到有效值。
     * @param string $RequestId 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     */
    function __construct()
    {

    }

    /**
     * For internal only. DO NOT USE IT.
     */
    public function deserialize($param)
    {
        if ($param === null) {
            return;
        }
        if (array_key_exists("TotalCount",$param) and $param["TotalCount"] !== null) {
            $this->TotalCount = $param["TotalCount"];
        }

        if (array_key_exists("Data",$param) and $param["Data"] !== null) {
            $this->Data = [];
            foreach ($param["Data"] as $key => $value){
                $obj = new ScanTaskInfoList();
                $obj->deserialize($value);
                array_push($this->Data, $obj);
            }
        }

        if (array_key_exists("UINList",$param) and $param["UINList"] !== null) {
            $this->UINList = $param["UINList"];
        }

        if (array_key_exists("TaskModeList",$param) and $param["TaskModeList"] !== null) {
            $this->TaskModeList = [];
            foreach ($param["TaskModeList"] as $key => $value){
                $obj = new FilterDataObject();
                $obj->deserialize($value);
                array_push($this->TaskModeList, $obj);
            }
        }

        if (array_key_exists("RequestId",$param) and $param["RequestId"] !== null) {
            $this->RequestId = $param["RequestId"];
        }
    }
}
