<?php
/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
namespace TencentCloud\Cwp\V20180228\Models;
use TencentCloud\Common\AbstractModel;

/**
 * 木马列表集合
 *
 * @method string getHostIp() 获取服务器ip
 * @method void setHostIp(string $HostIp) 设置服务器ip
 * @method string getUuid() 获取唯一UUID
 * @method void setUuid(string $Uuid) 设置唯一UUID
 * @method string getFilePath() 获取路径
 * @method void setFilePath(string $FilePath) 设置路径
 * @method string getVirusName() 获取描述
 * @method void setVirusName(string $VirusName) 设置描述
 * @method integer getStatus() 获取状态；4-:待处理，5-已信任，6-已隔离，8-文件已删除, 14:已处理
 * @method void setStatus(integer $Status) 设置状态；4-:待处理，5-已信任，6-已隔离，8-文件已删除, 14:已处理
 * @method integer getId() 获取唯一ID
注意：此字段可能返回 null，表示取不到有效值。
 * @method void setId(integer $Id) 设置唯一ID
注意：此字段可能返回 null，表示取不到有效值。
 * @method string getAlias() 获取主机别名
 * @method void setAlias(string $Alias) 设置主机别名
 * @method array getTags() 获取特性标签，已废弃字段，不会再返回标签，详情中才会返回标签信息
注意：此字段可能返回 null，表示取不到有效值。
 * @method void setTags(array $Tags) 设置特性标签，已废弃字段，不会再返回标签，详情中才会返回标签信息
注意：此字段可能返回 null，表示取不到有效值。
 * @method string getFileCreateTime() 获取首次运行时间
注意：此字段可能返回 null，表示取不到有效值。
 * @method void setFileCreateTime(string $FileCreateTime) 设置首次运行时间
注意：此字段可能返回 null，表示取不到有效值。
 * @method string getFileModifierTime() 获取最近运行时间
注意：此字段可能返回 null，表示取不到有效值。
 * @method void setFileModifierTime(string $FileModifierTime) 设置最近运行时间
注意：此字段可能返回 null，表示取不到有效值。
 * @method string getCreateTime() 获取创建时间
 * @method void setCreateTime(string $CreateTime) 设置创建时间
 * @method string getLatestScanTime() 获取最近扫描时间
 * @method void setLatestScanTime(string $LatestScanTime) 设置最近扫描时间
 * @method integer getLevel() 获取风险等级 0未知、1低、2中、3高、4严重
 * @method void setLevel(integer $Level) 设置风险等级 0未知、1低、2中、3高、4严重
 * @method string getCheckPlatform() 获取'木马检测平台用,分割 1云查杀引擎、2TAV、3binaryAi、4异常行为、5威胁情报
 * @method void setCheckPlatform(string $CheckPlatform) 设置'木马检测平台用,分割 1云查杀引擎、2TAV、3binaryAi、4异常行为、5威胁情报
 * @method integer getProcessExists() 获取木马进程是否存在 0:不存在，1:存在
 * @method void setProcessExists(integer $ProcessExists) 设置木马进程是否存在 0:不存在，1:存在
 * @method integer getFileExists() 获取木马文件是否存在 0:不存在，1:存在
 * @method void setFileExists(integer $FileExists) 设置木马文件是否存在 0:不存在，1:存在
 * @method string getQuuid() 获取cvm quuid
 * @method void setQuuid(string $Quuid) 设置cvm quuid
 * @method string getMD5() 获取木马样本md5
 * @method void setMD5(string $MD5) 设置木马样本md5
 * @method MachineExtraInfo getMachineExtraInfo() 获取附加信息
注意：此字段可能返回 null，表示取不到有效值。
 * @method void setMachineExtraInfo(MachineExtraInfo $MachineExtraInfo) 设置附加信息
注意：此字段可能返回 null，表示取不到有效值。
 */
class MalWareList extends AbstractModel
{
    /**
     * @var string 服务器ip
     */
    public $HostIp;

    /**
     * @var string 唯一UUID
     */
    public $Uuid;

    /**
     * @var string 路径
     */
    public $FilePath;

    /**
     * @var string 描述
     */
    public $VirusName;

    /**
     * @var integer 状态；4-:待处理，5-已信任，6-已隔离，8-文件已删除, 14:已处理
     */
    public $Status;

    /**
     * @var integer 唯一ID
注意：此字段可能返回 null，表示取不到有效值。
     */
    public $Id;

    /**
     * @var string 主机别名
     */
    public $Alias;

    /**
     * @var array 特性标签，已废弃字段，不会再返回标签，详情中才会返回标签信息
注意：此字段可能返回 null，表示取不到有效值。
     */
    public $Tags;

    /**
     * @var string 首次运行时间
注意：此字段可能返回 null，表示取不到有效值。
     */
    public $FileCreateTime;

    /**
     * @var string 最近运行时间
注意：此字段可能返回 null，表示取不到有效值。
     */
    public $FileModifierTime;

    /**
     * @var string 创建时间
     */
    public $CreateTime;

    /**
     * @var string 最近扫描时间
     */
    public $LatestScanTime;

    /**
     * @var integer 风险等级 0未知、1低、2中、3高、4严重
     */
    public $Level;

    /**
     * @var string '木马检测平台用,分割 1云查杀引擎、2TAV、3binaryAi、4异常行为、5威胁情报
     */
    public $CheckPlatform;

    /**
     * @var integer 木马进程是否存在 0:不存在，1:存在
     */
    public $ProcessExists;

    /**
     * @var integer 木马文件是否存在 0:不存在，1:存在
     */
    public $FileExists;

    /**
     * @var string cvm quuid
     */
    public $Quuid;

    /**
     * @var string 木马样本md5
     */
    public $MD5;

    /**
     * @var MachineExtraInfo 附加信息
注意：此字段可能返回 null，表示取不到有效值。
     */
    public $MachineExtraInfo;

    /**
     * @param string $HostIp 服务器ip
     * @param string $Uuid 唯一UUID
     * @param string $FilePath 路径
     * @param string $VirusName 描述
     * @param integer $Status 状态；4-:待处理，5-已信任，6-已隔离，8-文件已删除, 14:已处理
     * @param integer $Id 唯一ID
注意：此字段可能返回 null，表示取不到有效值。
     * @param string $Alias 主机别名
     * @param array $Tags 特性标签，已废弃字段，不会再返回标签，详情中才会返回标签信息
注意：此字段可能返回 null，表示取不到有效值。
     * @param string $FileCreateTime 首次运行时间
注意：此字段可能返回 null，表示取不到有效值。
     * @param string $FileModifierTime 最近运行时间
注意：此字段可能返回 null，表示取不到有效值。
     * @param string $CreateTime 创建时间
     * @param string $LatestScanTime 最近扫描时间
     * @param integer $Level 风险等级 0未知、1低、2中、3高、4严重
     * @param string $CheckPlatform '木马检测平台用,分割 1云查杀引擎、2TAV、3binaryAi、4异常行为、5威胁情报
     * @param integer $ProcessExists 木马进程是否存在 0:不存在，1:存在
     * @param integer $FileExists 木马文件是否存在 0:不存在，1:存在
     * @param string $Quuid cvm quuid
     * @param string $MD5 木马样本md5
     * @param MachineExtraInfo $MachineExtraInfo 附加信息
注意：此字段可能返回 null，表示取不到有效值。
     */
    function __construct()
    {

    }

    /**
     * For internal only. DO NOT USE IT.
     */
    public function deserialize($param)
    {
        if ($param === null) {
            return;
        }
        if (array_key_exists("HostIp",$param) and $param["HostIp"] !== null) {
            $this->HostIp = $param["HostIp"];
        }

        if (array_key_exists("Uuid",$param) and $param["Uuid"] !== null) {
            $this->Uuid = $param["Uuid"];
        }

        if (array_key_exists("FilePath",$param) and $param["FilePath"] !== null) {
            $this->FilePath = $param["FilePath"];
        }

        if (array_key_exists("VirusName",$param) and $param["VirusName"] !== null) {
            $this->VirusName = $param["VirusName"];
        }

        if (array_key_exists("Status",$param) and $param["Status"] !== null) {
            $this->Status = $param["Status"];
        }

        if (array_key_exists("Id",$param) and $param["Id"] !== null) {
            $this->Id = $param["Id"];
        }

        if (array_key_exists("Alias",$param) and $param["Alias"] !== null) {
            $this->Alias = $param["Alias"];
        }

        if (array_key_exists("Tags",$param) and $param["Tags"] !== null) {
            $this->Tags = $param["Tags"];
        }

        if (array_key_exists("FileCreateTime",$param) and $param["FileCreateTime"] !== null) {
            $this->FileCreateTime = $param["FileCreateTime"];
        }

        if (array_key_exists("FileModifierTime",$param) and $param["FileModifierTime"] !== null) {
            $this->FileModifierTime = $param["FileModifierTime"];
        }

        if (array_key_exists("CreateTime",$param) and $param["CreateTime"] !== null) {
            $this->CreateTime = $param["CreateTime"];
        }

        if (array_key_exists("LatestScanTime",$param) and $param["LatestScanTime"] !== null) {
            $this->LatestScanTime = $param["LatestScanTime"];
        }

        if (array_key_exists("Level",$param) and $param["Level"] !== null) {
            $this->Level = $param["Level"];
        }

        if (array_key_exists("CheckPlatform",$param) and $param["CheckPlatform"] !== null) {
            $this->CheckPlatform = $param["CheckPlatform"];
        }

        if (array_key_exists("ProcessExists",$param) and $param["ProcessExists"] !== null) {
            $this->ProcessExists = $param["ProcessExists"];
        }

        if (array_key_exists("FileExists",$param) and $param["FileExists"] !== null) {
            $this->FileExists = $param["FileExists"];
        }

        if (array_key_exists("Quuid",$param) and $param["Quuid"] !== null) {
            $this->Quuid = $param["Quuid"];
        }

        if (array_key_exists("MD5",$param) and $param["MD5"] !== null) {
            $this->MD5 = $param["MD5"];
        }

        if (array_key_exists("MachineExtraInfo",$param) and $param["MachineExtraInfo"] !== null) {
            $this->MachineExtraInfo = new MachineExtraInfo();
            $this->MachineExtraInfo->deserialize($param["MachineExtraInfo"]);
        }
    }
}
