<?php
/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
namespace TencentCloud\Cwp\V20180228\Models;
use TencentCloud\Common\AbstractModel;

/**
 * 木马白名单信息
 *
 * @method integer getId() 获取唯一ID。
 * @method void setId(integer $Id) 设置唯一ID。
 * @method string getQuuidList() 获取cvm quuid 按,分割。
 * @method void setQuuidList(string $QuuidList) 设置cvm quuid 按,分割。
 * @method string getMd5List() 获取md5列表 按,分割
 * @method void setMd5List(string $Md5List) 设置md5列表 按,分割
 * @method integer getIsGlobal() 获取是否全部主机； 0否，1是
 * @method void setIsGlobal(integer $IsGlobal) 设置是否全部主机； 0否，1是
 * @method integer getMode() 获取白名单模式；0 MD5 ，1自定义
 * @method void setMode(integer $Mode) 设置白名单模式；0 MD5 ，1自定义
 * @method integer getMatchType() 获取匹配模式；0精确匹配，1模糊匹配
 * @method void setMatchType(integer $MatchType) 设置匹配模式；0精确匹配，1模糊匹配
 * @method string getFileName() 获取文件名；按,分割
 * @method void setFileName(string $FileName) 设置文件名；按,分割
 * @method string getFileDirectory() 获取文件目录；按,分割
 * @method void setFileDirectory(string $FileDirectory) 设置文件目录；按,分割
 * @method string getFileExtension() 获取文件后缀；按,分割
 * @method void setFileExtension(string $FileExtension) 设置文件后缀；按,分割
 * @method string getCreateTime() 获取规则创建时间
 * @method void setCreateTime(string $CreateTime) 设置规则创建时间
 * @method integer getEventsCount() 获取受影响记录
 * @method void setEventsCount(integer $EventsCount) 设置受影响记录
 */
class MalwareWhiteListInfo extends AbstractModel
{
    /**
     * @var integer 唯一ID。
     */
    public $Id;

    /**
     * @var string cvm quuid 按,分割。
     */
    public $QuuidList;

    /**
     * @var string md5列表 按,分割
     */
    public $Md5List;

    /**
     * @var integer 是否全部主机； 0否，1是
     */
    public $IsGlobal;

    /**
     * @var integer 白名单模式；0 MD5 ，1自定义
     */
    public $Mode;

    /**
     * @var integer 匹配模式；0精确匹配，1模糊匹配
     */
    public $MatchType;

    /**
     * @var string 文件名；按,分割
     */
    public $FileName;

    /**
     * @var string 文件目录；按,分割
     */
    public $FileDirectory;

    /**
     * @var string 文件后缀；按,分割
     */
    public $FileExtension;

    /**
     * @var string 规则创建时间
     */
    public $CreateTime;

    /**
     * @var integer 受影响记录
     */
    public $EventsCount;

    /**
     * @param integer $Id 唯一ID。
     * @param string $QuuidList cvm quuid 按,分割。
     * @param string $Md5List md5列表 按,分割
     * @param integer $IsGlobal 是否全部主机； 0否，1是
     * @param integer $Mode 白名单模式；0 MD5 ，1自定义
     * @param integer $MatchType 匹配模式；0精确匹配，1模糊匹配
     * @param string $FileName 文件名；按,分割
     * @param string $FileDirectory 文件目录；按,分割
     * @param string $FileExtension 文件后缀；按,分割
     * @param string $CreateTime 规则创建时间
     * @param integer $EventsCount 受影响记录
     */
    function __construct()
    {

    }

    /**
     * For internal only. DO NOT USE IT.
     */
    public function deserialize($param)
    {
        if ($param === null) {
            return;
        }
        if (array_key_exists("Id",$param) and $param["Id"] !== null) {
            $this->Id = $param["Id"];
        }

        if (array_key_exists("QuuidList",$param) and $param["QuuidList"] !== null) {
            $this->QuuidList = $param["QuuidList"];
        }

        if (array_key_exists("Md5List",$param) and $param["Md5List"] !== null) {
            $this->Md5List = $param["Md5List"];
        }

        if (array_key_exists("IsGlobal",$param) and $param["IsGlobal"] !== null) {
            $this->IsGlobal = $param["IsGlobal"];
        }

        if (array_key_exists("Mode",$param) and $param["Mode"] !== null) {
            $this->Mode = $param["Mode"];
        }

        if (array_key_exists("MatchType",$param) and $param["MatchType"] !== null) {
            $this->MatchType = $param["MatchType"];
        }

        if (array_key_exists("FileName",$param) and $param["FileName"] !== null) {
            $this->FileName = $param["FileName"];
        }

        if (array_key_exists("FileDirectory",$param) and $param["FileDirectory"] !== null) {
            $this->FileDirectory = $param["FileDirectory"];
        }

        if (array_key_exists("FileExtension",$param) and $param["FileExtension"] !== null) {
            $this->FileExtension = $param["FileExtension"];
        }

        if (array_key_exists("CreateTime",$param) and $param["CreateTime"] !== null) {
            $this->CreateTime = $param["CreateTime"];
        }

        if (array_key_exists("EventsCount",$param) and $param["EventsCount"] !== null) {
            $this->EventsCount = $param["EventsCount"];
        }
    }
}
