<?php
/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
namespace TencentCloud\Cwp\V20180228\Models;
use TencentCloud\Common\AbstractModel;

/**
 * ModifyWebHookPolicyStatus请求参数结构体
 *
 * @method integer getId() 获取id
 * @method void setId(integer $Id) 设置id
 * @method integer getIsDisabled() 获取开关, 1禁用 0启用
 * @method void setIsDisabled(integer $IsDisabled) 设置开关, 1禁用 0启用
 */
class ModifyWebHookPolicyStatusRequest extends AbstractModel
{
    /**
     * @var integer id
     */
    public $Id;

    /**
     * @var integer 开关, 1禁用 0启用
     */
    public $IsDisabled;

    /**
     * @param integer $Id id
     * @param integer $IsDisabled 开关, 1禁用 0启用
     */
    function __construct()
    {

    }

    /**
     * For internal only. DO NOT USE IT.
     */
    public function deserialize($param)
    {
        if ($param === null) {
            return;
        }
        if (array_key_exists("Id",$param) and $param["Id"] !== null) {
            $this->Id = $param["Id"];
        }

        if (array_key_exists("IsDisabled",$param) and $param["IsDisabled"] !== null) {
            $this->IsDisabled = $param["IsDisabled"];
        }
    }
}
