<?php
/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
namespace TencentCloud\Dlc\V20210125\Models;
use TencentCloud\Common\AbstractModel;

/**
 * CreateSparkSessionBatchSQL返回参数结构体
 *
 * @method string getBatchId() 获取批任务唯一标识
 * @method void setBatchId(string $BatchId) 设置批任务唯一标识
 * @method array getStatements() 获取Statement任务列表信息
注意：此字段可能返回 null，表示取不到有效值。
 * @method void setStatements(array $Statements) 设置Statement任务列表信息
注意：此字段可能返回 null，表示取不到有效值。
 * @method string getRequestId() 获取唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
 * @method void setRequestId(string $RequestId) 设置唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
 */
class CreateSparkSessionBatchSQLResponse extends AbstractModel
{
    /**
     * @var string 批任务唯一标识
     */
    public $BatchId;

    /**
     * @var array Statement任务列表信息
注意：此字段可能返回 null，表示取不到有效值。
     */
    public $Statements;

    /**
     * @var string 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     */
    public $RequestId;

    /**
     * @param string $BatchId 批任务唯一标识
     * @param array $Statements Statement任务列表信息
注意：此字段可能返回 null，表示取不到有效值。
     * @param string $RequestId 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     */
    function __construct()
    {

    }

    /**
     * For internal only. DO NOT USE IT.
     */
    public function deserialize($param)
    {
        if ($param === null) {
            return;
        }
        if (array_key_exists("BatchId",$param) and $param["BatchId"] !== null) {
            $this->BatchId = $param["BatchId"];
        }

        if (array_key_exists("Statements",$param) and $param["Statements"] !== null) {
            $this->Statements = [];
            foreach ($param["Statements"] as $key => $value){
                $obj = new StatementInformation();
                $obj->deserialize($value);
                array_push($this->Statements, $obj);
            }
        }

        if (array_key_exists("RequestId",$param) and $param["RequestId"] !== null) {
            $this->RequestId = $param["RequestId"];
        }
    }
}
