<?php
/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
namespace TencentCloud\Ie\V20200304\Models;
use TencentCloud\Common\AbstractModel;

/**
 * 任务结束后生成的文件音频信息
 *
 * @method integer getStream() 获取音频流的流id。
 * @method void setStream(integer $Stream) 设置音频流的流id。
 * @method integer getSample() 获取音频采样率 。
注意：此字段可能返回 null，表示取不到有效值。
 * @method void setSample(integer $Sample) 设置音频采样率 。
注意：此字段可能返回 null，表示取不到有效值。
 * @method integer getChannel() 获取音频声道数。
注意：此字段可能返回 null，表示取不到有效值。
 * @method void setChannel(integer $Channel) 设置音频声道数。
注意：此字段可能返回 null，表示取不到有效值。
 * @method string getCodec() 获取编码格式，如aac, mp3等。
注意：此字段可能返回 null，表示取不到有效值。
 * @method void setCodec(string $Codec) 设置编码格式，如aac, mp3等。
注意：此字段可能返回 null，表示取不到有效值。
 * @method integer getBitrate() 获取码率，单位：bps。
注意：此字段可能返回 null，表示取不到有效值。
 * @method void setBitrate(integer $Bitrate) 设置码率，单位：bps。
注意：此字段可能返回 null，表示取不到有效值。
 * @method integer getDuration() 获取音频时长，单位：ms。
注意：此字段可能返回 null，表示取不到有效值。
 * @method void setDuration(integer $Duration) 设置音频时长，单位：ms。
注意：此字段可能返回 null，表示取不到有效值。
 */
class AudioInfoResultItem extends AbstractModel
{
    /**
     * @var integer 音频流的流id。
     */
    public $Stream;

    /**
     * @var integer 音频采样率 。
注意：此字段可能返回 null，表示取不到有效值。
     */
    public $Sample;

    /**
     * @var integer 音频声道数。
注意：此字段可能返回 null，表示取不到有效值。
     */
    public $Channel;

    /**
     * @var string 编码格式，如aac, mp3等。
注意：此字段可能返回 null，表示取不到有效值。
     */
    public $Codec;

    /**
     * @var integer 码率，单位：bps。
注意：此字段可能返回 null，表示取不到有效值。
     */
    public $Bitrate;

    /**
     * @var integer 音频时长，单位：ms。
注意：此字段可能返回 null，表示取不到有效值。
     */
    public $Duration;

    /**
     * @param integer $Stream 音频流的流id。
     * @param integer $Sample 音频采样率 。
注意：此字段可能返回 null，表示取不到有效值。
     * @param integer $Channel 音频声道数。
注意：此字段可能返回 null，表示取不到有效值。
     * @param string $Codec 编码格式，如aac, mp3等。
注意：此字段可能返回 null，表示取不到有效值。
     * @param integer $Bitrate 码率，单位：bps。
注意：此字段可能返回 null，表示取不到有效值。
     * @param integer $Duration 音频时长，单位：ms。
注意：此字段可能返回 null，表示取不到有效值。
     */
    function __construct()
    {

    }

    /**
     * For internal only. DO NOT USE IT.
     */
    public function deserialize($param)
    {
        if ($param === null) {
            return;
        }
        if (array_key_exists("Stream",$param) and $param["Stream"] !== null) {
            $this->Stream = $param["Stream"];
        }

        if (array_key_exists("Sample",$param) and $param["Sample"] !== null) {
            $this->Sample = $param["Sample"];
        }

        if (array_key_exists("Channel",$param) and $param["Channel"] !== null) {
            $this->Channel = $param["Channel"];
        }

        if (array_key_exists("Codec",$param) and $param["Codec"] !== null) {
            $this->Codec = $param["Codec"];
        }

        if (array_key_exists("Bitrate",$param) and $param["Bitrate"] !== null) {
            $this->Bitrate = $param["Bitrate"];
        }

        if (array_key_exists("Duration",$param) and $param["Duration"] !== null) {
            $this->Duration = $param["Duration"];
        }
    }
}
